package ibase.e12ria.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.geolocation.client.Position;
import com.google.gwt.geolocation.client.PositionError;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NamedNodeMap;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import com.google.gwt.xslt.client.XsltProcessor;

import ibase.e12ria.client.E12CustomPlugin.CallBack;
import ibase.e12ria.client.E12Global.ConnectionMode;
import ibase.e12ria.client.E12RequestBuilder.RequestDataKeys;
import ibase.e12ria.client.resources.Resources;
import ibase.e12ria.e12table.client.ColumnInfoBean;
import ibase.e12ria.e12table.client.DataGridTableRowModel;
import ibase.e12ria.e12widgets.client.ContentUsageComponent;
import ibase.e12ria.e12widgets.client.DataSyncCache;
import ibase.e12ria.e12widgets.client.E12AlertBox;
import ibase.e12ria.e12widgets.client.E12CustomInput;
import ibase.e12ria.e12widgets.client.E12DataModelHandler;
import ibase.e12ria.e12widgets.client.E12DateBox;
import ibase.e12ria.e12widgets.client.E12EditorContainer;
import ibase.e12ria.e12widgets.client.E12HomePagePanel;
import ibase.e12ria.e12widgets.client.E12HtmlPanel;
import ibase.e12ria.e12widgets.client.E12LinkContainer;
import ibase.e12ria.e12widgets.client.E12ListBox;
import ibase.e12ria.e12widgets.client.E12OptionsModel.E12Feed;
import ibase.e12ria.e12widgets.client.handlers.CallbackHandler;
import ibase.e12ria.e12widgets.client.E12OptionsPanel;
import ibase.e12ria.e12widgets.client.E12ParentEditor;
import ibase.e12ria.e12widgets.client.E12PophelpInfo;
import ibase.e12ria.e12widgets.client.E12PopupContainer;
import ibase.e12ria.e12widgets.client.E12PopupPanel;
import ibase.e12ria.e12widgets.client.E12ProcessEditor;
import ibase.e12ria.e12widgets.client.E12Report;
import ibase.e12ria.e12widgets.client.E12TextBox;
import ibase.e12ria.e12widgets.client.E12TransEditor;
import ibase.e12ria.e12widgets.client.EntryWrapper;
import ibase.e12ria.e12widgets.client.Feed;
import ibase.e12ria.e12widgets.client.Geolocation;
import ibase.e12ria.e12widgets.client.HomePgActionInfoBean;
import ibase.e12ria.e12widgets.client.ME12Dashboard;
import ibase.e12ria.e12widgets.client.ME12FeedDetailForm;
import ibase.e12ria.e12widgets.client.PanelLabel;
import ibase.e12ria.e12widgets.client.WallToWallPanel;
import ibase.e12ria.e12widgets.collections.FeedData;
import ibase.e12ria.e12widgets.shared.E12Storage;
import ibase.e12ria.social.client.util.E12PluginUtils;
import ibase.gwt.client.calendar.client.E12CalendarController;

public class E12CommonUtils extends ibase.e12ria.e12widgets.shared.E12CommonUtils
{
	static E12CommonUtils e12CommonUtils = null;
	private StringBuffer pkFieldNames;  // Added by Bhupendra on 13-Jan-17 for [ Summary Page implementation in Mobile Editor ] Starts
	private VerticalPanel sidePnlPopupContainer = null;
	private E12SidePanelContainers e12SidePanelContainers = null;
	//Added by Shrutika on 27-08-18 [start] for avoid multiple server call for getting tab order data.
	private HashMap<String, String> tabsepratedDataMap = new HashMap<String, String>();

	public HashMap<String, String> getTabsepratedDataMap() {
		return tabsepratedDataMap;
	}
	public void setTabsepratedDataMap(HashMap<String, String> tabsepratedDataMap) {
		this.tabsepratedDataMap = tabsepratedDataMap;
	}
	//Added by Shrutika on 27-08-18 [end] for avoid multiple server call for getting tab order data.


	//Added by shrutika on 27-08-18 [Start] for getting tab orderwise data.
	private String tabSepratedCopyData;
	public String getTabSepratedCopyData() {
		return tabSepratedCopyData;
	}
	public void setTabSepratedCopyData(String tabSepratedCopyData) {
		this.tabSepratedCopyData = tabSepratedCopyData;
	}
	//Added by shrutika on 27-08-18 [End] for getting tab orderwise data.
	//Added by Mayur on 30-09-20 to set Dimension Format Values [start]
    Image expandCollapseImg = new Image();
    public Image getExpandCollapseImg() {
        return expandCollapseImg;
    }
    public void setExpandCollapseImg(Image expandCollapseImg) {
        this.expandCollapseImg = expandCollapseImg;
    }
	String lenghtId = "", widthId = "", heightId = "";
	public String getLenghtId() {
		return lenghtId;
	}
    public void setLenghtId(String lenghtId) {
		this.lenghtId = lenghtId;
	}
    public String getWidthId() {
		return widthId;
	}
    public void setWidthId(String widthId) {
		this.widthId = widthId;
	}
    public String getHeightId() {
		return heightId;
	}
    public void setHeightId(String heightId) {
		this.heightId = heightId;
	}
	//Added by Mayur on 30-09-20 to set Dimension Format Values [end]
    public static E12CommonUtils getInstance()
	{
		try
		{
			if (e12CommonUtils == null)
			{
				e12CommonUtils = new E12CommonUtils();
				//Added by Dnyaneshwar Chavan on 4-Dec-13 [ capture img using device camer] Start
				exportCaptureImgMethod();
			}
		}
		catch (Exception e)
		{
			Window.alert("Exception : E12CommonUtils getInstance "+e.getMessage());
			e.printStackTrace();
		}
		return e12CommonUtils;
	}

	public static String checkNull( String value )
	{
		if( value == "undefined" || value == null || value.equalsIgnoreCase("null")) //Changed by Savita Yadav on 18-3-15
		{
			value = "";
		}
		return value.trim();
	}

	/**
	 * It puts actual physical names of the columns in a array list & returns the same.
	 *
	 * @param colInfoNodeLst
	 * @return phyNameList
	 */
	private ArrayList<String> getColPhysicalNameList(NodeList colInfoNodeLst)
	{
		ArrayList<String> phyNameList = new ArrayList<String>();

		for (int i = 0; i < colInfoNodeLst.getLength(); i++)
		{
			String physicalName = colInfoNodeLst.item(i).getAttributes().getNamedItem("physicalName").getNodeValue();
			String[] actualPhyName = physicalName.split("\\.");// To remove table's name as physical names are in the
			phyNameList.add(actualPhyName[1]); // form sorder.order_date
		}

		return phyNameList;
	}

	// Added by Swapnil ph. on 26/11/11/ [DC1HSUN002| ] start
	/**
	 * It puts Logical names of the columns in a array list & returns the same.
	 *
	 * @param colInfoNodeLst
	 * @return
	 */
	private static ArrayList<String> getColLogicalNameList(NodeList colInfoNodeLst)
	{
		ArrayList<String> logicalNameList = new ArrayList<String>();

		for (int i = 0; i < colInfoNodeLst.getLength(); i++)
		{
			String logicalName = colInfoNodeLst.item(i).getAttributes().getNamedItem("logicalName").getNodeValue();
			logicalNameList.add(logicalName);
		}

		return logicalNameList;
	}

	// Added by Swapnil ph. on 26/11/11/ [DC1HSUN002| ] start
	/**
	 * It puts display names of the columns in a array list & returns the same.
	 *
	 * @param colInfoNodeLst
	 * @return displayNameList
	 */
	private static ArrayList<String> getColDisplayNameList(NodeList colInfoNodeLst)
	{
		ArrayList<String> displayNameList = new ArrayList<String>();

		for (int i = 0; i < colInfoNodeLst.getLength(); i++)
		{
			String displayName = colInfoNodeLst.item(i).getAttributes().getNamedItem("displayName").getNodeValue();
			displayNameList.add(displayName);
		}

		return displayNameList;
	}

	/**
	 * To parse the element wise
	 * @param tokenizedStr
	 * @return
	 */
	public HashMap<String, ArrayList> parseTokenizedString(String tokenizedStr)
	{
		HashMap<String, ArrayList> tokenMainMap = new HashMap<String, ArrayList>();
		try
		{

			String[] elementsStrArr = tokenizedStr.split( TokenType.ELEMSEP );
			ArrayList< HashMap<String, String> > colObjStrArr = new ArrayList< HashMap<String, String> > ();
			ArrayList< HashMap<String, String> >  txtObjStrArr = new ArrayList< HashMap<String, String> > ();
			ArrayList< HashMap<String, String> > tableColObjStrArr = new ArrayList< HashMap<String, String> > ();
			ArrayList< HashMap<String, String> > groupArr = new ArrayList< HashMap<String, String> > ();
			//Added By Ajinkya Gopalkar on 04-Oct-16[For getting group tag information]
			ArrayList< HashMap<String, String> > grpObjStrArr = new ArrayList< HashMap<String, String> > ();
			for( int ctr = 0; ctr < elementsStrArr.length; ctr++ )
			{
				String[] strTok = elementsStrArr[ctr].split( TokenType.OBJSEP );
				HashMap<String, String> tokenMap = parseTokens( strTok[1] );
				if( strTok[0].equalsIgnoreCase("ColumnObject") )
				{
					colObjStrArr.add( tokenMap );
				}
				else if( strTok[0].equalsIgnoreCase("TextObject") )
				{
					txtObjStrArr.add( tokenMap );
				}
				else if( strTok[0].equalsIgnoreCase("table_column") )
				{
					tableColObjStrArr.add( tokenMap );
				}
				else if( strTok[0].equalsIgnoreCase("GroupBox") ) //Changed by Lokesh on 12-Aug-2016
				{
					groupArr.add( tokenMap );
				}
				//Added By Ajinkya Gopalkar on 04-Oct-16[For getting group tag information]
				else if( strTok[0].equalsIgnoreCase("group") )
				{
					grpObjStrArr.add( tokenMap );
				}
			}
			tokenMainMap.put( "ColumnObject", colObjStrArr );
			tokenMainMap.put( "TextObject", txtObjStrArr );
			tokenMainMap.put( "table_column", tableColObjStrArr );
			tokenMainMap.put( "group", grpObjStrArr );
			tokenMainMap.put( "GroupBox", groupArr ); ////Changed by Lokesh on 12-Aug-2016
		}
		catch (Exception e)
		{
			Window.alert("parseTokenizedString Exception[" + e.getMessage() + "]");
		}
		return tokenMainMap;
	}

	/**
	 * To parse the Elements
	 * @param tokenizedStr
	 * @return
	 */
	private HashMap<String, String> parseTokens(String tokenizedStr)
	{
		HashMap<String, String> tokenMap = new HashMap<String, String>();
		String[] strMainTok = tokenizedStr.split( TokenType.PROPSEP );
		for(int i = 0; i < strMainTok.length; i++)
		{
			String[] strTok = strMainTok[i].split( TokenType.PROPVALSEP );
			String strTok0 = strTok[0];
			String strTok1;
			if( strTok.length > 1 )
			{
				strTok1 = strTok[1];
			}
			else
			{
				strTok1 = "";
			}
			tokenMap.put( strTok0, E12Global.checkNull( strTok1 ) );
		}
		return tokenMap;
	}

	/**
	 * To parse the element wise
	 * @param metadataXMLStr
	 * @return
	 */
	public HashMap<String, ArrayList> parseMetadataXML(String metadataXMLStr)
	{
		HashMap<String, ArrayList> nodeMainMap = new HashMap<String, ArrayList>();

		Document doc = XMLParser.parse(metadataXMLStr);
		XMLParser.removeWhitespace(doc);

		NodeList colNodeList = doc.getElementsByTagName("ColumnObject");
		NodeList txtNodeList = doc.getElementsByTagName("TextObject");
		NodeList tblNodeList = doc.getElementsByTagName("table_column");

		ArrayList< HashMap<String, String> > colObjStrArr = new ArrayList< HashMap<String, String> > ();
		ArrayList< HashMap<String, String> >  txtObjStrArr = new ArrayList< HashMap<String, String> > ();
		ArrayList< HashMap<String, String> > tableColObjStrArr = new ArrayList< HashMap<String, String> > ();

		int len = colNodeList.getLength();
		for( int cntr = 0; cntr < len; cntr++ )
		{
			Node colObjNode = colNodeList.item(cntr);
			colObjStrArr.add( parseNode(colObjNode) );
		}

		len = txtNodeList.getLength();
		for( int cntr = 0; cntr < len; cntr++ )
		{
			Node txtObjNode = txtNodeList.item(cntr);
			txtObjStrArr.add( parseNode(txtObjNode) );
		}

		len = tblNodeList.getLength();
		for( int cntr = 0; cntr < len; cntr++ )
		{
			Node tblObjNode = tblNodeList.item(cntr);
			tableColObjStrArr.add( parseNode(tblObjNode) );
		}

		nodeMainMap.put( "ColumnObject", colObjStrArr );
		nodeMainMap.put( "TextObject", txtObjStrArr );
		nodeMainMap.put( "table_column", tableColObjStrArr );

		return nodeMainMap;
	}

	/**
	 * To parse the Elements
	 * @param metadataNodeStr
	 * @return
	 */
	public HashMap<String, String> parseNode(Node elementNode)
	{
		HashMap<String, String> nodeMap = new HashMap<String, String>();

		nodeMap = processAttributes(elementNode);

		NodeList childNodeList = elementNode.getChildNodes();
		int len = 0;
		if( childNodeList != null )
		{
			len = childNodeList.getLength();
		}
		for( int cntr = 0; cntr < len; cntr++ )
		{
			Node childElmNode = childNodeList.item(cntr);
			if( childElmNode != null )
			{
				HashMap<String, String> attribMap = processAttributes(childElmNode);
				String nodeName = childElmNode.getNodeName();
				String nodeValue = "";
				if( childElmNode.getFirstChild() != null )
				{
					nodeValue = childElmNode.getFirstChild().getNodeValue();
				}
				else
				{
					nodeValue = childElmNode.getNodeValue();
				}
				nodeMap.put(nodeName, nodeValue);
				if( attribMap != null )
				{
					nodeMap.putAll(attribMap);
				}
			}
		}
		return nodeMap;
	}

	private HashMap<String, String> processAttributes( Node node )
	{
		HashMap<String, String> attribMap = null;
		if( node.hasAttributes() )
		{
			attribMap = new HashMap<String, String>();
			NamedNodeMap attributes = node.getAttributes();
			int len = 0;
			if( attributes != null )
			{
				len = attributes.getLength();
			}
			for( int cntr = 0; cntr < len; cntr++ )
			{
				Node attribNode = attributes.item(cntr);
				if( attribNode != null )
				{
					if( attribNode.getNodeType() == Node.ATTRIBUTE_NODE )
					{
						String nodeName = node.getNodeName() + "." + attribNode.getNodeName();
						String nodeValue = attribNode.getNodeValue();
						attribMap.put(nodeName, nodeValue);
					}
				}
			}
		}
		return attribMap;
	}

	/**
	 * @param date
	 * @return true
	 * It checks Whether the given String is date.
	 */
	public boolean isValidDate( String date )
	{
		DateTimeFormat dtf = DateTimeFormat.getFormat( E12Constants.dispDate );
		Date testDate = null;
		try
		{
			testDate = dtf.parse(  date  );
		}
		catch ( IllegalArgumentException e )
		{
			return false;
		}
		return true;
	}

	HashMap<String, LinkActionInfoBean> linkActionInfoMap;
	public HashMap<String, LinkActionInfoBean> getLinkActionInfoMap( String objName )
	{
		linkActionInfoMap=new HashMap<String, LinkActionInfoBean>();
		//Added by Swapnil ph on 4-04-2012 [ to provide the links as per right_char ]start
		//Changed By Mahesh Patidar on 28/DEC/12
		HashMap<String, String> paramMap = new HashMap<String, String>();

		paramMap.put("ACTION", "GET_LINKS" );
		paramMap.put("OBJ_CTXT", "1" );
		paramMap.put("OBJ_NAME", objName );
		String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);

		//Changed by Reema on 12-09-14
		String url = E12Global.getHostUrl()+ "/ibase/WebITMLinkControllerServlet?" + paramString;

		//Changed By Savita Yadav on 29-11-2014 [For Multi-Language]
		E12Global.getInstance().setLoadingInfo(E12Constants.constants.setLoadingInfoAlert());
		//String url = "/ibase/WebITMLinkControllerServlet?" + paramString;
		//String url = "/ibase/WebITMLinkControllerServlet?ACTION=GET_LINKS&OBJ_CTXT=1&OBJ_NAME="+objName;
		//Ended By Mahesh Patidar

		//Added by Dnyaneshwar on 27-JUN-13 [Check network is available or not ] Statr
		if( ! CommonPhoneGapUtil.checkNetworkAndMode() )
		{
			Window.alert(E12Constants.constants.setNoNetWork() );    //Changes by Raju 19-02-14 for I18N
		}
		else
		{
			E12RequestBuilder reqstBldr =new E12RequestBuilder( E12RequestBuilder.GET, url );
			try
			{
				reqstBldr.sendRequest( "", new RequestCallback()
				{
					public void onResponseReceived( Request request, Response response )
					{
						String responseStr  = response.getText();
						//Added by Reema on 16-09-14 [handle if null or blank response]
						if(responseStr == "" || responseStr == null){

						}
						else
						//Added by Reema on 16-09-14 [handle if null or blank response]-End
						{
							Document document = XMLParser.parse( responseStr );
							XMLParser.removeWhitespace( document );
							NodeList linksInfoLst = document.getElementsByTagName( "Link" );
							final int linkLen = linksInfoLst.getLength();

							for( int i = 0; i < linkLen; i++)
							{
								NodeList linksItemInfoLst = linksInfoLst.item(i).getChildNodes();

								String linkFormNoNode = linksInfoLst.item(i).getAttributes().getNamedItem("formNo").getNodeValue();

								String linkTergetObjNode= linksItemInfoLst.item(0).getFirstChild().getNodeValue();
								String linkFormNode=linksItemInfoLst.item(1).getFirstChild().getNodeValue();
								String linkTitleNode=linksItemInfoLst.item(2).getFirstChild().getNodeValue();
								String linkUriNode=linksItemInfoLst.item(3).getFirstChild().getNodeValue();
								String linkTypeNode=linksItemInfoLst.item(4).getFirstChild().getNodeValue();
								String linkArgNode =linksItemInfoLst.item(5).getFirstChild().getNodeValue();
								String linkUpdtFlag = linksItemInfoLst.item(6).getFirstChild().getNodeValue();
								String linkRightChar = linksItemInfoLst.item(7).getFirstChild().getNodeValue();
								//Changed by parikshit on 07/10/16 [added linkImageUrl in linkActionInfoBean]
								//LinkActionInfoBean linkActionInfoBean = new LinkActionInfoBean( linkTergetObjNode, linkFormNoNode, linkTitleNode, linkUriNode, linkTypeNode, linkArgNode,  linkFormNode, linkUpdtFlag, linkRightChar) ;
								String linkImageUrl = linksItemInfoLst.item(8).getFirstChild().getNodeValue();
								String showInPanel = linksItemInfoLst.item(9).getFirstChild().getNodeValue();//added by vishal pathare on 26.5.17 for[subheader implementation in compact view for Browser].
								//Changed By Pankaj T. on 26-09-18 add column show_confirm &display_mode for links configuration
								String showConfirm = linksItemInfoLst.item(10).getFirstChild().getNodeValue();
								String displayMode = linksItemInfoLst.item(11).getFirstChild().getNodeValue();
								//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no - start
								String lineNo = linksItemInfoLst.item(12).getFirstChild().getNodeValue();
								//Added by shrutika on 27-02-19 added new column linkId for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
								String linkId = linksItemInfoLst.item(13).getFirstChild().getNodeValue();
								//Added by Pratheek on 25-06-19[ added new column in obj_action and obj_links table to add the record specific action and links in more button in home page ]-Start
								String recordSpecific = linksItemInfoLst.item(14).getFirstChild().getNodeValue();
								LinkActionInfoBean linkActionInfoBean = new LinkActionInfoBean( linkTergetObjNode, linkFormNoNode, linkTitleNode, linkUriNode, linkTypeNode, linkArgNode,  linkFormNode, linkUpdtFlag, linkRightChar, linkImageUrl,showInPanel, showConfirm, displayMode, lineNo, linkId,recordSpecific) ;
								//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no - end
								//Button linkActionBtn = new Button(linkTitleNode);
								linkActionInfoMap.put(linkTitleNode, linkActionInfoBean);

								//linkActionBtn.setStylePrimaryName("linkActionBtn");
								//vertPanel.add( linkActionBtn );
							}
						}
					}

					@Override
					public void onError( Request request, Throwable exception )
					{
						// TODO Auto-generated method stub
					}
				});
			}
			catch (Exception e)
			{
				Window.alert( " Exception in getting links" + e.getMessage() );
			}
		}
		//Added by Dnyaneshwar on 27-JUN-13 [Check network is available or not ] End

		//Added by Swapnil ph on 4-04-2012 [ to provide the links as per right_char ]End.
		//Window.alert("linkActionInfoMap[" + linkActionInfoMap + "]");
		return linkActionInfoMap;
	}
	/**
	 * This method is return true if focus set on widget otherwise return false
	 *
	 * @param firstEditable's widget
	 * */
	public boolean isFocusable( Widget firstEditable )
	{
		if( firstEditable == null )
		{
			return false;
		}
		String className = firstEditable.getClass().toString();
		className = className.substring(className.lastIndexOf(".") + 1, className.length());
		//Window.alert("className ["+className+"]");
		if( "TextBox".equalsIgnoreCase(className) )//Removed TextBox as used E12TextBox
		{/*
			final TextBox txtBox = (TextBox) firstEditable;
			if( txtBox.isEnabled() && txtBox.isVisible() )
			{
				new Timer()
				{
					@Override
					public void run()
					{
						txtBox.setFocus(true);
						txtBox.selectAll();
					}

				}.schedule( 1 );
				return true;

			}

		 */}
		else if( "DateBox".equalsIgnoreCase( className ) )
		{
			final E12DateBox dateBox = (E12DateBox) firstEditable;
			if( dateBox.isVisible() && dateBox.isEnabled() )
			{
				new Timer()
				{
					@Override
					public void run()
					{
						dateBox.setFocus(true);
					}
				}.schedule( 1 );
				return true;
			}
		}
		else if( "ListBox".equalsIgnoreCase( className ) )
		{
			final E12ListBox listBox = (E12ListBox) firstEditable;
			if( listBox.isVisible() && listBox.isEnabled() )
			{
				new Timer()
				{
					@Override
					public void run()
					{
						listBox.setFocus(true);
					}
				}.schedule( 1 );
				return true;
			}
		}
		else if( "E12TextBox".equalsIgnoreCase(className) )
		{
			final E12TextBox numTxtBox = (E12TextBox) firstEditable;
			if( numTxtBox.isVisible() && numTxtBox.isEnabled() )
			{
				new Timer()
				{
					@Override
					public void run()
					{
						numTxtBox.setFocus(true);
						numTxtBox.selectAll();
					}
				}.schedule( 1 );
				return true;
			}
		}
		else if( "TextArea".equalsIgnoreCase(className) )
		{
			final TextArea txtArea = (TextArea) firstEditable;
			if( txtArea.isVisible() && txtArea.isEnabled() )
			{
				new Timer()
				{
					@Override
					public void run()
					{
						txtArea.setFocus(true);
					}
				}.schedule( 1 );
				return true;
			}
		}
		else if( "CheckBox".equalsIgnoreCase(className) )
		{
			final E12CheckBox checkBox = (E12CheckBox) firstEditable;
			if( checkBox.isVisible() && checkBox.isEnabled() )
			{
				new Timer()
				{
					@Override
					public void run()
					{
						checkBox.setFocus(true);
					}
				}.schedule( 1 );
				return true;
			}
		}
		return false;
	}

	/**
	 * This method parse the xml <br>
	 * and set the values are data member of E12Constants class
	 *
	 * @param loginResponse is a xml
	 */
	public void setE12Constants( String loginResponse )
	{
		if( loginResponse == null )
		{
			return;
		}

		//Added by Prajyot on 14 Mar 13 [Reset e12Constants after re-login  ]START
		resetE12Constants();

		//Added by Prasad on 20/02/18 [to set userInfo data in js variable]
		JSONObject userInfoJson = new JSONObject();

		Document document = XMLParser.parse( loginResponse );
		E12CommonUtils.printOnConsole("Parsed LoginResponse!!!["+document+"]");

		XMLParser.removeWhitespace(document);
		NodeList childNodeList = document.getElementsByTagName("Root").item(0).getChildNodes();

		int len = childNodeList.getLength();
		for( int index = 0; index < len; index ++ )
		{
			Node currNode = childNodeList.item( index );
			String nodeName = currNode.getNodeName();
			String nodeValue = "";

			if( currNode.getFirstChild() != null &&  currNode.getFirstChild().getNodeType() == Node.CDATA_SECTION_NODE )
			{
				nodeValue = currNode.getFirstChild().getNodeValue();
				//Added by Prasad on 20/02/18 [to set userInfo data in js variable]
				userInfoJson.put( nodeName, new JSONString( nodeValue ) );
			}
			if( "status".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.authenticateStatus = nodeValue;
			}
			else if( "userID".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.userID = nodeValue;
				setDOMIDValue( "userID", E12Constants.userID); //Added
			}
			// Added by Sandesh on 23.02.2016 [Reqest Id:S15KBAS001] End
			else if( "isPasswordStore".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.isPasswordStore = nodeValue;
			}
			// Added by Sandesh on 23.02.2016 [Reqest Id:S15KBAS001] End
			else if( "profileID".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.profileID = nodeValue;
			}
			else if( "empDesignation".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.empDesignation = nodeValue;
				setDOMIDValue( "empDesignation", E12Constants.empDesignation); //Added By Lokesh on 21-NOV-2013 for user information
			}
			else if( "empDivision".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.empDivision = nodeValue;
			}
			else if( "empHeadQuat".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.empHeadQuat = nodeValue;
			}
			else if( "empDOJ".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.empDOJ = nodeValue;
			}
			else if( "dispDate".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.dispDate = nodeValue;
			}
			else if( "userLevel".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.userLevel = nodeValue;
			}
			//Added by Harshada on 6 MAR 2013 [Get all user information on authentication]START
			else if( "siteDescr".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.siteDescr = nodeValue;
			}
			else if( "deptDescr".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.deptDescr = nodeValue;
			}
			else if( "emailIdOff".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.emailIdOff = nodeValue;
			}
			else if( "empCode".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.empCode = nodeValue;
				setDOMIDValue( "empCode", E12Constants.empCode); //Added By Lokesh on 21-NOV-2013 for user information
			}
			else if( "empName".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.empName = nodeValue;
				setDOMIDValue( "empName", E12Constants.empName); //Added By Lokesh on 21-NOV-2013 for user information
				E12Storage.setItem("USERNAME",nodeValue);
			}
			else if( "reportTo".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.reportTo = nodeValue;
			}
			else if( "stanCode".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.stanCode = nodeValue;
			}
			else if( "userCountry".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.userCountry = nodeValue;
			}
			else if( "userLanguage".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.userLanguage = nodeValue;
			}
			else if( "entityCode".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.entityCode = nodeValue;
			}
			else if( "itemSer".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.itemSer = nodeValue;
			}
			else if( "deptCode".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.deptCode = nodeValue ;
				setDOMIDValue("deptCode", E12Constants.deptCode ); //Added By Lokesh on 21-NOV-2013 for user information
			}
			//Added By Savita Yadav on 8-04-2015 [for ChangePassword UI]-Start
			else if( "minPwdLen".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.minPwdLen = nodeValue ;
				setDOMIDValue("minPwdLen", E12Constants.minPwdLen );
			}
			//Added By Savita Yadav on 8-04-2015 [for ChangePassword UI]-End
			//Added by Harshada on 6 MAR 2013 [Get all user information on authentication]END
			else if( "applDateTimeFromat".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.applDateTimeFormat = nodeValue ;
			}
			//Added by Reema on 11-Sep-15[save data for GPSTracking]-Start
			else if( "geoFenceEnabled".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.GEO_FENCE_ENABLED = nodeValue ;
			}
			else if( "geoFenceAccuracy".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.GEO_FENCE_ACCURACY = nodeValue ;
			}
			else if( "geoFenceRadius".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.GEO_FENCE_RADIUS = nodeValue ;
			}
			// Added by Sandeshs 09-Feb-2016 [Req:S15JBAS002 Social Post] start
			else if( "userName".equalsIgnoreCase( nodeName ) )
			{
				E12Constants.userName = nodeValue;
			}
			// Added by Sandeshs 09-Feb-2016 [Req:S15JBAS002 Social Post] end
			//Added by Reema on 11-Sep-15[save data for GPSTracking]-End
			// Added by Sandeshs 21-Jun-2016 [Req:W15BSUN011] START
			else if( "defaultMenu".equalsIgnoreCase( nodeName ) )
			{
				nodeValue = E12Global.checkNull( nodeValue );
				//Changed By Suraj on 15-03-2017 [To set default menu path]Start
				if( nodeValue == null || "".equalsIgnoreCase(nodeValue) || "null".equalsIgnoreCase(nodeValue) )
				{
					//E12Constants.defaultMenu = "dashboard";
					E12Constants.defaultMenu = "DAS.";
				}
				else if( nodeValue.startsWith("EXP") || nodeValue.startsWith("FAV") )
				{
					E12Constants.defaultMenu = "DAS.";
				}
				else
				{
					E12Constants.defaultMenu = nodeValue;
				}
				//Changed By Suraj on 15-03-2017 [To set default menu path]End
			}
			// Added by Sandeshs 21-Jun-2016 [Req:W15BSUN011] END
			//Added By Suraj on 20-March-2017 [To configure slide menu panel footer options]Start
			else if( "features".equalsIgnoreCase( nodeName ) )
			{
				if( nodeValue == null || "".equalsIgnoreCase(nodeValue) || "null".equalsIgnoreCase(nodeValue) )
				{
					E12Constants.featureOptions = "";
				}
				else
				{
					E12Constants.featureOptions = nodeValue;
				}
			}
			//Added By Suraj on 20-March-2017 [To configure slide menu panel footer options]End
			//Added By Sanket J on 04/08/17 for getting userType if employee is not present for password change[Start]
			else if( "userType".equalsIgnoreCase( nodeName ))
			{
				E12Constants.userType = nodeValue;
			}
			//Added By Sanket J on 04/08/17 for getting userType if employee is not present for password change[End]
			//Added by Sagar B. for geo position related changes for multi tenency[12/jan/18]START
			else if( "geoPosOption".equalsIgnoreCase( nodeName ))
			{
				E12Constants.GEO_POS_OPTION = nodeValue;
				E12Storage.setItem("GEO_POS_OPTION", E12Constants.GEO_POS_OPTION);
				//Added by Pratheek on 04-07-19[ to stop calling the gps and network plugin on opening mobile in browser]-Start
				E12CommonUtils.printOnConsole("E12CommonUtils IShOSTEDMODE 866!!!["+E12Global.getInstance().isHostedMode()+"]");
				if( !E12Global.getInstance().isHostedMode())
				{
					E12CustomPlugin.setGPSEnforcedVal( E12Constants.GEO_POS_OPTION );
				}
				//Added by Pratheek on 04-07-19[ to stop calling the gps and network plugin on opening mobile in browser]-End
				E12CommonUtils.printOnConsole("In setE12Constants GEO_POS_OPTION:["+E12Constants.GEO_POS_OPTION);
			}
			//Added by Sagar B. for geo position related changes for multi tenency[12/jan/18]END
			//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
			else if( "enterprise".equalsIgnoreCase( nodeName ))
			{
				E12Constants.enterprise = nodeValue;
				E12CommonUtils.printOnConsole("In setE12Constants enterprise:["+E12Constants.enterprise);
				//Added by sunny soni for passing enterprise name to inject css file as per enterprisName on 25-Nov-21[Start]
				String enterpriseName = E12CommonUtils.checkNull(E12Constants.enterprise);
				E12CommonUtils.printOnConsole("In Mobile enterpriseName::["+enterpriseName+"]");
				if (enterpriseName.length() > 0) {
					injectCssFile(enterpriseName);
				}
				//Added by sunny soni for passing enterprise name to inject css file as per enterprisName on 25-Nov-21[End]
			}
			
			//Added by jay for setting social_opt value from enterprise table - start
			else if( "social_opt".equalsIgnoreCase( nodeName ) )
			{
				if( nodeValue == null || "".equalsIgnoreCase(nodeValue) || "null".equalsIgnoreCase(nodeValue) )
				{
					E12Constants.social_opt = "";
				}
				else
				{
					E12Constants.social_opt = nodeValue;
				}
			}
			//Added by jay for setting social_opt value from enterprise table - End

			//Added by Pankaj T. on 16-11-18 for console configuration if 1 then print console only - start
			else if( "clientDebugLevel".equalsIgnoreCase( nodeName ))
			{
				E12Constants.clientDebugLevel = nodeValue;
				E12CommonUtils.printOnConsole("In setE12Constants clientDebugLevel:["+E12Constants.clientDebugLevel);
			}
			//Added by Pankaj T. on 16-11-18 for console configuration if 1 then print console only - end
			//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - start
			else if( "wrongLoginCount".equalsIgnoreCase( nodeName ))
			{
				E12Constants.wrongLoginCount = nodeValue;
				E12CommonUtils.printOnConsole("In setE12Constants wrongLoginCount:["+E12Constants.wrongLoginCount);
			}
			//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - end
			//Added by Pratheek on 04-02-19[]to store the fin_entity and facilty_code on login-Start
			else if( "facility_code".equalsIgnoreCase( nodeName ))
			{
				E12Constants.facility_code = nodeValue;
			}
			else if( "fin_entity".equalsIgnoreCase( nodeName ))
			{
				E12Constants.fin_entity = nodeValue;
			}
			//Added by Sagar B. for geo position related changes for multi tenency[12/jan/18]START
			else if( "networkOption".equalsIgnoreCase( nodeName ))
			{
				E12Constants.NETWORK_OPTION = nodeValue;
				E12Storage.setItem("NETWORK_OPTION", E12Constants.NETWORK_OPTION);
				//Added by Pratheek on 04-07-19[ to stop calling the gps and network plugin on opening mobile in browser]-Start
				E12CommonUtils.printOnConsole("E12CommonUtils NETWORK_OPTION 4702!!!["+E12Global.getInstance().isHostedMode()+"]");
				if( !E12Global.getInstance().isHostedMode())
				{
					E12CustomPlugin.setNetworkOptionVal( E12Constants.NETWORK_OPTION );
				}
				//Added by Pratheek on 04-07-19[ to stop calling the gps and network plugin on opening mobile in browser]-End
				E12CommonUtils.printOnConsole("In setE12Constants NETWORK_OPTION:["+E12Constants.NETWORK_OPTION);
			}
			//Added by Sagar B. for geo position related changes for multi tenency[12/jan/18]END
			// Added by Pankaj R on 25-FEB-19 to store value of auto sync in E12Constant from ibase.xml [START]
			else if( "autoSync".equalsIgnoreCase( nodeName ))
			{
				E12Constants.autoSync = nodeValue;
				E12CommonUtils.printOnConsole("In setE12Constants autoSync:["+E12Constants.autoSync);
			}
			// Added by Pankaj R on 25-FEB-19 to store value of auto sync in E12Constant from ibase.xml [END]
			//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]START
			else if( "isAllowOfflineEdit".equalsIgnoreCase( nodeName ))
			{
				E12Constants.IS_ALLOW_OFFLINE_EDIT = nodeValue;
				//E12Storage.setItem("IS_ALLOW_OFFLINE_EDIT", E12Constants.IS_ALLOW_OFFLINE_EDIT);
				E12CommonUtils.printOnConsole("In setE12Constants IS_ALLOW_OFFLINE_EDIT:["+E12Constants.IS_ALLOW_OFFLINE_EDIT);
			}
			else if( "isAllowOfflineDelete".equalsIgnoreCase( nodeName ))
			{
				E12Constants.IS_ALLOW_OFFLINE_DELETE = nodeValue;
				//E12Storage.setItem("IS_ALLOW_OFFLINE_DELETE", E12Constants.IS_ALLOW_OFFLINE_DELETE);
				E12CommonUtils.printOnConsole("In setE12Constants IS_ALLOW_OFFLINE_DELETE:["+E12Constants.IS_ALLOW_OFFLINE_DELETE);
			}
			//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]END
			E12CommonUtils.printOnConsole("in setObjActionsData finEntity 881!!!["+ E12Constants.fin_entity +"] facility_code ["+E12Constants.facility_code+"]");
			//Added by Pratheek on 04-02-19[]to store the fin_entity and facilty_code on login-End
		}
		//Added by Prasad on 20/02/18 [to set userInfo data in js variable]
		setUserInfo(userInfoJson);
	}

	//Added By Mahesh Patidar on 27-DEC-12 for get the encoded param String from HashMap
	/**
	 * This method Return the encoded url parameter string
	 *
	 * @param paramMap is a Map
	 */

	public String getEncodedParamString( Map<String, String> paramMap )
	{
		String encodedString = "";
		//E12CommonUtils.printOnConsole("getEncodedParamString paramMap : "+paramMap);
		for (Entry<String, String> entry : paramMap.entrySet())
		{
			String key=E12CommonUtils.checkNull(entry.getKey());
			String value=E12CommonUtils.checkNull(entry.getValue());
			if(value == null)
			{
				value = "";
			}
			encodedString += URL.encodeComponent(key) + "=" + URL.encodeComponent(value) + "&";
		}
		encodedString = encodedString.substring(0,encodedString.length()-1);
		return encodedString;
	}
	//Ended By Mahesh Patidar

	//Added by Prajyot [For getting Attribute value]
	public static String getAttribValue(Node node, String attributeName)
	{
		String attribValue = "";
		try
		{
			if( node != null && node.getAttributes() != null)
			{
				Node attribNode = node.getAttributes().getNamedItem( attributeName );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			Window.alert("E21CommonUtils Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	//Added by Dnyaneshwar Chavan on 26-Feb-2013 Start
	/**
	 *@return The total height of the visitor's screen, in pixels.
	 * */
	public native static int getScreenHeight(boolean isHosted)
	/*-{
		var deviceHeight;
		if (navigator.userAgent.indexOf('Android') >= 0 ) {
			deviceHeight = window.screen.height;
			if (! isHosted && window.devicePixelRatio) {
				deviceHeight = deviceHeight / window.devicePixelRatio;
			}
		}
		else
		{
		 deviceHeight = (window.orientation == 90 || window.orientation == -90) ?  window.screen.width : window.screen.height;
		}
		return deviceHeight;
	}-*/;

	/**
	 *@return The total width of the visitor's screen, in pixels.
	 * */
	public native static int getScreenWidth(boolean isHosted)
	/*-{
		var deviceWidth;

		if (navigator.userAgent.indexOf('Android') >= 0 ) {
			deviceWidth = window.screen.width;
			if (! isHosted && window.devicePixelRatio) {
				deviceWidth = deviceWidth / window.devicePixelRatio;
			}
		}
		else
		{
		 	deviceWidth = (window.orientation == 90 || window.orientation == -90) ? window.screen.height : window.screen.width;
		}
		return deviceWidth;
	}-*/;
	//Added by Dnyaneshwar Chavan on 26-Feb-2013 End

	//Added by Prajyot on 14 Mar 13 [Reset e12Constants after re-login  ]START
	public void resetE12Constants()
	{
		E12Constants.authenticateStatus = "";
		E12Constants.userID = "";
		E12Constants.profileID = "";
		E12Constants.empDesignation = "";
		E12Constants.empDivision = "";
		E12Constants.empHeadQuat = "";
		E12Constants.empDOJ = "";
		E12Constants.dispDate = "";
		E12Constants.userLevel = "";
		E12Constants.siteDescr = "";
		E12Constants.deptDescr = "";
		E12Constants.emailIdOff = "";
		E12Constants.empCode = "";
		E12Constants.empName = "";
		E12Constants.reportTo = "";
		E12Constants.stanCode = "";
		E12Constants.userCountry = "";
		E12Constants.userLanguage = "";
		E12Constants.entityCode = "";
		E12Constants.itemSer = "";
		//Added By Sanket J on 04/08/17 for getting userType if employee is not present for password change
		E12Constants.userType = "";
		E12Constants.userName = "";
	}
	//Added by Prajyot on 14 Mar 13 [Reset e12Constants after re-login  ]End

	public native static void openInAppBrowser(String url, Boolean toolbar)
	/*-{
		$wnd.inAppBrow(url, toolbar);
	}-*/;

	/**
	 * This method check value is exist in given ArrayList.<BR>
	 * if it is exist return true ortherwise return false
	 *
	 * @param paramArrayList the ArrayList
	 * @param checkValue the
	 *
	 * @return if exist return true otherwise return false
	 *
	 * */
	public boolean isExistvalue( ArrayList< String > paramArrayList, String checkValue )
	{
		boolean returnValue = false;
		if( paramArrayList != null  )
		{
			for( String paramValue : paramArrayList )
			{
				if( paramValue.equals( checkValue ) )
				{
					returnValue = true;
					break;
				}
			}
		}
		return  returnValue;
	}

	//Changed By Pankaj T. on 15-11-2018 as per suggested by KB Sir comment native method & add blank static method of printOnConsole for improve performance of application - start
	public static void printOnConsole( String value )
	{
		log(value);
		//Added by Pankaj T. on 16-11-18 for console configuration if 1 then print console only - start
		if( "1".equals(E12Constants.clientDebugLevel) )
		{
			log(value);
		}
		//Added by Pankaj T. on 16-11-18 for console configuration if 1 then print console only - end
	}

	public native static void log( String value )
	/*-{
		if( typeof window.console !== "undefined" )
		{
			$wnd.consoleLog( value );
			//console.log( value );
		}
	}-*/;
	//Changed By Pankaj T. on 15-11-2018 as per suggested by KB Sir comment native method & add blank static method of printOnConsole for improve performance of application - end

	// Added By Prajyot On 26AUG2013 [For BMR Tablet Interface]
	public static native String callJSFunction( String functionName ) /*-{
		if( functionName == 'nextSection' )
		{
			$wnd.nextSection();
			return '';
		}
		else if( functionName == 'saveSection' )
		{
			$wnd.saveSection();
			return '';
		}
		else if( functionName == 'disabledAllSection' )
		{
			$wnd.disabledAllSection();
			return '';
		}
		else if( functionName == 'getObservDataXML' )
		{
			return $wnd.getObservDataXML();
		}
		//Added By Prasad on 17/08/15 [for survey function] START
		else if( functionName == 'surveyData' )
		{
			return $wnd.loadSurveyData();
		}
		else if( functionName == 'getSurveyDataXML' )
		{
			return $wnd.buildSurveyXmlString('3', 'A');
		}
		//Added By Prasad on 17/08/15 [for survey function] END
		//Added by Prasad on 31/08/17 [to survey summary] START
		else if( functionName == 'getSummarySurveyDataXML' )
		{
			return $wnd.buildSurveySummaryXmlString('3', 'A');
		}
		else if( functionName == 'getFormDataXML' )
		{
			return $wnd.buildSurveyXmlStringData('3', 'A');
		}
		//Added by Prasad on 31/08/17 [to survey summary] END
		else if( functionName.indexOf('~SEP~') )
		{
			console.log( 'callJSFunction functionName[' + functionName + ']' );
			var arr = functionName.split('~SEP~');
			functionName = arr[0];
			var funcParam = arr[1];
			console.log( 'callJSFunction [' + functionName + ']' );
			console.log( 'funcParam[' + funcParam + ']' );
			if( functionName == 'evalQuantity')
			{
				$wnd.evalQuantity( funcParam );
			}
			// for checking date is valid or not
			if( functionName == 'isValidDate' )
			{
				var maxDCRCnt = arr[2];
				var objName = arr[3];
				var valueDate = $wnd.isValidDate( funcParam, maxDCRCnt, objName );
				console.log( 'call isValidDate val[]'+valueDate);
				return valueDate;
			}
			if( functionName == 'postSaveDataXML' )
			{
				return $wnd.postSaveDataXML( funcParam );
			}
			return '';
		}
		else
		{
			alert( 'function ' + functionName + ' is undefined!!!');
			return '';
		}
	}-*/;
	//Added By Ajinkya Gopalkar on 25-May-15 [For formwise validation]
	public static String callwfValData( String currFormXml, String objContext, String action, String objName )
	{
		String hdrFormXml = DataSyncCache.getCurrent().getOfflineStateful().getFormDataOffline("1");
		hdrFormXml = "<ROOT>"+hdrFormXml+"</ROOT>";

		//Gaurav Singh on 30-MAY-2016 [ For sending all form XML data to wfValData() for CHC dashboard issue in offline | Start]
		String allFormXmlData = "";
		int noOfForms = ObjDetails.get(objName).getNoOfForms();
		E12CommonUtils.printOnConsole( "noOfForms =["+noOfForms+"]");
		for ( int i = 1; i <= noOfForms ; i++ )
		{
			allFormXmlData = allFormXmlData + DataSyncCache.getCurrent().getOfflineStateful().getFormDataOffline(""+i);;
		}
		allFormXmlData = "<Root>"+ allFormXmlData + "</Root>";
		E12CommonUtils.printOnConsole( "allFormXmlData =["+allFormXmlData+"]");
		//Gaurav Singh on 30-MAY-2016 [ For sending all form XML data to wfValData() for CHC dashboard issue in offline | End]
		return callwfValData(hdrFormXml , currFormXml, objContext, action, objName, allFormXmlData);
	}

	public static native String callwfValData( String hdrFormXml, String currFormXml, String objContext, String action, String objName, String allFormXmlData ) /*-{

		//Changed BY Suraj on 06-April
		//return $wnd.wfValData(hdrFormXml, currFormXml, objContext, action, objName, allFormXmlData);
		//Added by sunny soni of try catch for handling exception on 01-Aug-19 [Start]
		try
		{
			return $wnd.localWfValData(hdrFormXml, currFormXml, objContext, action, objName, allFormXmlData);
		}
		catch(e)
		{
			console.log('callwfValData method is not found.....!!');
	    	return 'true';
		}
		//Added by sunny soni of try catch for handling exception on 01-Aug-19 [End]
		//return $wnd.localWfValData(hdrFormXml, currFormXml, objContext, action, objName, allFormXmlData);
	}-*/;

	//Added by Dnyaneshwar Chavan on 02-OCT-13 [WS3GSUN002] [ Device ID & type store in LoginTrace table ] START
	public String getPlatFormAndDeviceType ()
	{
		String platFormAndDeviceType = "";
		if( E12Global.getInstance().getDeviceOS() == DeviceOS.Android )
		{
			if( E12Global.getInstance().isMobileDevice() )
			{
				platFormAndDeviceType = "Android Mobile";
			}
			else
			{
				platFormAndDeviceType = "Android Tablet";
			}
		}
		else if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS)
		{
			if( E12Global.getInstance().isMobileDevice() )
			{
				platFormAndDeviceType = "iOS Mobile";
			}
			else
			{
				platFormAndDeviceType = "iOS Tablet";
			}
		}
		return platFormAndDeviceType;
	}
	//Added by Dnyaneshwar Chavan on 02-OCT-13 [WS3GSUN002] [ Device ID & type store in LoginTrace table ] END

	//Added By Prajyot on 11OCT13 [BMR Wizard]
	public boolean isBMRWizard( String objName )
	{
		printOnConsole("BMR_OBJ_NAME[" + objName + "]");
		printOnConsole("getDOMIDValue[" + E12Constants.bmrObjs + "]");
		printOnConsole("getDOMIDValue[" + E12Constants.bmrObjs.contains( objName ) + "]");
		return  E12Constants.bmrObjs.contains( objName );
	}

	public static String getValueByTagName(Document doc, String tagName)
	{
		String colValue = "";
		try
		{
			NodeList nodeList = doc.getElementsByTagName( tagName );
			if( nodeList != null && nodeList.getLength() > 0 )
			{
				Node node = nodeList.item(0);
				if( node != null &&  node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null )
				{
					colValue = node.getFirstChild().getNodeValue();
				}
				else if( node != null &&  node.getNodeValue() != null )
				{
					colValue = node.getNodeValue();
				}
			}
		}
		catch( Exception e)
		{
			Window.alert("Exception in getValueByTagName" + e.getMessage() );
			e.printStackTrace();
		}
		return colValue;
	}

	public static String getChildNodeValue(Node chNode, String childNodeName)
	{
		String childNodeValue = "";
		try
		{
			if( chNode != null )
			{
				Document chDom = XMLParser.parse(chNode.toString());
				XMLParser.removeWhitespace(chDom);
				childNodeValue = getValueByTagName(chDom, childNodeName);
			}
		}
		catch(Exception e)
		{
			Window.alert("E21CommonUtils Exception : getAttribValue :" + e.getMessage());
		}
		return childNodeValue;
	}

	//Added by Dnyaneshwar on 5-Dec-13 [ Capture image using device camera ] Start
	/**
	 * This method capture the image from device camera.
	 * <BR>After captured image then call to upload image in DB<BR>
	 * After uploaded image then call to native method for display the current image
	 *
	 * @param window the child window object
	 * @param refId the transaction id
	 */
	public static void captureImg( final Window chileWnd )
	{
		CommonPhoneGapUtil.getInstance().capturePhoto( new Callback<String, String>() {

			@Override
			public void onFailure(String reason) {
				Window.alert( ""+reason );
			}

			@Override
			public void onSuccess(String imageURI)
			{
				//Window.alert( " imageURI ["+imageURI+"]" );
				setImgURL( chileWnd, imageURI );
			}
		},true);
	}

	public static void uploadImg( String saveFileName, String imgURI, String refId, final Window chileWnd )
	{
		String tempFileName = checkNull( saveFileName.substring(0, saveFileName.indexOf(".") ) );
		String tempFileType = checkNull( imgURI.substring( imgURI.lastIndexOf( "." ) + 1, imgURI.length() ) );
		if( tempFileName.length() <= 0 || tempFileType.length() <= 0  )
		{
			tempFileName = "apple";
			tempFileType = "png";
		}

		final String fileName = tempFileName;
		final String fileType = tempFileType;
		E12Global.getInstance().setLoading(true);

		CommonPhoneGapUtil.getInstance().uploadFileFromDevice( fileName, fileType, imgURI, refId, new Callback<String, String>()
		{

			@Override
			public void onFailure(String reason)
			{
				E12Global.getInstance().setLoading(false);
				Window.alert( E12Constants.constants.setNoImageSelected() ); //Changes by Raju 19-02-14 for I18N
			}
			@Override
			public void onSuccess(String result)
			{
				String imageUrl = E12Global.getHostUrl() + "/ibase/bmr_images/"+fileName.trim()+"."+fileType;
				//userImage.setUrl( imageUrl );
				setImgURL( chileWnd, imageUrl );
				E12Global.getInstance().setLoading( false );
			}
		} );
	}

	//Added By Harshada on 5-APR-2014 [Integrate image capture component with EBMR]
	public static void viewCapturedImg( String imgURI )
	{
		//String fileUrl = E12Global.getHostUrl() +"/ibase/WebITMDocumentHandlerServlet?USER="+E12Constants.userID+"&PASSWORD="+E12Constants.passwordSha256+"&isSHA256Appld=true&ACTION=GET_DOCUMENT&DOC_ID="+docId+"&DOC_TYPE="+docType;
		E12PopupPanel e12PopupPanel = new E12PopupPanel();
		// Added by Shivaji on 24-Apr-2015 [To set width and height of Image componet] Start
		//e12PopupPanel.getElement().getStyle().setZIndex(1);
		e12PopupPanel.getElement().getStyle().setZIndex(101);
		e12PopupPanel.getElement().setId("CapImage");
		Image img = new Image( imgURI );
		img.setHeight("300px");
		img.setWidth("300px");
		e12PopupPanel.setAnimationEnabled(false);
		e12PopupPanel.setHeight("300px");
		e12PopupPanel.setWidth("300px");
		e12PopupPanel.setWidget( img );
		DOM.getElementById("fixedMainTableHeader").getStyle().setZIndex(1);
		DOM.getElementById("fixedTableHeader").getStyle().setZIndex(1);
		// Added by Shivaji on 24-Apr-2015 [To set width and height of Image componet] End
		e12PopupPanel.center();
		e12PopupPanel.show();
	}

	/**
	 * This method export captureImg() function for calling from handwritten java script
	 */
	public static native void exportCaptureImgMethod()
	/*-{
		$wnd.captureImg = $entry(@ibase.e12ria.client.E12CommonUtils::captureImg(Lcom/google/gwt/user/client/Window;));
		$wnd.uploadImg = $entry(@ibase.e12ria.client.E12CommonUtils::uploadImg(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gwt/user/client/Window;));
		$wnd.viewCapturedImg = $entry(@ibase.e12ria.client.E12CommonUtils::viewCapturedImg(Ljava/lang/String;));
		$wnd.setDefltMenuImg = $entry(@ibase.e12ria.client.E12CommonUtils::setDefltMenuImg(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;Ljava/lang/String;));
		//Added by Pankaj T on 18-08-16 for calling java script function[Start][S16EBAS016]
		$wnd.setLatlong = $entry(@ibase.e12ria.client.E12CommonUtils::setLatlong(Ljava/lang/String;));
		$wnd.setHtmlData = $entry(@ibase.e12ria.client.E12CommonUtils::setHtmlData(Ljava/lang/String;));
		$wnd.setToggleValue = $entry(@ibase.e12ria.client.E12CommonUtils::setToggleValue(Ljava/lang/String;Ljava/lang/String;));
		//Added by Pankaj T on 18-08-16 for calling java script function[End][S16EBAS016]
	}-*/;

	/**
	 * This method call to function of handwritten java script
	 * @param window the child window object
	 * @param imgURL the capture image path
	 */
	public native static void setImgURL(Window window, String imgURL)
	/*-{
		window.setImgURL(imgURL);
	}-*/;

	//Added by Dnyaneshwar on 5-Dec-13 [ Capture image using device camera ] Start

	//Added by Dnyaneshwar Chavan on 23-JUN-14 [ Change the menu level icon and wizard button name ] Start
	public void downloadFile( String fileName, final String serverURL, final Callback<Boolean, Boolean> callback )
	{
		downloadMenuImage( fileName, "", serverURL, callback );
	}
	/**
	 * This method download menu images in client, Mobile devices like Android, iOS.<BR>
	 * Before download the file check if file is exist then not download and return true file is exist.<BR>
	 * otherwise download the file and return true file is download.
	 *
	 * @param fileName the file name for download client side.
	 * @param imgId the id of image for change the src path
	 * @param serverURL the where file is location at server side.
	 * @param callback the check file is download or exist
	 */
	public void downloadMenuImage( String fileName, final String imgId, final String serverURL, final Callback<Boolean, Boolean> callback )
	{
		try
		{
			//final String serverURL = E12Global.getHostUrl() +"/ibase/images/MenuImages/"+fileName ;
			String curDevicePath = E12Global.getInstance().getCurDevicePath();
			final String folderName = curDevicePath.substring( curDevicePath.lastIndexOf("/") + 1, curDevicePath.length() );
			final String clientPath = E12Global.getInstance().getCurDevicePath() + "/" + fileName;
			final String localFileName = fileName;
			CommonPhoneGapUtil.getInstance().isFileExist(folderName, localFileName, new Callback<Boolean, Boolean>()
			{
				@Override
				public void onFailure(Boolean reason) {
					callback.onSuccess( false );
				}
				@Override
				public void onSuccess(Boolean isFileExist)
				{
					if ( isFileExist )
					{
						callback.onSuccess(true);
					}
					else
					{
						if( ! E12Global.getInstance().isOffline() )
						{
							CommonPhoneGapUtil.getInstance().downloadFile( clientPath, serverURL, new Callback<Boolean, Boolean>()
							{
								@Override
								public void onSuccess(Boolean isDownload)
								{
									callback.onSuccess(true);
								}
								@Override
								public void onFailure(Boolean reason)
								{
									callback.onSuccess(false);
								}
							});
						}
						else
						{
							callback.onSuccess(true);
						}
					}
				}
			});
		}
		catch (Exception e)
		{
			Window.alert( "Exception :: downloadMenuImage : " + e.getMessage() );
		}
	}

	/**
	 * This method call when image not found at specified src location.
	 *
	 * @param imgId the id of Image tag set the default image
	 * @param className the default image name
	 * @param srcPath the image src path for display the image
	 */
	public static void setDefltMenuImg( Element imgElmt, String className, String srcPath )
	{
		//Added By Ajinkya Gopalkar for setting error menu issue in zetakeys browser
		if( Window.Navigator.getUserAgent().indexOf("Zetakey") != -1 || ( E12Global.getInstance().hostedMode && Window.getClientWidth() < 300 ) )
		{
			imgElmt.setAttribute("src", "images/e12_icon.png" );
		}
		else if( imgElmt != null )
		{
			imgElmt.setAttribute("src", "" );
			imgElmt.setAttribute( "class", className );
		}
	}
	//Added by Dnyaneshwar Chavan on 23-JUN-14 [ Change the menu level icon and wizard button name ] End

	//Added by Reema on 23-AUG-14 [Set metadata for HomePage Table]-Start
	public HashMap<Integer, ColumnInfoBean> setMetadataInfoInMap(NodeList textObjNodes, NodeList colObjNodes, NodeList colInfoNodeList)
	{
		HashMap<Integer, ColumnInfoBean> metadataInfoHMap = new HashMap<Integer, ColumnInfoBean>();
		ArrayList<String> colLogicalNameList = getColLogicalNameList(colInfoNodeList);
		ArrayList<String> colPhysicalNamelist = getColPhysicalNameList(colInfoNodeList);
		int key = 0;

		for (int i = 0; i < textObjNodes.getLength(); i++)
		{
			NodeList textObjItems = textObjNodes.item(i).getChildNodes();
			String text = textObjItems.item(2).getFirstChild().getNodeValue();
			String width = textObjItems.item(8).getFirstChild().getNodeValue();
			String phyName = "";
			String logicalName = "";
			String name = textObjItems.item(10).getFirstChild().getNodeValue().trim();
			String textLogicalName = name.substring(0, name.lastIndexOf("_t"));
			String colVisible = getNodeValue( textObjItems.item(11) );
			for (int j = 0; j < colLogicalNameList.size(); j++)
			{
				if (textLogicalName.equalsIgnoreCase(colLogicalNameList.get(j)))
				{
					//Changed by Reema on 7-Oct-15[ support drop-down to homepage table]-start
					for(int k = 0; k < colObjNodes.getLength(); k++)
					{
						NodeList colObjItems = colObjNodes.item(k).getChildNodes();
						String fieldName = colObjItems.item(12).getFirstChild().getNodeValue().trim();
						//Changed by Reema on 22-Jan-16 [resolved issue related getting editStyle]
						//String editStyle = colObjItems.item(14).getAttributes().getNamedItem("style").getNodeValue();
						String editStyle = "";
						for(int l = 0; l < colObjItems.getLength(); l++ )
						{
							String editNode = colObjItems.item(l).getNodeName();
							if(editNode.equalsIgnoreCase("EditStyle"))
							{
								if(colObjItems.item(l) != null && colObjItems.item(l).getAttributes().getNamedItem("style") != null)
								{
									editStyle = colObjItems.item(l).getAttributes().getNamedItem("style").getNodeValue();
								}
							}
						}
						//Changed by Reema on 22-Jan-16 [resolved issue related getting editStyle]-end
						if( (textLogicalName.trim()).equals(fieldName.trim()) )
						{
							phyName = colPhysicalNamelist.get(j);
							logicalName = colLogicalNameList.get(j);
							ColumnInfoBean colInfoBean = new ColumnInfoBean(text, phyName, logicalName, width,colVisible, editStyle);
							metadataInfoHMap.put(new Integer(key), colInfoBean);
							key++;
							break;
						}
					}
					//Changed by Reema on 7-Oct-15[ support drop-down to homepage table]-End
				}
			}
		}
		return metadataInfoHMap;
	}
	//Added by Reema on 23-AUG-14 [Set metadata for HomePage Table]-End

	//Added by Reema on 2-sep-14[dataGrid flexTable style]
	public static void applyDatagridThemes()
	{
		Resources.DATAGRID_RES.blueThemeCSS().ensureInjected();
	}
	//Added by Reema on 2-sep-14[dataGrid flexTable style]-End

	//Added by Reema on 10-sep-14 [link to perform actions for actionInfoBean] - start
	//protected void performAction( HomePgActionInfoBean actionInfoBean, String objName, E12HomePagePanel homePagePanel, boolean isAnyRowSelected, StringBuffer pkFieldNames, StringBuffer pkFieldValue, String frmlArgValues, String advQuery)
	public void performAction( HomePgActionInfoBean actionInfoBean, String objName, WallToWallPanel homePagePanel, boolean isAnyRowSelected, StringBuffer pkFieldNames, StringBuffer pkFieldValue, String frmlArgValues, String advQuery, E12ParentEditor e12ParentEditor, HashMap<String, String> feedDataMap )
	{
		performAction( actionInfoBean, objName, homePagePanel, isAnyRowSelected, pkFieldNames, pkFieldValue, frmlArgValues, advQuery, "", "", feedDataMap, e12ParentEditor );
	}

	//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
	public void performAction( HomePgActionInfoBean actionInfoBean, String objName, WallToWallPanel homePagePanel, boolean isAnyRowSelected, StringBuffer pkFieldNames, StringBuffer pkFieldValue, String frmlArgValues, String advQuery, E12ParentEditor e12ParentEditor, HashMap<String, String> feedDataMap, E12TranActionLinksInfo e12TranActionLinksInfo )
	{
		performAction( actionInfoBean, objName, homePagePanel, isAnyRowSelected, pkFieldNames, pkFieldValue, frmlArgValues, advQuery, "", "", feedDataMap, e12ParentEditor, e12TranActionLinksInfo );
	}

	public void performAction( HomePgActionInfoBean actionInfoBean, String objName, final WallToWallPanel homePagePanel, boolean isAnyRowSelected, StringBuffer pkFieldNames, StringBuffer pkFieldValue, String frmlArgValues, String advQuery, String reqParamStr, String xmlDataStr, HashMap<String, String> feedDataMap, E12ParentEditor e12ParentEditor)
	{
		performAction( actionInfoBean, objName, homePagePanel, isAnyRowSelected, pkFieldNames, pkFieldValue, frmlArgValues, advQuery, "", "", feedDataMap, e12ParentEditor, null );
	}
	//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end

	//Added by Prasad on 19/10/16 [for service handler 4 implementation] START
	//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser
	//Changed by Amey W. [To set quantity on subform from visionsense camera] on 9-3-2020 
	public void performAction( HomePgActionInfoBean actionInfoBean, String objName, final WallToWallPanel homePagePanel, boolean isAnyRowSelected, StringBuffer pkFieldNames, StringBuffer pkFieldValue, String frmlArgValues, String advQuery, String reqParamStr, String xmlDataStr, HashMap<String, String> feedDataMap, final E12ParentEditor e12ParentEditor, E12TranActionLinksInfo e12TranActionLinksInfo)
	{
		//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser
		E12CommonUtils.getInstance().setCurrentLinkId("");
		//change by shrutika on 21-06-18 [Start] for gmail plugin issue
		//String objTitle = homePagePanel.getTitle();
		String objTitle = "";
		if ( homePagePanel != null )
		{
			E12CommonUtils.printOnConsole("inside HomePage instance");
			objTitle = homePagePanel.getTitle();
		}
		//change by shrutika on 21-06-18 [Start] for gmail plugin issue
		E12CommonUtils.printOnConsole("inside performAction....1499 objTitle["+objTitle+"]");
		String actionType = actionInfoBean.getActionType();
		final String serviceHandler = actionInfoBean.getServiceHandler();
		final String actionTitle = actionInfoBean.getTitle();
		String id = actionInfoBean.getId();
		String url="";
		setPkFieldNames(pkFieldNames); // Added by Bhupendra on 13-Jan-17 for [ Summary Page implementation in Mobile Editor ]
		E12CommonUtils.printOnConsole("In performAction - actionType - ["+ actionType +"], id - ["+ id +"]");
		E12CommonUtils.printOnConsole("In performAction - pkFieldNames - ["+ pkFieldNames +"], pkFieldValue - ["+ pkFieldValue +"]");

		//Added by Prasad on 23/11/17 [implementation of actions on subform, action argument implementation] START
		HashMap<String, String> queryStrMap = new HashMap<String, String>();
		String actionParam = "";
		String actionArg = E12CommonUtils.checkNull( actionInfoBean.getActionArg() );
		int formNo = Integer.parseInt( actionInfoBean.getFormNo() );
		E12CommonUtils.printOnConsole( "In performAction -  actionArg - ["+ actionArg +"]" );
		if ( actionArg.length() > 0 )
		{
			ArrayList< String > targetField = new ArrayList< String >();
			ArrayList< String > sourceField = new ArrayList< String >();
			ArrayList< String > dateType = new ArrayList< String >();

			String[] argNameArray= actionArg.split(",");
			for ( int cnt = 0 ; cnt < argNameArray.length ; cnt++ )
			{
				targetField.add( argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(":") + 1 , argNameArray[cnt].length() ) );
				sourceField.add( argNameArray[cnt].substring( 0 , argNameArray[cnt].lastIndexOf(".") ) );
				dateType.add( argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(".")+1 , argNameArray[cnt].lastIndexOf(":") ) );
			}

			String qryStr = getQueryParam( sourceField, targetField, null, isAnyRowSelected, null, feedDataMap );
			E12CommonUtils.printOnConsole("Query String:::["+ qryStr +"]");

			String[] qryStrArray = qryStr.split("&") ;
			for(int i=0 ; i < qryStrArray.length ; i++)
			{
				actionParam += qryStrArray[i].substring(qryStrArray[i].lastIndexOf("=")+1, qryStrArray[i].length())+":";

				String paramKeyValue[] = qryStrArray[i].split("=");
				String fldName = E12Global.checkNull( paramKeyValue[0] );
				String fldValue = E12Global.checkNull( paramKeyValue[1] );

				queryStrMap.put( fldName, fldValue.replaceAll("[+]", " "));
			}
		}
		E12CommonUtils.printOnConsole( "actionParam - ["+ actionParam +"]" );
		E12CommonUtils.printOnConsole( "queryStrMap - ["+ queryStrMap +"]" );
		//Added by Prasad on 23/11/17 [implementation of actions on subform, action argument implementation] END

		if ( actionType.equalsIgnoreCase("S") && id.equalsIgnoreCase("A") )
		{
			//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
			//int randNo = (int)( Math.random() * 1000000000 ) + 1;
			int randNo = E12CommonUtils.getInstance().generateRandomNo();
			//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
			E12CommonUtils.printOnConsole("calling EditorContainer from E12CommonUtils frmlArgValues "+frmlArgValues);
			E12HomePagePanel homePgPanel = null;
			EntryWrapper entry = null;
			if ( homePagePanel instanceof E12HomePagePanel )
			{
				homePgPanel = ( ( E12HomePagePanel ) homePagePanel );
				entry = homePgPanel.getEntry();
			}
			if( entry == null )
			{
				entry = new EntryWrapper();
			}
			entry.setTitle( objTitle );
			entry.setObjName(objName);
			entry.setObjType( "T" );
			entry.setId("ID001~" + randNo);
			//Changed by Amey W. [ Implement copy transaction action in E12mobile ] on 23-03-2020 START
			//E12EditorContainer e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel , entry, ""+randNo, null, "A", true);
			E12EditorContainer e12EditorContainer = null;
			if( actionInfoBean.getTitle().equalsIgnoreCase("Copy Transaction") && pkFieldValue != null ) 
			{
				e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel , entry, ""+randNo, pkFieldValue.toString(), id, true);
			}
			else 
			{
				e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel , entry, ""+randNo, null, id, true);
			}
			//Changed by Amey W. [ Implement copy transaction action in E12mobile ] on 23-03-2020 END
			e12EditorContainer.setFrmlArgsValues(frmlArgValues);
			e12EditorContainer.show();
		}
		else if (actionType.equalsIgnoreCase("S") && id.equalsIgnoreCase("E") )
		{
			if( isAnyRowSelected )
			{
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
				E12CommonUtils.printOnConsole("calling EditorContainer from E12CommonUtils");
				E12HomePagePanel homePgPanel = null;
				//EntryWrapper entry = null;
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
				//Added by Bhupendra on 6-Apr-17 for confirmed record is getting open for edit Starts
				if ( e12TranActionLinksInfo != null )
				{
					E12CommonUtils.printOnConsole("Testing isConfirmRow Value ["+ e12TranActionLinksInfo.getConfirmRowFlag() +"]");
					if ( "Y".equalsIgnoreCase( e12TranActionLinksInfo.getConfirmRowFlag() ) )
					{
						Window.alert("Selected transaction is already confirmed and can not be edited");
						return;
					}
				}
				//Added by Bhupendra on 6-Apr-17 for confirmed record is getting open for edit Ends
				else
				{
					if ( homePagePanel instanceof E12HomePagePanel )
					{
						homePgPanel = ( ( E12HomePagePanel ) homePagePanel );

						if( homePgPanel.getE12HomePage() != null )
						{
							E12CommonUtils.printOnConsole("homePgPanel.getE12HomePage().isCancelRow()...."+homePgPanel.getE12HomePage().isCancelRow());
							E12CommonUtils.printOnConsole("homePgPanel.getE12HomePage().isCloseRow()...."+homePgPanel.getE12HomePage().isCloseRow());
							E12CommonUtils.printOnConsole("homePagePanel.getE12HomePage().isConfirmRow - ["+ homePgPanel.getE12HomePage().isConfirmRow() +"]" );
							// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] Start
							/*if ( homePgPanel.getE12HomePage().isConfirmRow() )
							{
								Window.alert("Selected transaction is already confirmed and can not be edited");
								return;
							}*/
							if ( homePgPanel.getE12HomePage().isCancelRow() )
							{
								E12CommonUtils.printOnConsole("Print Cancel...");
								//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
								if( !("".equals(((E12HomePagePanel) homePagePanel).getE12HomePage().cancelMsgStr)) )
								{
									Document dom = XMLParser.parse(((E12HomePagePanel) homePagePanel).getE12HomePage().cancelMsgStr);
									XMLParser.removeWhitespace(dom);
									String message = "";
									String descString = "";
									String traceString = "";
									String messageString = "";
									if( dom.getElementsByTagName("message").item(0) != null )
									{
										E12CommonUtils.printOnConsole("---@#@#---Inside error message");
										Node msg = dom.getElementsByTagName("message").item(0);
										
										messageString = msg.getFirstChild().getNodeValue();
										E12CommonUtils.printOnConsole("---@#@#---Inside  message ["+messageString+"]  new ["+msg.getNodeValue()+"]");
										
										if( dom.getElementsByTagName("description").item(0) != null )
										{
											E12CommonUtils.printOnConsole("---@#@#---Inside description");
											Node description = dom.getElementsByTagName("description").item(0);
											descString =  description.getFirstChild().getNodeValue();
											E12CommonUtils.printOnConsole("---@#@#---Inside description ["+descString+"]");
										}
										if( dom.getElementsByTagName("trace").item(0) != null &&  dom.getElementsByTagName("trace").item(0).getFirstChild() != null )
										{
											E12CommonUtils.printOnConsole("---@#@#---Inside trace");
											Node trace = dom.getElementsByTagName("trace").item(0);
											traceString =  trace.getFirstChild().getNodeValue();
											E12CommonUtils.printOnConsole("---@#@#---Inside trace ["+traceString+"]");
										}
										
										E12CommonUtils.printOnConsole("CallerInterface:["+E12UserInfo.getCallerInterface()+"]");
										message = messageString + "\n" + descString;
										E12CommonUtils.printOnConsole("message:["+message+"]");
										Window.alert(message);
									}
								}
								else
								{
									Window.alert(E12Constants.constants.setTransCancelLbl());
								}
								//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
								return;
							}
							else if ( homePgPanel.getE12HomePage().isCloseRow() )
							{
								E12CommonUtils.printOnConsole("Print Close...");
								//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
								if( !("".equals(((E12HomePagePanel) homePagePanel).getE12HomePage().closeMsgStr)) )
								{
									Document dom = XMLParser.parse(((E12HomePagePanel) homePagePanel).getE12HomePage().closeMsgStr);
									XMLParser.removeWhitespace(dom);
									String message = "";
									String descString = "";
									String traceString = "";
									String messageString = "";
									if( dom.getElementsByTagName("message").item(0) != null )
									{
										E12CommonUtils.printOnConsole("---@#@#---Inside error message");
										Node msg = dom.getElementsByTagName("message").item(0);
										
										messageString = msg.getFirstChild().getNodeValue();
										E12CommonUtils.printOnConsole("---@#@#---Inside  message ["+messageString+"]  new ["+msg.getNodeValue()+"]");
										
										if( dom.getElementsByTagName("description").item(0) != null )
										{
											E12CommonUtils.printOnConsole("---@#@#---Inside description");
											Node description = dom.getElementsByTagName("description").item(0);
											descString =  description.getFirstChild().getNodeValue();
											E12CommonUtils.printOnConsole("---@#@#---Inside description ["+descString+"]");
										}
										if( dom.getElementsByTagName("trace").item(0) != null &&  dom.getElementsByTagName("trace").item(0).getFirstChild() != null )
										{
											E12CommonUtils.printOnConsole("---@#@#---Inside trace");
											Node trace = dom.getElementsByTagName("trace").item(0);
											traceString =  trace.getFirstChild().getNodeValue();
											E12CommonUtils.printOnConsole("---@#@#---Inside trace ["+traceString+"]");
										}
										
										E12CommonUtils.printOnConsole("CallerInterface:["+E12UserInfo.getCallerInterface()+"]");
										message = messageString + "\n" + descString;
										E12CommonUtils.printOnConsole("message:["+message+"]");
										Window.alert(message);
									}
								}
								else
								{
									Window.alert(E12Constants.constants.setTransClosedLbl());
								}
								//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
								return;
							}
							else if ( homePgPanel.getE12HomePage().isConfirmRow() )
							{
								E12CommonUtils.printOnConsole("Print Confirm...");
								//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
								if( !("".equals(((E12HomePagePanel) homePagePanel).getE12HomePage().confirmMsgStr)) )
								{
									Document dom = XMLParser.parse(((E12HomePagePanel) homePagePanel).getE12HomePage().confirmMsgStr);
									XMLParser.removeWhitespace(dom);
									String message = "";
									String descString = "";
									String traceString = "";
									String messageString = "";
									if( dom.getElementsByTagName("message").item(0) != null )
									{
										E12CommonUtils.printOnConsole("---@#@#---Inside error message");
										Node msg = dom.getElementsByTagName("message").item(0);
										
										messageString = msg.getFirstChild().getNodeValue();
										E12CommonUtils.printOnConsole("---@#@#---Inside  message ["+messageString+"]  new ["+msg.getNodeValue()+"]");
										
										if( dom.getElementsByTagName("description").item(0) != null )
										{
											E12CommonUtils.printOnConsole("---@#@#---Inside description");
											Node description = dom.getElementsByTagName("description").item(0);
											descString =  description.getFirstChild().getNodeValue();
											E12CommonUtils.printOnConsole("---@#@#---Inside description ["+descString+"]");
										}
										if( dom.getElementsByTagName("trace").item(0) != null &&  dom.getElementsByTagName("trace").item(0).getFirstChild() != null )
										{
											E12CommonUtils.printOnConsole("---@#@#---Inside trace");
											Node trace = dom.getElementsByTagName("trace").item(0);
											traceString =  trace.getFirstChild().getNodeValue();
											E12CommonUtils.printOnConsole("---@#@#---Inside trace ["+traceString+"]");
										}
										
										E12CommonUtils.printOnConsole("CallerInterface:["+E12UserInfo.getCallerInterface()+"]");
										message = messageString + "\n" + descString;
										E12CommonUtils.printOnConsole("message:["+message+"]");
										Window.alert(message);
									}
								}
								else
								{
									Window.alert(E12Constants.constants.setTransConfirmLbl());
								}
								//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
								return;
							}
							// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] End
						}
						//entry = homePgPanel.getEntry();
					}
				}
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
				// Commented and Added by Pankaj R on 11-Sep-19 [When a record edited the title changes Edit, it stays edit even in home screen - Start] 
				/*if( entry == null )
				{
					entry = new EntryWrapper();
				}*/
				EntryWrapper entry = new EntryWrapper();
				// Commented and Added by Pankaj R on 11-Sep-19 [When a record edited the title changes Edit, it stays edit even in home screen - End]
				entry.setTitle( actionInfoBean.getTitle() );
				entry.setObjName(objName);
				entry.setObjType( "T" );
				entry.setId("ID001~" + randNo);

				String pkvalues = pkFieldValue.toString();
				String transMode = id;

				new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo, pkvalues, transMode, true ).show();
			}
			else
			{
				Window.alert(E12Constants.constants.setNoRowSelected());
			}
		}
		//Added by Sagar B. for Select/Deselect All action impl in mobile[22-Nov-19]START
		else if ( actionType.equalsIgnoreCase("S") && id.equalsIgnoreCase("L") )
		{
			E12CommonUtils.printOnConsole("Select all action performed");
			String keyForm = "FORM_NO_";
			keyForm = keyForm + formNo;
			String resultXml = E12Global.checkNull( e12ParentEditor.getPageUtil().getFormDataMapObj().getAllFormDataMap().get( keyForm ) );
			resultXml = editTransXMLData(resultXml, null, "Y", formNo);
			resultXml = E12Global.checkNull( resultXml );
			e12ParentEditor.getPageUtil().getFormDataMapObj().getAllFormDataMap().put( keyForm, resultXml );
			e12ParentEditor.getPageUtil().getFormDataMapObj().setXMLDataToMap( formNo, resultXml );
			e12ParentEditor.drawFeedFormPage ( resultXml, formNo, "next" );
		}
		else if ( actionType.equalsIgnoreCase("S") && id.equalsIgnoreCase("D") )
		{
			E12CommonUtils.printOnConsole("deselect all action performed");
			String keyForm = "FORM_NO_";
			keyForm = keyForm + formNo;
			String resultXml = E12Global.checkNull( e12ParentEditor.getPageUtil().getFormDataMapObj().getAllFormDataMap().get( keyForm ) );
			resultXml = editTransXMLData(resultXml, null, "N", formNo);
			resultXml = E12Global.checkNull( resultXml );
			e12ParentEditor.getPageUtil().getFormDataMapObj().getAllFormDataMap().put( keyForm, resultXml );
			e12ParentEditor.getPageUtil().getFormDataMapObj().setXMLDataToMap( formNo, resultXml );
			e12ParentEditor.drawFeedFormPage ( resultXml, formNo, "next" );
		}
		//Added by Prasad on 12/07/17 [to open wizard from homepage] START
		else if( actionType.equalsIgnoreCase("U") && id.equalsIgnoreCase("I") )
		{
			try
			{
				String objNameWiz = ( objName.endsWith("_wiz") ? objName : objName + "_wiz" );
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END

				EntryWrapper entry = new EntryWrapper();
				entry.setTitle( objNameWiz );
				entry.setObjName( objNameWiz );
				entry.setObjType( "W" );
				entry.setId( "ID001~" + randNo );
				String transMode = "A";
				entry.setEditFlag( transMode );

				//Commented by AMOL S. on 27.03.18
				//E12EditorContainer e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo, null, transMode, true );
				E12EditorContainer e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo);
				e12EditorContainer.setFrmlArgsValues(frmlArgValues);
				e12EditorContainer.show();
			}
			catch(Throwable t)
			{
				t.printStackTrace();
				E12CommonUtils.printOnConsole("Exception - performAction :Add:" + t.getMessage());
			}
		}
		else if( actionType.equalsIgnoreCase("U") && id.equalsIgnoreCase("J") )
		{
			try
			{
				String objNameWiz = ( objName.endsWith("_wiz") ? objName : objName + "_wiz" );
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END

				E12HomePagePanel homePgPanel = null;
				if ( homePagePanel instanceof E12HomePagePanel )
				{
					homePgPanel = ( ( E12HomePagePanel ) homePagePanel );

					if( homePgPanel.getE12HomePage() != null )
					{
						E12CommonUtils.printOnConsole("homePagePanel.getE12HomePage().isConfirmRow - ["+ homePgPanel.getE12HomePage().isConfirmRow() +"]" );
						if ( homePgPanel.getE12HomePage().isConfirmRow() )
						{
							Window.alert("Selected transaction is already confirmed and can not be edited");
							return;
						}
					}
//					entry = homePgPanel.getEntry();
				}
//				if( entry == null )
//				{
//					entry = new EntryWrapper();
//				}
				EntryWrapper entry = new EntryWrapper();		//Changed by Sagar B. on 30-Jul-19
				entry.setTitle( objNameWiz );
				entry.setObjName( objNameWiz );
				entry.setObjType( "W" );
				entry.setId( "ID001~" + randNo );
				String pkvalues = pkFieldValue != null ? pkFieldValue.toString() : "";
				if ( pkvalues.endsWith( ":" ) )
				{
					pkvalues = pkvalues.substring( 0, pkvalues.length() - 1 );
				}
				entry.setTranId( pkvalues );
				String transMode = "E";
				entry.setEditFlag( transMode );

				//Changed by Prasad on 03/06/19 [to open transaction wizard from homepage]
				//new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo, pkvalues, transMode, true ).show();
				E12EditorContainer e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo);
				e12EditorContainer.setFrmlArgsValues(frmlArgValues);
				e12EditorContainer.show();
			}
			catch(Throwable t)
			{
				t.printStackTrace();
				E12CommonUtils.printOnConsole("Exception - performAction :Edit:" + t.getMessage());
			}
		}
		else if( actionType.equalsIgnoreCase("U") && id.equalsIgnoreCase("K") )
		{
			try
			{
				String objNameWiz = ( objName.endsWith("_wiz") ? objName : objName + "_wiz" );
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END

				EntryWrapper entry = new EntryWrapper();
				entry.setTitle( objNameWiz );
				entry.setObjName( objNameWiz );
				entry.setObjType( "W" );
				entry.setId( "ID001~" + randNo );
				String pkvalues = pkFieldValue != null ? pkFieldValue.toString() : "";
				if ( pkvalues.endsWith( ":" ) )
				{
					pkvalues = pkvalues.substring( 0, pkvalues.length() - 1 );
				}
				entry.setTranId( pkvalues );
				String transMode = "V";
				entry.setEditFlag( transMode );

				//Changed by Prasad on 03/06/19 [to open transaction wizard from homepage]
				//new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo, pkvalues, transMode, true ).show();
				E12EditorContainer e12EditorContainer = new E12EditorContainer( WallToWallPanel.activePanel, entry, ""+randNo);
				e12EditorContainer.setFrmlArgsValues(frmlArgValues);
				e12EditorContainer.show();
			}
			catch(Throwable t)
			{
				t.printStackTrace();
				E12CommonUtils.printOnConsole("Exception - performAction :View:" + t.getMessage());
			}
		}
		//Added by Prasad on 12/07/17 [to open wizard from homepage] END
		else if( actionType.equalsIgnoreCase("U") )
		{
			String REF_ID = pkFieldValue != null ? pkFieldValue.toString() : "";
			{
				if( serviceHandler.equalsIgnoreCase("1")  )
				{
					String rights_char = actionInfoBean.getId();
					String urlCData = actionInfoBean.getServiceCodeCData();
					if( urlCData != null && urlCData.indexOf("?") == -1 )
					{
						url = urlCData + "?";
					}
					else
					{
						url = urlCData + "&";
					}
					if( "X".equals(rights_char) )
					{
						url = url + "OBJ_NAME=" + objName +
								"&REF_ID=" + REF_ID +
								"&ACTION=DOWNLOAD_XML" +
								"&FILTERQUERY=" + advQuery;
					}
					else if ( "T".equals(rights_char) )
					{
						url = url + "OBJ_NAME=" + objName +
								"&REF_ID=" + REF_ID +
								"&ACTION=DOWNLOAD_XLS" +
								"&FILTERQUERY=" + advQuery;
					}
					else if ( "B".equals(rights_char) )
					{
						url = url + "OBJ_NAME=" + objName +
								"&REF_ID=" + REF_ID +
								"&ACTION=BROWDATA_XLS" +
								"&FILTERQUERY=" + advQuery;
					}
					else
					{
						url = url + "OBJ_NAME=" + objName +
								"&REF_ID=" + REF_ID +
								"&FILTERQUERY=" + advQuery;
					}
					url = url + "&dummyInt=" + Math.random();
					//Window.alert("Host url: "+url);
					if(E12Global.getInstance().getDeviceOS() == DeviceOS.iOS)
					{
						openInAppBrowser(url, true);
					}
					else
					{
						//Changed by Prasad on 08/12/16 [open exernal links] START
						//Window.open(url, "action_service_1_" + objName, "toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
						//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
						//int randNo = (int)( Math.random() * 1000000000 ) + 1;
						int randNo = E12CommonUtils.getInstance().generateRandomNo();
						//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
						EntryWrapper entry = new EntryWrapper();
						entry.setTitle( objTitle );
						entry.setObjName( objName );
						entry.setId( "ID001~" + randNo );
						//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser
						new E12LinkContainer( entry, url , null ).show("");
						//Changed by Prasad on 08/12/16 [open exernal links] END
					}
				}
				else if( serviceHandler.equalsIgnoreCase("2") || serviceHandler.equalsIgnoreCase("3"))
				{
					//Changed by Prasad on 08/12/16 [action implementation in detail form] START
					//callServiceHandler(objName, serviceHandler, pkFieldNames, pkFieldValue, actionInfoBean);
					if ( e12ParentEditor != null )
					{
						//callServiceHandler(objName, serviceHandler, pkFieldNames, pkFieldValue, actionInfoBean, e12ParentEditor, null);
						callServiceHandler(objName, serviceHandler, pkFieldNames, pkFieldValue, actionInfoBean, e12ParentEditor, null , new Callback<String, Boolean>() {
							@Override
							public void onFailure(Boolean reason) {
								// TODO Auto-generated method stub
							}

							@Override
							public void onSuccess(String result) {
							}
						} );
					}
					else
					{
						//Changed by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [START]
						callServiceHandler(objName, serviceHandler, pkFieldNames, pkFieldValue, actionInfoBean, new Callback<String, Boolean>() {

							@Override
							public void onSuccess(String result)
							{
								if( "2".equals(serviceHandler) )
								{
									E12CommonUtils.printOnConsole("In performAction actionTitle:["+actionTitle+"]");
									E12CommonUtils.printOnConsole("E12CommonUtils.performAction(...).new Callback() {...}.onSuccess()" +result);
									String[] colValues = result.split("~SEP~");
									String colName = "";
									String colValue = "";
									for( int j = 1; j < colValues.length; j++ )
									{
										if( j == 1 )
										{
											colName = colValues[1];
										}
										if( j == 2 )
										{
											colValue = colValues[2];
										}
									}
									E12HomePagePanel homePgPanel = null;
									if ( homePagePanel instanceof E12HomePagePanel )
									{
										homePgPanel = ( ( E12HomePagePanel ) homePagePanel );
									}
									if( homePgPanel != null )
									{
										List<Widget> selectedFeeds = homePgPanel.getE12HomePage().getSelectedFeeds();
										E12CommonUtils.printOnConsole("selectedFeeds :: "+selectedFeeds.size());
										for (int i = 0; i < selectedFeeds.size(); i++)
										{
											Widget widget = selectedFeeds.get(i).getParent().getParent().getParent();
											changeIconOnAction(widget.getElement(), colName, colValue);
											//Changed By Pankaj T. on 26-09-18 update feed data & redraw feed - start
											if( !"".equals(E12CommonUtils.checkNull(colName)) && !"".equals(E12CommonUtils.checkNull(colValue)))
											{
												E12CommonUtils.printOnConsole("Before call updateFeedData");
												homePgPanel.getE12HomePage().updateFeedData(colName, colValue, i);
												E12CommonUtils.printOnConsole("After call updateFeedData");
											}
											else if( "Confirm".equals(actionTitle) )
											{
												colName = E12CommonUtils.checkNull(homePgPanel.getE12HomePage().confirmCol);
												colValue = E12CommonUtils.checkNull(homePgPanel.getE12HomePage().confirmVal);
												E12CommonUtils.printOnConsole("Confirm Column Name:["+colName+"]");
												E12CommonUtils.printOnConsole("Confirm Column Value:["+colValue+"]");
												if( !"".equals(colName) && !"".equals(colValue) )
												{
													homePgPanel.getE12HomePage().updateFeedData(colName, colValue, i);
												}
											}
											else if( "Cancel".equals(actionTitle) )
											{
												colName = E12CommonUtils.checkNull(homePgPanel.getE12HomePage().cancelCol);
												colValue = E12CommonUtils.checkNull(homePgPanel.getE12HomePage().cancelVal);
												E12CommonUtils.printOnConsole("Cancel Column Name:["+colName+"]");
												E12CommonUtils.printOnConsole("Cancel Column Value:["+colValue+"]");
												if( !"".equals(colName) && !"".equals(colValue) )
												{
													homePgPanel.getE12HomePage().updateFeedData(colName, colValue, i);
												}
											}
											else if( "Close".equals(actionTitle) )
											{
												colName = E12CommonUtils.checkNull(homePgPanel.getE12HomePage().closeCol);
												colValue = E12CommonUtils.checkNull(homePgPanel.getE12HomePage().closeVal);
												E12CommonUtils.printOnConsole("Close Column Name:["+colName+"]");
												E12CommonUtils.printOnConsole("Close Column Value:["+colValue+"]");
												if( !"".equals(colName) && !"".equals(colValue) )
												{
													homePgPanel.getE12HomePage().updateFeedData(colName, colValue, i);
												}
											}
											//Changed By Pankaj T. on 26-09-18 update feed data & redraw feed - end
										}
									}
								}
							}

							@Override
							public void onFailure(Boolean reason) {
								// TODO Auto-generated method stub

							}
						});
						//Changed by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [END]
					}
					//Changed by Prasad on 08/12/16 [action implementation in detail form] END
				}
				else if( serviceHandler.equalsIgnoreCase("4") )
				{
					//Added by Suraj on 10/10/17 [Use ME12FeedTableForm for serviceHandler 4] START
					//callServiceHandler4( actionInfoBean, pkFieldValue, objName, reqParamStr, xmlDataStr, feedDataMap, e12ParentEditor );
					if ( e12ParentEditor != null )
					{
						String pkFields = E12CommonUtils.checkNull( e12ParentEditor.getPageUtil().getFormPKFieldsMap().get( "PKFIELDS_"+e12ParentEditor.getCurrentFormNo() ) );
						String pkValues = "";
						if( feedDataMap != null )
						{
							pkValues = E12CommonUtils.checkNull( e12ParentEditor.getPageUtil().getPKValue( String.valueOf( e12ParentEditor.getCurrentFormNo() ), feedDataMap, pkFields ) );
						}
						pkFields = pkFields.replaceAll( "~", ":" );
						pkValues = pkValues.replaceAll( "~", ":" );

						E12CommonUtils.printOnConsole( "In performAction - pkField - ["+ pkFields +"], pkValue - ["+ pkValues +"]" );
						new ME12FeedDetailForm( actionInfoBean, e12ParentEditor.getE12WizardPanel(), e12ParentEditor.getPageUtil().getEntry(), e12ParentEditor.getCurrentDetailFormNo(), pkFields,e12ParentEditor.getDetailFeedPnl(), e12ParentEditor.getPageUtil().getCurrentFeedDataMap(), "FREEFORM", true );
					}
					//Added by Suraj on 10/10/17 [Use ME12FeedTableForm for serviceHandler 4] END
				}
				//Added by Prasad on 23/11/17 [implementation of actions on subform, action argument implementation] START
				else if( "7".equalsIgnoreCase( serviceHandler ) )
				{
					String argRefSer = "", argTranId = "", argObjName = "", argUIMode = "";
					if ( queryStrMap != null )
					{
						argRefSer = E12CommonUtils.checkNull( queryStrMap.get( "REF_SER" ) );
						argTranId = E12CommonUtils.checkNull( queryStrMap.get( "REF_ID" ) );
						argObjName = E12CommonUtils.checkNull( queryStrMap.get( "OBJ_NAME" ) );
						argUIMode = E12CommonUtils.checkNull( queryStrMap.get( "MODE" ) );
					}
					E12CommonUtils.printOnConsole( "argTranId - ["+ argTranId +"], argRefSer - ["+ argRefSer +"]" );
					E12CommonUtils.printOnConsole( "argObjName - ["+ argObjName +"], argUIMode - ["+ argUIMode +"]" );

					if ( argRefSer.length() > 0 && argTranId.length() > 0 && argObjName.length() > 0 )
					{
						displayAttachmentPopup( argObjName, argRefSer, argTranId, argUIMode );
					}
					else
					{
						Window.alert( E12Constants.constants.setCheckAccessConfig() );
					}
				}
				//Added by Prasad on 23/11/17 [implementation of actions on subform, action argument implementation] END
				//Added by Prasad on 22/01/18 [implementation of action handler 8 - actions on detail form] START
				else if( "9".equalsIgnoreCase( serviceHandler ) )
				{
					callServiceHandler( objName, serviceHandler, pkFieldNames, pkFieldValue, actionInfoBean, e12ParentEditor );
				}
				//Added by Prasad on 22/01/18 [implementation of action handler 8 - actions on detail form] END
				//Added by Prasad on 26/08/18 [implementation of action handler b - presentation detail in e-detailing] START
				else if( "b".equalsIgnoreCase( serviceHandler ) )
				{
					String dataModelName = "";
					if ( queryStrMap != null )
					{
						dataModelName = E12CommonUtils.checkNull( queryStrMap.get( "DATA_MODEL" ) );
					}
					if ( dataModelName.length() == 0 )
					{
						dataModelName = "USER_PRES_D";
					}
					CallBServiceHandler( dataModelName, e12ParentEditor );
				}
				//Added by Prasad on 26/08/18 [implementation of action handler b - presentation detail in e-detailing] END
				//Added by Amey W. [To set quantity on subform from visionsense camera] on 9-3-2020 START
				else if( "d".equalsIgnoreCase( serviceHandler ) )
				{
					try
					{
						E12CustomPlugin.getVisionSensecameraDetails(  new E12CustomPlugin.CallBack() {
							
							@Override
							public void onSuccess(String result)
							{
								E12CommonUtils.printOnConsole( "Inside openInNativeApp :: onSuccess() : result [" + result + "]" );
								if( e12ParentEditor.getPageUtil() != null && e12ParentEditor.getPageUtil().getMe12FeedTableForm() != null )
								{
									e12ParentEditor.getPageUtil().getMe12FeedTableForm().performLocalItemChange( "visionSenseCamera", "", "", result );
								}
							}

							@Override
							public void onError(String reason)
							{
								E12CommonUtils.printOnConsole( "Inside openInNativeApp :: onError() : reason [" + reason + "]" );
								Window.alert(reason);
							}
						});
					}
					catch( Exception e )
					{
						E12CommonUtils.printOnConsole( "[VisionSensecameraDetails] Exception eee = "+e );
					}
                }
                //added by Pramod s for Pull Action -> Retieve all information of calls and update into table on 23-06-2021[Start]
                else if("e".equalsIgnoreCase( serviceHandler ))
                { 
                    try
                    {
                        E12CustomPlugin.hasReadPermission( new E12CustomPlugin.CallBack() 
                        { 
							@Override
							public void onSuccess(String result)
							{
                                E12CommonUtils.printOnConsole( "Inside hasReadPermission onSuccess() : result [" + result + "]" );

                                if("false".equalsIgnoreCase(result))
                                {
                                    E12CommonUtils.printOnConsole( "hasPermission onsucces false :: " + result + "]" );
                                    E12CustomPlugin.requestReadPermission( new E12CustomPlugin.CallBack()
                                    {
                                        public void onSuccess(String result)
                                        {
                                            if("false".equalsIgnoreCase(result))
                                            {
                                                //E12CommonUtils.printOnConsole( " requestReadPermission onsucces false :: " + Class.forName(result) + "]" );
                                                E12CommonUtils.printOnConsole( "Inside requestReadPermission onSuccess() : result [" + result + "]" );     
                                            }
                                            else
                                            {
                                                E12CustomPlugin.getCallLog( new E12CustomPlugin.CallBack() 
                                                {
                                                    public void onSuccess(String result)
                                                    {
                                                        E12CommonUtils.printOnConsole( "Inside getCallLog :: onSuccess() : result [" + result + "]" );
                                                        if("false".equalsIgnoreCase(result))
                                                        {
                                                           E12CommonUtils.printOnConsole( "Inside getCallLog :: onFalse() : result [" + result + "]" ); 
                                                        }  
                                                        else
                                                        {
                                                            E12CommonUtils.printOnConsole( "Inside getCallLog :: onTrue() : result [" + result + "]" );
                                                            CallListPopup(result);
                                                        } 
                                                    }
                                                    public void onError(String reason)
                                                    {
                                                        E12CommonUtils.printOnConsole( "Inside getCallLog :: onError() : reason [" + reason + "]" );
                                                    }
                                                });
                                            }
                                        }
                                        public void onError(String reason)
                                        {
                                            E12CommonUtils.printOnConsole( "Inside requestReadPermission onError() : result [" + reason + "]" ); 
                                        }
                                    });
                                    
                                }
                                else
                                {

                                    E12CommonUtils.printOnConsole( "In Else ::" );
                                   //final E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.GET, url );
                                    E12CommonUtils.printOnConsole( "hasReadPermission onSuccess() true :: " + result + "]" );
                                    
                                    //CallListPopup(result);

                                    E12CustomPlugin.getCallLog( new E12CustomPlugin.CallBack() {
                                        
                                        public void onSuccess(String result)
                                        {
                                            E12CommonUtils.printOnConsole( "Inside getCallLog :: onSuccess() : :result [" + result + "]" );
                                            if("false".equalsIgnoreCase(result))
                                            {
                                                E12CommonUtils.printOnConsole( "Inside else of hasread getCallLog :: onFalse() : :result [" + result + "]" ); 
                                            }  
                                            else
                                            {
                                                E12CommonUtils.printOnConsole( "Inside else of hasread getCallLog :: onTrue() : :result [" + result + "]" );
                                                CallListPopup(result);
                                            }   
                                        }
                                        public void onError(String reason)
                                        {
                                            E12CommonUtils.printOnConsole( "Inside getCallLog :: onError() : :reason [" + reason + "]" );
                                        }
                                    });
                                }
							}

							@Override
							public void onError(String reason)
							{
                                E12CommonUtils.printOnConsole( "Inside hasReadPermission :: onError() : reason [" + reason + "]" );
								Window.alert(reason);
							}
						});
                    }
                    catch( Exception e)
                    {
                         E12CommonUtils.printOnConsole( "[hasReadPermission] Exception eee = "+e );
                    }

                }   
                //added by Pramod s for Pull Action -> Retieve all information of calls and update into table on 23-06-2021[END]

                //Added by Amey W. [To set quantity on subform from visionsense camera] on 9-3-2020 END
				else
				{
					String urlCData = actionInfoBean.getServiceCodeCData();
					if( urlCData != null && urlCData.indexOf("?") == -1 )
					{
						url = urlCData + "?";
					}
					else
					{
						url = urlCData + "&";
					}
					url = url + "OBJ_NAME=" + objName +
							"&REF_ID=" + REF_ID +
							"&COMP_TYPE=" + actionInfoBean.getCmpType() +
							"&COMP_NAME="+actionInfoBean.getCmpName()+
							"&METHOD_NAME="+actionInfoBean.getMetName();
					url = E12Global.getHostUrl() + url + "&dummyInt=" + Math.random();
					if(E12Global.getInstance().getDeviceOS() == DeviceOS.iOS)
					{
						openInAppBrowser(url, true);
					}
					else
					{
						//Changed by Prasad on 08/12/16 [open exernal links] START
						//Window.open(url, "action_service_other_" + objName, "toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
						//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
						//int randNo = (int)( Math.random() * 1000000000 ) + 1;
						int randNo = E12CommonUtils.getInstance().generateRandomNo();
						//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
						EntryWrapper entry = new EntryWrapper();
						entry.setTitle( objTitle );
						entry.setObjName( objName );
						entry.setId( "ID001~" + randNo );
						//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser
						new E12LinkContainer( entry, url ,null ).show("");
						//Changed by Prasad on 08/12/16 [open exernal links] END
					}
				}
			}
		}
	}

	public void performLinkAction( LinkActionInfoBean  linkActionInfoBean, StringBuffer pkFieldValue, String objName, ArrayList< String > dataGridHeaderLogicalColName, boolean isAnyRowSelected, DataGridTableRowModel selectedDGTRModel, HashMap< String,String > feedDataMap)
	{
		try
		{
			E12CommonUtils.printOnConsole("In performLinkAction linkId:["+linkActionInfoBean.getLinkId()+"]");
			//Added by shrutika on 27-02-19 for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
			E12CommonUtils.getInstance().setCurrentLinkId(linkActionInfoBean.getLinkId());
			boolean isOpenInFrame = false;
			String fieldName = checkNull( linkActionInfoBean.getFieldName() );
			String targetObjName=linkActionInfoBean.getTargetObj();
			String linkType = linkActionInfoBean.getLilnkType();
			String linkUri = linkActionInfoBean.getLinkUri();
			String linkArgmnt = linkActionInfoBean.getLinkArg();
			final String linkTitle = linkActionInfoBean.getTitle();
			String linkForm = linkActionInfoBean.getLinkForm();
			String linkImage = linkActionInfoBean.getLinkImageUrl();
			String showInPanel = linkActionInfoBean.getShowInSidePanel();
			String paramType ="";
			String qryParam = "";
			char pageCtx = 1;
			char objCtx = 1;
			String url = "";

			ArrayList< String > targetField = new ArrayList< String >();
			ArrayList< String > sourceField = new ArrayList< String >();
			ArrayList< String > dateType = new ArrayList< String >();

			if ( targetObjName.length()+2==linkForm.length() )
			{
				pageCtx=linkForm.charAt( targetObjName.length() );
				objCtx = linkForm.charAt( targetObjName.length()+1 );
			}

			String[] argNameArray= linkArgmnt.split(",");
			for ( int cnt = 0 ; cnt < argNameArray.length ; cnt++ )
			{
				targetField.add(argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(":") + 1 , argNameArray[cnt].length())) ;
				sourceField.add( argNameArray[cnt].substring( 0 , argNameArray[cnt].lastIndexOf("."))) ;
				dateType.add( argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(".")+1 , argNameArray[cnt].lastIndexOf(":")) );
			}

			//Changes made by Anjali R. on[5/07/18][Start][To add parameter in query string]
			String objRefSer = "";
			objRefSer = E12Global.checkNull( ObjDetails.get( objName ).getRefSer() );
			//Changes made by Anjali R. on[5/07/18][End][To add parameter in query string]
			//Changes by Prajyot on 06-AUG-18 [ For implementation of Link Type - A] Start
			/*
			String qryStr = getQueryParam(sourceField, targetField, dataGridHeaderLogicalColName, isAnyRowSelected, selectedDGTRModel, feedDataMap );
			E12CommonUtils.printOnConsole("Query String:::[ "+qryStr+" ]");
			//Added by Sagar B. to set query string data on link access[27Apr17]START
			HashMap<String, String> queryStrMap = new HashMap<String, String>();
			//Added by Sagar B. to set query string data on link access[27Apr17]END
			String[] qryStrArray = qryStr.split("&") ;
			for(int i=0 ; i < qryStrArray.length ; i++)
			{
				qryParam += qryStrArray[i].substring(qryStrArray[i].lastIndexOf("=")+1, qryStrArray[i].length())+":";
				//Added by Sagar B. to set query string data on link access[27Apr17]START
				String paramKeyValue[] = qryStrArray[i].split("=");
				String fldName = E12Global.checkNull(paramKeyValue[0]);
				String fldValue = E12Global.checkNull(paramKeyValue[1]);
				queryStrMap.put( fldName , fldValue.replaceAll("[+]", " "));
				//Added by Sagar B. to set query string data on link access[27Apr17]END
			}
			 */
			String qryStr = "";

			final HashMap<String, String> queryStrMap = new HashMap<String, String>();
			//Added by Prasad on 27/09/18 [added condition for linkType 8]
			if( "A".equalsIgnoreCase( linkType ) || "8".equalsIgnoreCase( linkType ) )
			{
				qryStr = getJsonParam(sourceField, targetField, dataGridHeaderLogicalColName, isAnyRowSelected, selectedDGTRModel, feedDataMap, fieldName );//getJsonParam( sourceField, targetField, getFeedDataMap(), fieldName );
				E12CommonUtils.printOnConsole("Query String:::[ "+qryStr+" ]");
			}
			else
			{
				qryStr = getQueryParam(sourceField, targetField, dataGridHeaderLogicalColName, isAnyRowSelected, selectedDGTRModel, feedDataMap );
				E12CommonUtils.printOnConsole("Query String:::[ "+qryStr+" ]");
				//Added by Sagar B. to set query string data on link access[27Apr17]START
				//Added by Sagar B. to set query string data on link access[27Apr17]END
				String[] qryStrArray = qryStr.split("&") ;
				for(int i=0 ; i < qryStrArray.length ; i++)
				{
					qryParam += qryStrArray[i].substring(qryStrArray[i].lastIndexOf("=")+1, qryStrArray[i].length())+":";
					//Added by Sagar B. to set query string data on link access[27Apr17]START
					String paramKeyValue[] = qryStrArray[i].split("=");
					String fldName = E12Global.checkNull(paramKeyValue[0]);
					String fldValue = E12Global.checkNull(paramKeyValue[1]);
					queryStrMap.put( fldName , fldValue.replaceAll("[+]", " "));
					//Added by Sagar B. to set query string data on link access[27Apr17]END
				}
			}
			//Added by Prajyot on 06-AUG-18 [ For implementation of Link Type - A]	End
			for (int  countp = 0; countp < dateType.size() ; countp++ )
			{
				paramType += dateType.get( countp )+":";
			}

			//Link 1 = View
			if (  "1".equals( linkType ) )
			{
				if( objName.equals("sorder_confirmed") )
				{
					if( ! ("".equals(pkFieldValue.toString().trim())) &&  pkFieldValue.length() > 0	)
					{
						url = "/ibase/webitm/jsp/ViewStatus.jsp?OBJ_NAME="+objName+"&PK_FIELDVALUE="+pkFieldValue;
						isOpenInFrame = true;
					}
					else
					{
						Window.alert( E12Constants.constants.setTransactioncannotbeproceedLbl() );
					}
				}
				else if ( pageCtx == 1 && objCtx == 1 )
				{
					url = "/ibase/webitm/jsp/ITMLinkPage.jsp?&TAR_OBJ_NAME=" + targetObjName + "&LINK_DESCR=" + linkTitle + "&QRY_PARAM=" + qryParam + "&QRY_PARAM_TYPE=" + paramType+ "&OBJ_CTXT="+objCtx+"";
					isOpenInFrame = true;
				}
				else
				{
					if( ! ("".equals(pkFieldValue.toString().trim())) &&  pkFieldValue.length() > 0	)
					{
						//Changed by Prasad on 08/12/16 [open editor] START
						/*url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE="+targetObjName.toUpperCase()+"&OBJ_NAME=" + targetObjName + "&PAGE_CONTEXT=" + pageCtx + "&OBJ_CONTEXT=" + objCtx + "&EDIT_FLAG=V&DB_ID=" + pkFieldValue + "&PARAM_TYPE=" + paramType + "";
						url += qryStr;*/
						E12CommonUtils.printOnConsole("calling EditorContainer from E12CommonUtils= [ "+pkFieldValue.toString()+" ]");
						//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
						//int randNo = (int)( Math.random() * 1000000000 ) + 1;
						int randNo = E12CommonUtils.getInstance().generateRandomNo();
						//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
						EntryWrapper entry = new EntryWrapper();
						entry.setTitle( linkTitle );
						entry.setObjName(targetObjName);
						entry.setObjType( "T" );
						entry.setId("ID001~" + randNo);
						//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
						if( E12CommonUtils.getInstance().getPopupPanel() != null)
						{
							E12CommonUtils.getInstance().getPopupPanel().hide();
							E12CommonUtils.getInstance().setPopupPanel(null);
						}
						//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
						WallToWallPanel myPanel = WallToWallPanel.activePanel;
						//Added by sunny soni for showing homepage of other menu from link on 20-DEC-16 start
						E12CommonUtils.printOnConsole("Link Form Name in E12CommonUtils::::[ "+linkForm+" ]");
						if( linkForm.contains( "11" ) )
						{
							E12CommonUtils.printOnConsole("=========For Showing HomePage in E12CommonUtils==============");
							//Adding by sunny soni on 20-DEC-16  for assigning link value & type start
							E12Constants.objLinktype = true;
							if(qryStr.contains("&"))
							{
								String reqStr = qryStr.replace("&", "~").replace("+", " ").replace("%", "@");
								E12CommonUtils.printOnConsole("required String::: "+reqStr);
								entry.setObjlinkVal(reqStr);
							}
							else
							{
								entry.setObjlinkVal(qryStr);
							}
							E12HomePagePanel e12HomePagePanel = new E12HomePagePanel(myPanel, entry, ""+randNo);
							e12HomePagePanel.enter();
							//Adding by sunny soni on 20-DEC-16 for assigning link value & type end
						}
						else
						{
							E12CommonUtils.printOnConsole("=========For Editor Window in E12CommonUtils==============");
							new E12EditorContainer(myPanel, entry, ""+randNo, pkFieldValue.toString(), "V", true).show();
						}
						//Added by sunny soni for showing homepage of other menu from link on 20-DEC-16 end
					}
					else
					{
						Window.alert( E12Constants.constants.setTransactioncannotbeproceedLbl() );
					}
				}
			}
			//Link 2 = Edit
			else if ( "2".equals( linkType ) )
			{
				if( ! ("".equals(pkFieldValue.toString().trim())) &&  pkFieldValue.length() > 0	)
				{
					//Changed by Prasad on 08/12/16 [open editor] START
					/*url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE="+targetObjName.toUpperCase()+"&OBJ_NAME=" + targetObjName + "&PAGE_CONTEXT=" + pageCtx + "&OBJ_CONTEXT=" + objCtx + "&EDIT_FLAG=E&DB_ID=" +  pkFieldValue + "&PARAM_TYPE=" + paramType + "";
					url += qryStr;*/

					//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
					//int randNo = (int)( Math.random() * 1000000000 ) + 1;
					int randNo = E12CommonUtils.getInstance().generateRandomNo();
					//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
					EntryWrapper entry = new EntryWrapper();
					entry.setTitle( linkTitle );
					entry.setObjName(targetObjName);
					entry.setObjType( "T" );
					entry.setId("ID001~" + randNo);
					//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
					if( E12CommonUtils.getInstance().getPopupPanel() != null)
					{
						E12CommonUtils.getInstance().getPopupPanel().hide();
						E12CommonUtils.getInstance().setPopupPanel(null);
					}
					//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
					WallToWallPanel myPanel = WallToWallPanel.activePanel;
					//Changed by Sagar B. to set query string data on link access[27Apr17]START
					E12EditorContainer e12editorcontainer = new E12EditorContainer(myPanel, entry, ""+randNo, pkFieldValue.toString(), "E", true);
					e12editorcontainer.show();
					//Changed by Sagar B. to set query string data on link access[27Apr17]END
					//Added by Sagar B. to set query string data on link access[27Apr17]START
					e12editorcontainer.e12TransEditor.setQueryStrMap( queryStrMap );
					//Added by Sagar B. to set query string data on link access[27Apr17]END
					//Changed by Prasad on 08/12/16 [open editor] END
				}
				else
				{
					Window.alert( E12Constants.constants.setTransactioncannotbeproceedLbl() );
				}
			}
			//Link 3 = Report
			else if ( "3".equals( linkType ))
			{
				if ( linkUri.indexOf("/ibase/bi") != -1 )
				{
					HashMap<String, String> paramMap = new HashMap<String, String>();
					paramMap.put("bi", targetObjName + ".xml");
					paramMap.put("common", "true");
					paramMap.put("target", "browser");
					paramMap.put("drill", "Indrill");
					String encodedParamString = getEncodedParamString(paramMap);
					if ( !"".equalsIgnoreCase( encodedParamString ) )
					{
						encodedParamString = encodedParamString + "&";
					}
					if ( linkUri.indexOf("?") != -1 )
					{
						url = linkUri + "&" + encodedParamString + qryStr;
					}
					else
					{
						url = linkUri + "?" + encodedParamString + qryStr;
					}
				}
				else
				{
					if ( linkUri.indexOf("?") != -1 )
					{
						url = linkUri + "&" + qryStr;
					}
					else
					{
						//Changes made by Anjali R. on[5/01/18][Start][To add parameter in query String]
						//url = linkUri + "?" + qryStr;
						url = linkUri + "?" + qryStr +"&REF_SER="+objRefSer+"&linkTitle="+linkTitle;;
						//Changes made by Anjali R. on[5/01/18][End][To add parameter in query String]
					}
				}
				isOpenInFrame = true;
			}
			//Link 4 = Add
			else if ( "4".equals( linkType ))
			{
				E12CommonUtils.printOnConsole("Perform link action for link type 4");
				//Changed by Priyanka B on 08/08/18 [For add mode pkFieldValue check is not required] START
				/*	if( ! ("".equals(pkFieldValue.toString().trim())) &&  pkFieldValue.length() > 0	)
   			    { */
				//Changed by Priyanka B on 08/08/18 END
				//Changed by Prasad on 08/12/16 [open editor] START
				/*url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE="+targetObjName.toUpperCase()+"&OBJ_NAME=" + targetObjName + "&PAGE_CONTEXT=" + pageCtx + "&OBJ_CONTEXT=" + objCtx + "&EDIT_FLAG=A&DB_ID=" + pkFieldValue + "&PARAM_TYPE=" + paramType + "&";
					url += qryStr;*/

				E12CommonUtils.printOnConsole("calling EditorContainer from E12CommonUtils:: [ "+linkType+" ]");
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
				EntryWrapper entry = new EntryWrapper();
				entry.setTitle( linkTitle );
				entry.setObjName(targetObjName);
				entry.setObjType( "T" );
				entry.setId("ID001~" + randNo);
				final WallToWallPanel myPanel = WallToWallPanel.activePanel;//Getting current panel object
				//Added by sunny soni on 17-OCT-16 for set reqParamStr Value [Start].
				if(qryStr.contains("&"))
				{
					String reqStr = qryStr.replace("&", "~").replace("+", " ").replace("%", "@");
					E12CommonUtils.printOnConsole("required String::: "+reqStr);
					E12Constants.reqParamStr = reqStr;
				}
				else
				{
					E12Constants.reqParamStr = qryStr;
				}
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
				if( E12CommonUtils.getInstance().getPopupPanel() != null)
				{
					E12CommonUtils.getInstance().getPopupPanel().hide();
					E12CommonUtils.getInstance().setPopupPanel(null);
				}
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
				//Added by sunny soni on 17-OCT-16 for set reqParamStr Value [End].
				E12CommonUtils.printOnConsole("Required Parameter String:: [ "+E12Constants.reqParamStr+" ]");
				//Changed by Sagar B. to set query string data on link access[27Apr17]START
				E12EditorContainer e12editorcontainer = new E12EditorContainer(myPanel, entry, ""+randNo, "", "A", true);
				e12editorcontainer.show();
				//Changed by Sagar B. to set query string data on link access[27Apr17]END
				//Added by Sagar B. to set query string data on link access[27Apr17]START
				e12editorcontainer.e12TransEditor.setQueryStrMap( queryStrMap );
				//Added by Sagar B. to set query string data on link access[27Apr17]END
				//new E12EditorContainer(myPanel, entry, ""+randNo, pkFieldValue.toString(), "A", true).show();-----previously added
				//Changed by Priyanka B on 08/08/18 [For add mode pkFieldValue check is not required] START
				/*	}
				else
				{
					Window.alert( E12Constants.constants.setTransactioncannotbeproceedLbl() );
				} */
				//Changed by Priyanka B on 08/08/18 END
			}
			else if ( "5".equals( linkType ))
			{
				//changed by prasad raut on 14.7.17 for[View jasper report from homepage link in Mobile]Start.
				if( linkUri.indexOf( "/ibase/dwh/" ) != -1 )
				{
					/*Start Call dashboard from obj link by Dhanendra */
					linkUri = linkUri+"&pkField="+pkFieldValue.toString().substring(0, pkFieldValue.toString().length()-1)+"&";
					new ME12Dashboard(WallToWallPanel.activePanel).objLinkDashboard(targetObjName,linkUri);
					/*End Call dashboard from obj link by Dhanendra */
				}
				else
				{
					//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
					//int randNo = (int)( Math.random() * 1000000000 ) + 1;
					int randNo = E12CommonUtils.getInstance().generateRandomNo();
					//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
					EntryWrapper entry = new EntryWrapper();
					entry.setTitle( linkTitle );
					entry.setObjName( targetObjName );
					entry.setObjType( "R" );
					entry.setId( "ID001~" + randNo );
					//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
					if( E12CommonUtils.getInstance().getPopupPanel() != null)
					{
						E12CommonUtils.getInstance().getPopupPanel().hide();
						E12CommonUtils.getInstance().setPopupPanel(null);
					}
					//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
					WallToWallPanel myPanel = WallToWallPanel.activePanel;
					//Changed by Prasad on 05/09/2020 [to set arguments from links] START
					//new E12Report( myPanel, entry );
					new E12Report( myPanel, entry, queryStrMap );
					//Changed by Prasad on 05/09/2020 [to set arguments from links] END
				}
				//changed by prasad raut on 14.7.17 for[View jasper report from homepage link in Mobile]End.
			}
			//Link 6 = Process
			else if ( "6".equals( linkType ))
			{
				//Changed by Prasad on 08/12/16 [open process editor] START
				/*url = "/ibase/webitm/jsp/ITMProcessPageEditor.jsp?OBJ_NAME=" + targetObjName + "&OBJ_TYPE=P&";
				url += qryStr;*/

				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
				EntryWrapper entry = new EntryWrapper();
				entry.setTitle( linkTitle );
				entry.setObjName(targetObjName);
				entry.setObjType( "P" );
				entry.setId("ID001~" + randNo);
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
				if( E12CommonUtils.getInstance().getPopupPanel() != null)
				{
					E12CommonUtils.getInstance().getPopupPanel().hide();
					E12CommonUtils.getInstance().setPopupPanel(null);
				}
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
				WallToWallPanel myPanel = WallToWallPanel.activePanel;
				//Changed by Sagar B. to set query string data on link access[27Apr17]START
				E12EditorContainer e12editorcontainer = new E12EditorContainer(myPanel, entry, ""+randNo);
				e12editorcontainer.show();
				//Changed by Sagar B. to set query string data on link access[27Apr17]END
				//Added by Sagar B. to set query string data on link access[27Apr17]START
				e12editorcontainer.e12ProcessEditor.setQueryStrMap( queryStrMap );
				//Added by Sagar B. to set query string data on link access[27Apr17]END
				//Changed by Prasad on 08/12/16 [open process editor] END
			}
			// Added by Bhupendra on 13-Jan-17 for [ Summary Page implementation in Mobile Editor ] Starts
			//Link 7 = Editor
			else if ( "7".equals( linkType ))
			{
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//final int randNo = (int)( Math.random() * 1000000000 ) + 1;
				final int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
				final EntryWrapper entry = new EntryWrapper();
				entry.setTitle( linkTitle );
				entry.setObjName(targetObjName);
				entry.setObjType( "W" );
				entry.setId("ID001~" + randNo);
				String menuImage = E12Global.getHostUrl() +"/ibase/images/menuImages/mob/" + linkImage;
				entry.setDownloadImgPath( menuImage );
				E12CommonUtils.printOnConsole("Inside Link menuImage ["+menuImage+"] linkImage ["+linkImage+"]");
				//Added by Prasad on 26/03/18 [offline transaction related setting] START
				boolean isObjOfflineEnabled = false;
				String offlineObjnamesStr = E12Global.checkNull( E12Storage.getItemLocalStorage("OFFLINE-OBJ-"+E12Constants.userID ) );
				E12CommonUtils.printOnConsole("Current offline objNames : offlineObjnamesStr ["+offlineObjnamesStr+"], isOffline() ["+ E12Global.getInstance().isOffline() +"]");
				if( offlineObjnamesStr.length() > 0 && offlineObjnamesStr.contains( objName ) && ! E12Global.getInstance().isHostedMode() )
				{
					isObjOfflineEnabled = true;
				}
				if( E12Global.getInstance().getConnectionMode() == ConnectionMode.AUTO && isObjOfflineEnabled )
				{
					DataSyncCache.beginTransaction( entry.getObjName(), entry.getTitle() );
				}
				//Added by Prasad on 26/03/18 [offline transaction related setting] END
				//Added by Bhupendra M. on 28-Feb-17 For Summary Page Issue on Click of Link Action Starts
				if(WallToWallPanel.activePanel != null && checkNull(WallToWallPanel.activePanel.toString()).length() > 0)
				{
					WallToWallPanel.activePanel.enter();
				}
				//Added by Bhupendra M. on 28-Feb-17 For Summary Page Issue on Click of Link Action Ends
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
				if( E12CommonUtils.getInstance().getPopupPanel() != null)
				{
					E12CommonUtils.getInstance().getPopupPanel().hide();
					E12CommonUtils.getInstance().setPopupPanel(null);
				}
				//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
				//Added by Pankaj R to restrict menu if condition satisfies in CONDN_ACC table. [START]
				final WallToWallPanel myPanel = WallToWallPanel.activePanel;
				HashMap<String, String> paramMap = new HashMap<String, String>();

				paramMap.put("ACTION", "RESTRICT_MENU");
				paramMap.put("target_objName", targetObjName);
				paramMap.put("obj_name", objName);
				paramMap.put("appl_name", E12Constants.conApplNm);
				String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
				url = E12Global.getHostUrl()+ "/ibase/WebITMLinkControllerServlet?" + paramString;
				E12RequestBuilder reqstBldr =new E12RequestBuilder( E12RequestBuilder.GET, url );
				try
				{
					reqstBldr.sendRequest( "", new RequestCallback()
					{
						public void onResponseReceived( Request request, Response response )
						{
							String responseStr  = response.getText();
							if ( ! "false".equalsIgnoreCase( responseStr ) )
							{
								if( "Continue".equalsIgnoreCase( linkTitle.trim() ))
								{
									new E12EditorContainer(myPanel, entry, ""+randNo).show();
								}
								else
								{
									//added by vishal pathare on 26.4.18 for[ links related issue in feed data map ]
									new E12EditorContainer(myPanel, entry, ""+randNo, queryStrMap).show();//Changed by ashutosh on 8-june-17[For event_date]
								}
							}
						}

						@Override
						public void onError( Request request, Throwable exception )
						{
							// TODO Auto-generated method stub
						}
					});
				}
				catch (Exception e)
				{
					Window.alert( " Exception in restricting menu" + e.getMessage() );
				}
				//Added by Pankaj R to restrict menu if condition satisfies in CONDN_ACC table. [END]
				//new E12EditorContainer(myPanel, entry, ""+randNo).show();
				//new E12EditorContainer(myPanel, entry, ""+randNo, feedDataMap).show();//Changed by ashutosh on 8-june-17[For event_date]
				//Added by Bhupendra M on 01-08-17 for last_dcr_date issue End
			}
			//Added by Prasad on 26/08/19 [to display content usage in Card view form] START
			else if( "8".equalsIgnoreCase( linkType ) )
			{
				url = "";
				if ( qryStr != null && qryStr.length() > 0 )
				{
					JSONObject qryJsonObject = JSONParser.parseStrict( qryStr ).isObject();
					if ( qryJsonObject.containsKey( "USAGE_DETAIL_DATA" ) )
					{
						JSONArray usageData = qryJsonObject.get( "USAGE_DETAIL_DATA" ).isArray();
						E12CommonUtils.printOnConsole("usageData isArray()[" + usageData + "]");
						if ( usageData == null && feedDataMap != null )
						{
							String usageDetailData = feedDataMap.get( "usage_detail_data" );
							if ( usageDetailData != null )
							{
								usageData = JSONParser.parseStrict( usageDetailData ).isArray();
							}
						}
						E12CommonUtils.printOnConsole("usageData[" + usageData + "]");
						if ( usageData != null )
						{
							ContentUsageComponent contentUsageDetail = new ContentUsageComponent( usageData );
							if ( contentUsageDetail != null && contentUsageDetail.getWidgetCount() > 0 )
							{
								EntryWrapper entry = new EntryWrapper();
								entry.setTitle( linkTitle );
								new E12LinkContainer( entry ).showLinkWidget( contentUsageDetail );
							}
						}
						else
						{
							Window.alert( E12Constants.constants.setNoDataToDisplay() );
						}
					}
					else
					{
						Window.alert( E12Constants.constants.setNoDataToDisplay() );
					}
				}
				else
				{
					Window.alert( E12Constants.constants.setNoDataToDisplay() );
				}
			}
			//Added by Prasad on 26/08/19 [to display content usage in Card view form] END
			//Added by Prajyot on 06-AUG-18 [ For implementation of Link Type - A] Start
			else if( "A".equals( linkType ) )
			{
				url = "";
				EntryWrapper entry=new EntryWrapper();
				entry.setTitle(linkTitle);
				E12LinkContainer e12LinkContainer = new E12LinkContainer(entry);
				e12LinkContainer.createAngularLinkWidget(pkFieldValue.toString(), objName, targetObjName, linkType, linkUri, linkArgmnt, linkTitle, linkForm, qryStr, false, fieldName, linkImage);
			}
			// Added by Pankaj R on 26-DEC-19  Link type to download Datamodel [START]
			else if("9".equals(linkType))
			{
				String dataModelName = "";
				String[] qryStrArray = qryStr.split("&") ;
				for(int i=0 ; i < qryStrArray.length ; i++)
				{
					String paramKeyValue[] = qryStrArray[i].split("=");
					String fldName = E12Global.checkNull( paramKeyValue[0] );
					String fldValue = E12Global.checkNull( paramKeyValue[1] );
					fldValue = fldValue.replaceAll("[+]", " ");
					queryStrMap.put( fldName, fldValue);
				}
				if ( queryStrMap != null )
				{
					dataModelName = E12CommonUtils.checkNull( queryStrMap.get( "DATA_MODEL" ) );
				}
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
				//int randNo = (int)( Math.random() * 1000000000 ) + 1;
				int randNo = E12CommonUtils.getInstance().generateRandomNo();
				//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
				final EntryWrapper entry = new EntryWrapper();
				entry.setTitle( linkTitle );
				entry.setObjName( objName );
				if( pkFieldValue!=null && (E12CommonUtils.checkNull(pkFieldValue.toString()).length()>0) )
				{
					entry.setTranId( pkFieldValue.toString() );
				}
				entry.setId( "ID001~" + randNo );
				String argsXml = getMapAsXml(queryStrMap);
				String feedDataMapXml = getMapAsXml(feedDataMap);
				callToDownloadDMXsl(dataModelName, null, targetObjName, argsXml,feedDataMapXml, fieldName, new Callback<String, String>() {
					
					@Override
					public void onSuccess(String result) {
						if(checkNull(result).length() > 0)
						{
							E12HtmlPanel e12HtmlPanel = new E12HtmlPanel(result);
							new E12LinkContainer(entry, "", null).showLinkWidget(e12HtmlPanel);
						}
					}
					@Override
					public void onFailure(String reason) {
						printOnConsole("callDownloadDMXsl onFailure :");
					}
				});
			}
			// Added by Pankaj R on 26-DEC-19  Link type to download Datamodel [END]
			//Added by Prajyot on 06-AUG-18 [ For implementation of Link Type - A] End
			// Added by Bhupendra on 13-Jan-17 for [ Summary Page implementation in Mobile Editor ] Ends
			if ( ! ("".equals( url.toString() )) && isOpenInFrame )
			{
				url = E12Global.getHostUrl() + url;
				//Changed by Sainath T. on 13-Dec-2019 [ Side panel implementation in iOS ] -Start
				E12CommonUtils.printOnConsole("Show in panel perfor action link showInPanel:: ["+showInPanel+"] DeviceType()==[" +E12Global.getInstance().getDeviceType()+"]" );
				if(E12Global.getInstance().deviceOS == DeviceOS.iOS && !"1".equals( showInPanel ) && !( "ProcessTrail".equalsIgnoreCase( linkActionInfoBean.getLinkId() ) ) )
				{
					E12CommonUtils.openInAppBrowser(url, true);
				}
				else
				//Changed by Sainath T. on 13-Dec-2019 [ Side panel implementation in iOS ] -End
				{
					//Changed by Prasad on 08/12/16 [open exernal links] START
					//Window.open(url, "link_" + linkType + "_" + objName ,"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
					//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
					//int randNo = (int)( Math.random() * 1000000000 ) + 1;
					int randNo = E12CommonUtils.getInstance().generateRandomNo();
					//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
					EntryWrapper entry = new EntryWrapper();
					entry.setTitle( linkTitle );
					entry.setObjName( objName );
					//added by vishal pathare on 26.3.18 [for keyInfo display related changes]Start
					if( pkFieldValue!=null && (E12CommonUtils.checkNull(pkFieldValue.toString()).length()>0) )
					{
						entry.setTranId( pkFieldValue.toString() );
					}
					//added by vishal pathare on 26.3.18 [for keyInfo display related changes]End
					entry.setId( "ID001~" + randNo );
					//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser
					new E12LinkContainer( entry, url, null ).show(qryStr);
					//Changed by Prasad on 08/12/16 [open exernal links] END
				}
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("In Perform LinkAction Exception[" + e.getMessage() + "]");
		}
	}
	//Added by Reema on 10-sep-14 [link to perform actions for actionInfoBean] - End

	//Added by Reema on 12-sep-14 [Get query Parameter]
	protected String getQueryParam(ArrayList< String> sourceField , ArrayList< String > targetField, ArrayList<String> dataGridHeaderLogicalColName, boolean isAnyRowSelected, DataGridTableRowModel selectedDGTRModel, HashMap< String,String > feedDataMap )
	{
		String qryString ="";
		try
		{
			HashMap<String, String> queryParamsMap = new HashMap<String, String>();

			for(int srcFldcnt=0 ; srcFldcnt<  sourceField.size(); srcFldcnt++)
			{
				String columnName = sourceField.get( srcFldcnt );
				String paramName = targetField.get( srcFldcnt );
				if ( dataGridHeaderLogicalColName != null && dataGridHeaderLogicalColName.contains( columnName ) && isAnyRowSelected )
				{
					if ( selectedDGTRModel == null && feedDataMap != null )
					{
						String paramValue = feedDataMap.get(columnName);
						queryParamsMap.put(paramName, paramValue);
					}
					else if ( selectedDGTRModel != null )
					{
						String paramValue = selectedDGTRModel.getCellText( columnName );
						queryParamsMap.put(paramName, paramValue);
					}
				}
				else if ( feedDataMap != null && feedDataMap.containsKey( columnName ) )
				{
					String paramValue = feedDataMap.get( columnName );
					queryParamsMap.put(paramName, paramValue);
				}
				else
				{
					queryParamsMap.put(paramName, columnName);
				}
			}
			qryString = getEncodedParamString(queryParamsMap);
		}
		catch(Exception e)
		{
			Window.alert( "Exception in getQueryParam[" + e.getMessage() + "]");
		}
		return qryString;
	}
	//Added by Reema on 12-sep-14 [Get query Parameter]

	private void callServiceHandler4( HomePgActionInfoBean actionInfoBean, StringBuffer pkFieldValue, String objName, String reqParamStr, String xmlDataStr, FeedData feedDataMap, E12ParentEditor e12ParentEditor )
	{
		try
		{
			String local_edit_mode = "E";
			//Added by Prasad on 08/06/17 [to actions implementation in browser]
			//int domID = feedDataMap.get("domID") == null ? 0 : (int)Double.parseDouble( feedDataMap.get("domID") );
			String keyValue = "";
			if ( e12ParentEditor != null )
			{
				keyValue = e12ParentEditor.getPageUtil().getFormDataMapObj().getDomId();
			}
			E12CommonUtils.printOnConsole( "In callServiceHandler4 keyValue - ["+ keyValue +"]" );
			String hdrDataStr = "<header>"
					+ "<objName><![CDATA[" + objName + "]]></objName>"
					+ "<pageContext><![CDATA[1]]></pageContext>"
					+ "<objContext><![CDATA["+ actionInfoBean.getObjContext() +"]]></objContext>"
					+ "<editFlag><![CDATA[" + local_edit_mode + "]]></editFlag>"
					+ "<focusedColumn><![CDATA[]]></focusedColumn>"
					+ "<elementName><![CDATA[]]></elementName>"
					+ "<keyValue><![CDATA["+ keyValue +"]]></keyValue>"
					+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
					+ "<saveLevel><![CDATA[0]]></saveLevel>"
					+ "<forcedSave><![CDATA[false]]></forcedSave>"
					+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
					+ "</header>";
			String xmlString = "<?xml version='1.0' encoding='utf-8'?>"
					+ "<Root>"
					+ hdrDataStr
					+ xmlDataStr
					+ "</Root>";
			String serviceHandlerData = getServiceHandlerData(actionInfoBean, pkFieldValue, objName);
			getServiceHandler4Data( "USER_ACTION", E12Global.getInstance().getEditorID( objName ), xmlString, hdrDataStr, serviceHandlerData, e12ParentEditor );
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	private String getServiceHandlerData( HomePgActionInfoBean actionInfoBean, StringBuffer pkFieldValue, String objName )
	{
		return "<?xml version='1.0' encoding='utf-8'?>"
				+ "<Root>"
				+ "<header>"
				+ "<OBJ_NAME><![CDATA[" + objName + "]]></OBJ_NAME>"
				+ "<TITLE><![CDATA[" + actionInfoBean.getTitle() + "]]></TITLE>"
				+ "<SERVICE_HANDLER><![CDATA[" + actionInfoBean.getServiceHandler() + "]]></SERVICE_HANDLER>"
				+ "<SERVICE_CODE><![CDATA["+ actionInfoBean.getServiceCodeCData() +"]]></SERVICE_CODE>"
				+ "<REF_ID><![CDATA[" + pkFieldValue.toString() + "]]></REF_ID>"
				+ "<COMP_TYPE><![CDATA[" + actionInfoBean.getCmpType() + "]]></COMP_TYPE>"
				+ "<COMP_NAME><![CDATA[" + actionInfoBean.getCmpName() + "]]></COMP_NAME>"
				+ "<METHOD_NAME><![CDATA["+ actionInfoBean.getMetName() +"]]></METHOD_NAME>"
				+ "</header>"
				+ "</Root>";
	}

	/**
	 *
	 * @param action
	 * @param serviceHandler
	 * @param editorId
	 * @param eventCode
	 * @param objName
	 * @param refId
	 * @param compType
	 * @param compName
	 * @param methodName
	 * @param chgStr
	 * @param headerStr
	 * @param e12ParentEditor
	 */
	private void getServiceHandler4Data( String action, String editorId, String chgStr, String headerStr, String serviceHandlerStr, final E12ParentEditor e12ParentEditor )
	{
		try
		{
			final PopupPanel viewPopupPanel = new PopupPanel( false, true );

			E12ServiceHandler4Container serviceHandler4Container = new E12ServiceHandler4Container();
			serviceHandler4Container.getServiceHandlerData( action, editorId, chgStr, headerStr, serviceHandlerStr, viewPopupPanel, e12ParentEditor );

			viewPopupPanel.setWidget( serviceHandler4Container );
			viewPopupPanel.getElement().setId( "serviceHandler4Popup" );
			/*viewPopupPanel.addStyleNameToContainer( "tnc-bubblebox" );
			int clientWidth = Window.getClientWidth();
			int clientHeight = Window.getClientHeight();
			viewPopupPanel.setWidth( ( clientWidth - 20 ) + "px" );
			viewPopupPanel.setHeight( ( clientHeight - 30 ) + "px" );
			viewPopupPanel.getElement().getStyle().setZIndex( 4 );
			viewPopupPanel.center();
			viewPopupPanel.show();*/

			viewPopupPanel.setPopupPosition(0, 0);
			Style style = viewPopupPanel.getElement().getStyle();
			style.setHeight(100, Unit.PCT);
			style.setWidth(100, Unit.PCT);
			style.setZIndex(10);

			viewPopupPanel.setStyleName("dialogPopupPanel");

			viewPopupPanel.show();
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole( "Exception - getServiceHandlerData :["+ e.getMessage() +"]");
			e.printStackTrace();
		}
	}

	//Added by Prasad on 22/01/18 [implementation of action handler 9 - actions on detail form] START
	public void callServiceHandler( String objName, final String serviceHandler, StringBuffer pkFieldName, StringBuffer pkFieldValue, HomePgActionInfoBean actionInfoBean, final E12ParentEditor e12ParentEditor)
	{
		if( pkFieldValue.charAt( pkFieldValue.length()-1 )==':' )
		{
			pkFieldValue.deleteCharAt( pkFieldValue.length()-1 );
		}
		if( pkFieldName.charAt( pkFieldName.length()-1 )==':' )
		{
			pkFieldName.deleteCharAt( pkFieldName.length()-1 );
		}
		String local_edit_mode = "E";
		String keyValue = "";
		if ( e12ParentEditor != null )
		{
			keyValue = e12ParentEditor.getPageUtil().getFormDataMapObj().getDomId();
		}
		E12CommonUtils.printOnConsole( "In callServiceHandler keyValue - ["+ keyValue +"]" );
		final int formNo = Integer.parseInt( actionInfoBean.getObjContext() );
		E12CommonUtils.printOnConsole( "In callServiceHandler formNo - ["+ formNo +"]" );
		String chgString = "<?xml version='1.0' encoding='utf-8'?>"
				+ "<Root>"
				+ "<header>"
				+ "<objName><![CDATA[" + objName + "]]></objName>"
				+ "<pageContext><![CDATA[1]]></pageContext>"
				+ "<objContext><![CDATA["+ formNo +"]]></objContext>"
				+ "<editFlag><![CDATA[" + local_edit_mode + "]]></editFlag>"
				+ "<focusedColumn><![CDATA[]]></focusedColumn>"
				+ "<elementName><![CDATA[]]></elementName>"
				+ "<keyValue><![CDATA["+ keyValue +"]]></keyValue>"
				+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
				+ "<saveLevel><![CDATA[0]]></saveLevel>"
				+ "<forcedSave><![CDATA[false]]></forcedSave>"
				+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
				+ "</header>"
				+ "</Root>";

		HashMap<String, String> paramMap = new HashMap<String, String>();
		paramMap.put( "SERVICE_HANDLER", serviceHandler );
		paramMap.put( "SERVICE_CODE", actionInfoBean.getServiceCodeCData() );
		paramMap.put( "OBJ_NAME", objName );
		paramMap.put( "REF_ID", pkFieldValue.toString() );
		paramMap.put( "COMP_TYPE", actionInfoBean.getCmpType() );
		paramMap.put( "COMP_NAME", actionInfoBean.getCmpName() );
		paramMap.put( "METHOD_NAME", actionInfoBean.getMetName() );
		paramMap.put( "CHG_STR", chgString );
		paramMap.put( "TITLE", actionInfoBean.getTitle() );
		paramMap.put( "CORE_MDL_ID", E12Global.getInstance().getEditorID( objName ) );
		paramMap.put( "INTERFACE", "MOBILE" );
		paramMap.put( "isDecode", "false" );
		paramMap.put( "PK_FLD_NAMES", pkFieldName.toString() );
		paramMap.put( "ACTION_CHAR", actionInfoBean.getId() );
		paramMap.put( "dummyInt", ""+Math.random() );
		paramMap.put( "ACTION_ID", actionInfoBean.getActionId());

		String[] reqParamStrNXmlArr = e12ParentEditor.getSelectedFormData().split( "-!SEP!-" );
		String reqParamStr = E12CommonUtils.checkNull( reqParamStrNXmlArr[0] );
		String reqParamXml = E12CommonUtils.checkNull( reqParamStrNXmlArr[1] );
		paramMap.put( "XML_STR", reqParamXml );

		E12CommonUtils.printOnConsole( "	"+ reqParamStr +"], reqParamXml - ["+ reqParamXml +"]" );

		String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);

		final HashMap<String, String> requestDataMap = new HashMap<String, String>();
		requestDataMap.put( RequestDataKeys.REQUEST_DATA, paramString );
		requestDataMap.put( RequestDataKeys.METHOD_NAME, "" );
		requestDataMap.put( RequestDataKeys.FORM_NO, formNo+"" );

		String url = E12Global.getHostUrl() + "/ibase/WebITMServiceHandlerServlet"+serviceHandler;
		E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.POST, url );
		try
		{
			requestBuilder.setHeader( "Content-Type", "application/x-www-form-urlencoded" );
			requestBuilder.sendRequest( requestDataMap, new RequestCallback()
			{
				public void onResponseReceived(Request request, Response response)
				{
					String responseStr = checkNull( response.getText() );
					if ( ! "false".equalsIgnoreCase( responseStr ) )
					{
						E12CommonUtils.printOnConsole( "responseStr - ["+ responseStr +"]" );
						//Added by Ajinkya D on 24-Jan-2018 [To show attachments] [START]
						JSONArray docIdJsonArr = new JSONArray();
						if ( responseStr.length() > 0 )
						{
							String respArr[] = responseStr.split( "," );
							for( int i = 0; i < respArr.length; i++ )
							{
								String docList[] = respArr[i].split( "::" );
								if ( docList.length > 1 )
								{
									JSONObject content = new JSONObject();
									content.put( "ID", new JSONString( docList[0] ) ); //DOC_ID
									content.put( "NAME", new JSONString( docList[1] ) ); //DOC_NAME
									docIdJsonArr.set( i, content );
								}
							}
						}
						//showContents( docIdJsonArr );
						showContents( docIdJsonArr, null );
						//Added by Ajinkya D on 24-Jan-2018 [To show attachments] [END]
					}
				}
				public void onError(Request request, Throwable exception)
				{

				}
			});
		}
		catch(Exception e)
		{
			Window.alert(" E12CommonUtils: callServiceHandler method" + e.getMessage());
		}
	}
	//Added by Prasad on 22/01/18 [implementation of action handler 9 - actions on detail form] END

	public void callServiceHandler( final String objName, final String serviceHandler, StringBuffer pkFieldName, StringBuffer pkFieldValue, HomePgActionInfoBean actionInfoBean, final E12ParentEditor e12ParentEditor, Object object , final Callback<String, Boolean> callback )
	{
		if( pkFieldValue.charAt( pkFieldValue.length()-1 )==':' )
		{
			pkFieldValue.deleteCharAt( pkFieldValue.length()-1 );
		}
		if( pkFieldName.charAt( pkFieldName.length()-1 )==':' )
		{
			pkFieldName.deleteCharAt( pkFieldName.length()-1 );
		}
		String local_edit_mode = "A";
		//Added by Prasad on 08/06/17 [to actions implementation in browser]
		if ( "3".equalsIgnoreCase( serviceHandler ) )
		{
			local_edit_mode = "E";
		}
		String keyValue = "";
		if ( e12ParentEditor != null )
		{
			keyValue = e12ParentEditor.getPageUtil().getFormDataMapObj().getDomId();
		}
		E12CommonUtils.printOnConsole( "In callServiceHandler keyValue nilesh - ["+ keyValue +"]" );
		final int formNo = Integer.parseInt( actionInfoBean.getObjContext() );
		E12CommonUtils.printOnConsole( "In callServiceHandler formNo - ["+ formNo +"]" );
		String chgString = "<?xml version='1.0' encoding='utf-8'?>"
				+ "<Root>"
				+ "<header>"
				+ "<objName><![CDATA[" + objName + "]]></objName>"
				+ "<pageContext><![CDATA[1]]></pageContext>"
				+ "<objContext><![CDATA["+ formNo +"]]></objContext>"
				+ "<editFlag><![CDATA[" + local_edit_mode + "]]></editFlag>"
				+ "<focusedColumn><![CDATA[]]></focusedColumn>"
				+ "<elementName><![CDATA[]]></elementName>"
				+ "<keyValue><![CDATA["+ keyValue +"]]></keyValue>"
				+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
				+ "<saveLevel><![CDATA[0]]></saveLevel>"
				+ "<forcedSave><![CDATA[false]]></forcedSave>"
				+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
				+ "</header>"
				+ "</Root>";

		HashMap<String, String> paramMap = new HashMap<String, String>();
		paramMap.put( "SERVICE_HANDLER", serviceHandler );
		paramMap.put( "SERVICE_CODE", actionInfoBean.getServiceCodeCData() );
		paramMap.put( "OBJ_NAME", objName );
		paramMap.put( "REF_ID", pkFieldValue.toString() );
		paramMap.put( "COMP_TYPE", actionInfoBean.getCmpType() );
		paramMap.put( "COMP_NAME", actionInfoBean.getCmpName() );
		paramMap.put( "METHOD_NAME", actionInfoBean.getMetName() );
		paramMap.put( "CHG_STR", chgString );
		paramMap.put( "TITLE", actionInfoBean.getTitle() );
		paramMap.put( "CORE_MDL_ID", E12Global.getInstance().getEditorID( objName ) );
		paramMap.put( "INTERFACE", "MOBILE" );
		paramMap.put( "isDecode", "false" );
		if( serviceHandler.equalsIgnoreCase("2") )
		{
			paramMap.put( "PK_FLD_NAMES", pkFieldName.toString() );
			paramMap.put( "ACTION_CHAR", actionInfoBean.getId() );
		}
		paramMap.put( "dummyInt", ""+Math.random() );
		paramMap.put( "ACTION_ID", actionInfoBean.getActionId());

		String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
		String url = E12Global.getHostUrl() + "/ibase/WebITMServiceHandlerServlet"+serviceHandler + "?" + paramString;
		E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.POST, url );
		//RequestBuilder requestBuilder = new RequestBuilder( E12RequestBuilder.POST, url );
		try
		{
			requestBuilder.sendRequest("" , new RequestCallback()
			{
				public void onResponseReceived(Request request, Response response)
				{
					/*if( E12Global.getInstance().checkErrorException(response, 1) )
					{*/
						String responseStr = response.getText();
						//Added by Prasad on 08/06/17 [to actions implementation in browser]
						if ( ! "false".equalsIgnoreCase( responseStr ) )
						{
							callback.onSuccess("true");
							//Document doc = XMLParser.parse( responseStr );
							//XMLParser.removeWhitespace( doc );
							//NodeList nlst = doc.getElementsByTagName("error");
							
							String colVal = "", finalStr = "";
							E12CommonUtils.printOnConsole("Nilesh GUnjal");
							if(responseStr.length() > 0)
							{
								//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - start
								Document dom = XMLParser.parse(responseStr);
								XMLParser.removeWhitespace(dom);
								NodeList MessageList = dom.getElementsByTagName("Message");
	
								int MsgLength = 0;
								if(MessageList != null)
								{
									MsgLength = MessageList.getLength();
								}
								E12CommonUtils.printOnConsole("MsgLength is on confirm click["+MsgLength+"]");
								for(int i=0; i<MsgLength; i++)
								{
									String typeNodeValue = "";
									if( dom.getElementsByTagName("Message").item(i) != null )
									{
										Node msg = dom.getElementsByTagName("Message").item(i);
										Node type = msg.getAttributes().getNamedItem("type");
										typeNodeValue = E12Global.checkNull( type.getNodeValue() );
										E12CommonUtils.printOnConsole("Inside error message typeNodeValue ["+typeNodeValue+"]");
									}
									
									if( dom.getElementsByTagName("message").item(i) != null )
									{
										Node msg = dom.getElementsByTagName("message").item(i);
										String message = msg.getFirstChild().getNodeValue();
										String messageDescription = "";
										String traceString = "";
										if( dom.getElementsByTagName("description").item(i) != null )
										{
											Node description = dom.getElementsByTagName("description").item(i);
											messageDescription = E12CommonUtils.checkNull( description.getFirstChild().getNodeValue() );
										}
										if( dom.getElementsByTagName("trace").item(i) != null )
										{
											Node trace = dom.getElementsByTagName("trace").item(0);
											traceString =  trace.getFirstChild().getNodeValue();
										}
										
										String displayMessage = "";
										/*if("P".equals(typeNodeValue))
										{
											displayMessage = message + "<br>" + messageDescription;
										}
										else*/
										{
											displayMessage += "<html>";
											displayMessage += "<span id='errorMsgid' class='select-text'>"+message+"</span>";
											displayMessage += "<br><br><span id='errorDescid' class='select-text'>"+messageDescription+"</span>";
											if( traceString.length() > 0 )
											{
												displayMessage += "<br><br><div id='details-id' ><span id='errorTraceid' class='select-text'>"+traceString+"</span></div>";
											}
											displayMessage += "</html>";
										}													
										printOnConsole("In confirm displayMessage:["+displayMessage+"]");
										
										if( "W".equalsIgnoreCase(typeNodeValue) )
										{
											E12AlertBox.getInstance().confirm(displayMessage, "Warning", new CallbackHandler() {
	
												@Override
												public void onCallback(boolean result) {
	
	
													if( result )
													{
														printOnConsole("In confirm warning ok");
													}
													else
													{
														printOnConsole("In confirm warning cancel");
														if( E12AlertBox.getAlertMap().size() > 0 )
														{
															E12AlertBox.getAlertMap().clear();
														}
														return;
													}
	
												}
											});
										}
										else if("E".equalsIgnoreCase(typeNodeValue) || "X".equalsIgnoreCase(typeNodeValue))
										{
											printOnConsole("In confirm error");
										}
										else if( "P".equalsIgnoreCase(typeNodeValue) )
										{
											if( "MOBILE".equals(E12UserInfo.getCallerInterface()) )
											{
												//Added by pramod s for prompt alert in mobile case 
												//Window.alert(displayMessage);
												printOnConsole("inside mobile casec chages fpr prompt");
												E12AlertBox.setError(false);
												E12AlertBox.getInstance().alert( displayMessage , "Prompt" , new CallbackHandler()
												{
													@Override
													public void onCallback(boolean result)
													{
														if( result )
														{
															printOnConsole("In confirm prompt");
														}
													}
												});
												//Added by pramod s for prompt alert in mobile case 
											}
											else
											{
												E12AlertBox.setError(false);
												E12AlertBox.getInstance().alert( displayMessage , "Prompt" , new CallbackHandler()
												{
													@Override
													public void onCallback(boolean result)
													{
														if( result )
														{
															printOnConsole("In confirm prompt");
														}
													}
												});
											}
										}
									}
								}
								//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - end
								
								Document document = XMLParser.parse( responseStr );
								XMLParser.removeWhitespace( document );
								if( document.getElementsByTagName( "additionInfo" ).item(0) != null )
								{
									NodeList additionInfoList = document.getElementsByTagName( "additionInfo" );
									NodeList childList = additionInfoList.item(0).getChildNodes();
									int additionInfoChildLength = additionInfoList.item(0).getChildNodes().getLength();
									for( int i = 0; i < additionInfoChildLength; i++)
									{
										colVal = childList.item(i).getFirstChild().getNodeValue();
										E12CommonUtils.printOnConsole("colVal ::"+colVal);
										if(i == 1)
										{
											finalStr = finalStr+"~SEP~"+colVal;
										}
										else
										{
											finalStr = colVal;
										}
									}
									E12CommonUtils.printOnConsole("E12CommonUtils.callServiceHandler(...) finalStr ["+finalStr+"]");
									callback.onSuccess("true~SEP~"+finalStr);
								}
							}
						//Added by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [END]
							
							
							
							if ( "3".equalsIgnoreCase( serviceHandler ) && e12ParentEditor != null )
							{
								e12ParentEditor.getPageUtil().getFormDataMapObj().clearFormDataMap();
								e12ParentEditor.getPageUtil().getFormDataMapObj().setXMLDataToMap( formNo, responseStr );
								//Added by Prasad on 16/06/17 [resolve issue on previous data get clear] START
								String keyForm = "FORM_NO_";
								keyForm = keyForm + formNo;
								e12ParentEditor.getPageUtil().getFormDataMapObj().getAllFormDataMap().put( keyForm.trim(), responseStr );
								e12ParentEditor.setFormChange(false);
								e12ParentEditor.setFormDirty(false);
								e12ParentEditor.getPageUtil().getFormDataMapObj().clearMandatoryFieldMap();
								//Added by Prasad on 16/06/17 [resolve issue on previous data get clear] END
								e12ParentEditor.drawFeedFormPage( responseStr, formNo, "next" );
								if( ! E12Global.getInstance().hostedMode )
								{
									(WallToWallPanel.activePanel).contents.getElement().setScrollTop(E12Constants.CONTENTS_SCROLL_TOP);
								}
							}
							//Change by Sandeep S. on 20-JUL-18 [Deactivating DataModel on client if data goes dirty on server] Start
							else
							{
								updateDirtyDataModel(objName);
							}
							//Change by Sandeep S. on 20-JUL-18 [Deactivating DataModel on client if data goes dirty on server] End
						}
						else
						{
							callback.onFailure(false);
						}
					/*}
					else
					{
						callback.onFailure(false);
					}*/
				}
				public void onError(Request request, Throwable exception)
				{
					callback.onFailure(false);
				}
			});
		}
		catch(Exception e)
		{
			callback.onFailure(false);
			Window.alert(" E12CommonUtils: callServiceHandler method" + e.getMessage());
		}
	}
	//Added by Prasad on 19/10/16 [for service handler 4 implementation] END

	//Added by Reema on 12-sep-14 [calls service handler to perform action]
	public void callServiceHandler( String objName, String serviceHandler, StringBuffer pkFieldName, StringBuffer pkFieldValue, HomePgActionInfoBean actionInfoBean, final Callback<String, Boolean> callback)
	{
		if( pkFieldValue.charAt( pkFieldValue.length()-1 )==':' )
		{
			pkFieldValue.deleteCharAt( pkFieldValue.length()-1 );
		}
		if( pkFieldName.charAt( pkFieldName.length()-1 )==':' )
		{
			pkFieldName.deleteCharAt( pkFieldName.length()-1 );
		}
		String local_edit_mode = "A";
		if ( "3".equalsIgnoreCase( serviceHandler ) )
		{
			local_edit_mode = "E";
		}
		String chgString = "<?xml version='1.0' encoding='utf-8'?>"
				+ "<Root>"
				+"<header>"
				+ "<objName><![CDATA[" + objName + "]]></objName>"
				+ "<pageContext><![CDATA[1]]></pageContext>"
				+ "<objContext><![CDATA["+actionInfoBean.getObjContext()+"]]></objContext>"
				+ "<editFlag><![CDATA[" + local_edit_mode + "]]></editFlag>"
				+ "<focusedColumn><![CDATA[]]></focusedColumn>"
				+ "<elementName><![CDATA[]]></elementName>"
				+ "<keyValue><![CDATA[]]></keyValue>"
				+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
				+ "<saveLevel><![CDATA[0]]></saveLevel>"
				+ "<forcedSave><![CDATA[false]]></forcedSave>"
				+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
				+ "</header>"
				+ "</Root>";

		HashMap<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("SERVICE_HANDLER", serviceHandler );
		paramMap.put("SERVICE_CODE", actionInfoBean.getServiceCodeCData() );
		paramMap.put("OBJ_NAME", objName );
		paramMap.put("REF_ID", pkFieldValue.toString() );
		paramMap.put("COMP_TYPE", actionInfoBean.getCmpType() );
		paramMap.put("COMP_NAME", actionInfoBean.getCmpName() );
		paramMap.put("METHOD_NAME", actionInfoBean.getMetName() );
		paramMap.put("CHG_STR", chgString );
		paramMap.put("TITLE", actionInfoBean.getTitle() );
		paramMap.put("isDecode", "false");
		if( serviceHandler.equalsIgnoreCase("2") )
		{
			paramMap.put("PK_FLD_NAMES", pkFieldName.toString());
			paramMap.put("ACTION_CHAR", actionInfoBean.getId());
		}
		paramMap.put("dummyInt", ""+Math.random() );
		paramMap.put("ACTION_ID", actionInfoBean.getActionId());

		String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
		//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - start
		HashMap<String, String> requestDataMap = new HashMap<String, String>();
		requestDataMap.put(RequestDataKeys.REQUEST_DATA, paramString.toString());
		
		//String url = E12Global.getHostUrl() + "/ibase/WebITMServiceHandlerServlet"+serviceHandler + "?" + paramString;
		String url = E12Global.getHostUrl() + "/ibase/WebITMServiceHandlerServlet"+serviceHandler;
		//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - end
		E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.POST, url );
		try
		{
			//requestBuilder.sendRequest("" , new RequestCallback()
			//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - end
			requestBuilder.setHeader("Content-Type","application/x-www-form-urlencoded");
			requestBuilder.sendRequest(requestDataMap , new RequestCallback()
			{
				public void onResponseReceived(Request request, Response response)
				{
					//TODO : alert shows two times on confirm/delete
					//					if( E12Global.getInstance().checkErrorException(response, 1) )
					//					{
					/*Document doc = XMLParser.parse( response.getText() );
						XMLParser.removeWhitespace( doc );
						NodeList nlst = doc.getElementsByTagName("error");
						String descriptionValue =  nlst.item(0).getChildNodes().item( 1 ).getFirstChild().getNodeValue();*/
					//						Window.alert( descriptionValue );
					//					}
					//Added by Sagar B. to refresh calendar data on summary delete[13/Apr/18]START
					E12CalendarController e12CalendarController = E12Global.getInstance().getE12CalendarController();
					E12CommonUtils.printOnConsole("1371 Summary page ["+e12CalendarController+"]");
					if( e12CalendarController != null )
					{
						E12CommonUtils.printOnConsole("1374 Summary page e12CalendarController calling refresh data");
						e12CalendarController.refreshCalendarData(null);
					}
					//Added by Sagar B. to refresh calendar data on summary delete[13/Apr/18]END
					//Added by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [START]
					String responseStr = response.getText();
					String colVal = "", finalStr = "";
					
					printOnConsole("In callServiceHandler responseStr :["+responseStr+"]");
					if ( ! "false".equalsIgnoreCase( responseStr ) )
					{
						if(responseStr.length() > 0)
						{
							//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - start
							Document dom = XMLParser.parse(responseStr);
							XMLParser.removeWhitespace(dom);
							NodeList MessageList = dom.getElementsByTagName("Message");

							int MsgLength = 0;
							if(MessageList != null)
							{
								MsgLength = MessageList.getLength();
							}
							E12CommonUtils.printOnConsole("MsgLength is on confirm click["+MsgLength+"]");
							for(int i=0; i<MsgLength; i++)
							{
								String typeNodeValue = "";
								if( dom.getElementsByTagName("Message").item(i) != null )
								{
									Node msg = dom.getElementsByTagName("Message").item(i);
									Node type = msg.getAttributes().getNamedItem("type");
									typeNodeValue = E12Global.checkNull( type.getNodeValue() );
									E12CommonUtils.printOnConsole("Inside error message typeNodeValue ["+typeNodeValue+"]");
								}
								
								if( dom.getElementsByTagName("message").item(i) != null )
								{
									Node msg = dom.getElementsByTagName("message").item(i);
									String message = msg.getFirstChild().getNodeValue();
									String messageDescription = "";
									String traceString = "";
									if( dom.getElementsByTagName("description").item(i) != null )
									{
										Node description = dom.getElementsByTagName("description").item(i);
										messageDescription = E12CommonUtils.checkNull( description.getFirstChild().getNodeValue() );
									}
									if( dom.getElementsByTagName("trace").item(i) != null )
									{
										Node trace = dom.getElementsByTagName("trace").item(0);
										traceString =  trace.getFirstChild().getNodeValue();
									}
									
									String displayMessage = "";
									/*if("P".equals(typeNodeValue))
									{
										displayMessage = message + "<br>" + messageDescription;
									}
									else*/
									{
										displayMessage += "<html>";
										displayMessage += "<span id='errorMsgid' class='select-text'>"+message+"</span>";
										displayMessage += "<br><br><span id='errorDescid' class='select-text'>"+messageDescription+"</span>";
										if( traceString.length() > 0 )
										{
											displayMessage += "<br><br><div id='details-id' ><span id='errorTraceid' class='select-text'>"+traceString+"</span></div>";
										}
										displayMessage += "</html>";
									}													
									printOnConsole("In confirm displayMessage:["+displayMessage+"]");
									
									if( "W".equalsIgnoreCase(typeNodeValue) )
									{
										E12AlertBox.getInstance().confirm(displayMessage, "Warning", new CallbackHandler() {

											@Override
											public void onCallback(boolean result) {


												if( result )
												{
													printOnConsole("In confirm warning ok");
												}
												else
												{
													printOnConsole("In confirm warning cancel");
													if( E12AlertBox.getAlertMap().size() > 0 )
													{
														E12AlertBox.getAlertMap().clear();
													}
													return;
												}

											}
										});
									}
									else if("E".equalsIgnoreCase(typeNodeValue) || "X".equalsIgnoreCase(typeNodeValue))
									{
										printOnConsole("In confirm error");
									}
									else if( "P".equalsIgnoreCase(typeNodeValue) )
									{
										if( "MOBILE".equals(E12UserInfo.getCallerInterface()) )
										{
											//Added by pramod s for prompt alert in mobile case 
											//Window.alert(displayMessage);
											printOnConsole("inside mobile casec chages fpr prompt");
											E12AlertBox.setError(false);
											E12AlertBox.getInstance().alert( displayMessage , "Prompt" , new CallbackHandler()
											{
												@Override
												public void onCallback(boolean result)
												{
													if( result )
													{
														printOnConsole("In confirm prompt");
													}
												}
											});
											//Added by pramod s for prompt alert in mobile case 
											
											
										}
										else
										{
											E12AlertBox.setError(false);
											E12AlertBox.getInstance().alert( displayMessage , "Prompt" , new CallbackHandler()
											{
												@Override
												public void onCallback(boolean result)
												{
													if( result )
													{
														printOnConsole("In confirm prompt");
													}
												}
											});
										}
									}
								}
							}
							//Added by Pankaj T. on 27-03-2020 for Before confirmation warning message is bypassed, not displaying in front-end - end
							
							Document document = XMLParser.parse( responseStr );
							XMLParser.removeWhitespace( document );
							if( document.getElementsByTagName( "additionInfo" ).item(0) != null )
							{
								NodeList additionInfoList = document.getElementsByTagName( "additionInfo" );
								NodeList childList = additionInfoList.item(0).getChildNodes();
								int additionInfoChildLength = additionInfoList.item(0).getChildNodes().getLength();
								for( int i = 0; i < additionInfoChildLength; i++)
								{
									colVal = childList.item(i).getFirstChild().getNodeValue();
									E12CommonUtils.printOnConsole("colVal ::"+colVal);
									if(i == 1)
									{
										finalStr = finalStr+"~SEP~"+colVal;
									}
									else
									{
										finalStr = colVal;
									}
								}
								E12CommonUtils.printOnConsole("E12CommonUtils.callServiceHandler(...) finalStr ["+finalStr+"]");
								callback.onSuccess("true~SEP~"+finalStr);
							}
						}
						//Added by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [END]
					}
				}
				public void onError(Request request, Throwable exception)
				{

				}
			});
		}
		catch(Exception e)
		{
			Window.alert(" E12CommonUtils: callServiceHandler method" + e.getMessage());
		}
	}
	//Added by Reema on 12-sep-14 [calls service handler to perform action]-End
	//Added by Savita on 19-03-2015 [to get node value]-start
	public String getNodeValue(Document xmlDom, String tagName, String colName)
	{
		String nodeValue = "";
		Node tagNode = null;
		try
		{
			NodeList detailNodeList = xmlDom.getElementsByTagName( tagName );
			if( detailNodeList != null )
			{
				tagNode = detailNodeList.item(0);
				if( checkNull( colName ).trim().length() == 0 )
				{
					nodeValue = getNodeValue( tagNode );
				}
				else
				{
					xmlDom =  XMLParser.parse( tagNode.toString() );
					detailNodeList = xmlDom.getElementsByTagName( colName );
					if( detailNodeList != null )
					{
						tagNode = detailNodeList.item(0);
						nodeValue = getNodeValue( tagNode );
					}
				}
			}
		}
		catch(Exception e)
		{
			Window.alert("E21CommonUtils Exception : getNodeValue :" + e.getMessage());
		}
		return nodeValue;
	}

	public String getNodeValue( Node columnNode )
	{
		String nodeValue = "";
		if( columnNode != null )
		{
			if( columnNode.hasChildNodes() )
			{
				nodeValue = columnNode.getFirstChild().getNodeValue();
			}
			else
			{
				nodeValue = columnNode.getNodeValue();
			}
		}
		return nodeValue;
	}
	//Added by Savita on 19-03-2015 [to get node value]-end
	//Added by Dnyaneshwar & Ajinkya on 30-March-15 [Convert the date value into standard date format because JS not parsing a data as 'dd/MM/yy' format] Start
	/**
	 * This method convert the standard date format like below format  <br>
	 *  1. yyyy-MM-dd
	 *
	 * @param dateValStr the date value in string data type
	 * @return the string value
	 */
	public String getStndDateFrmt( String dateValStr )
	{
		Date parseStndFrmt = DateTimeFormat.getFormat( E12Constants.dispDate ).parse( dateValStr );
		dateValStr = DateTimeFormat.getFormat( "yyyy-MM-dd" ).format( parseStndFrmt );
		return dateValStr;
	}
	//Added by Dnyaneshwar & Ajinkya on 30-March-15 [Convert the date value into standard date format because JS not parsing a data as 'dd/MM/yy' format] End

	//Added by Shivaji on 03-04-2015 to set AlertBOX center to Browser
	/**
	 * This method show customMsgBox center to client Browser
	 */
	public void repostionCustomMsgBox()
	{
		int xCordinate = Window.getClientWidth();
		int yCordinate = Window.getClientHeight();
		xCordinate = xCordinate / 2;
		yCordinate = yCordinate / 2;

		Element alertBox = DOM.getElementById("customMsgBox");

		if( alertBox != null )
		{
			int alertBoxHeigh = alertBox.getOffsetHeight();
			int alertBoxWidth = alertBox.getOffsetWidth();

			alertBoxHeigh = alertBoxHeigh / 2;
			alertBoxWidth = alertBoxWidth / 2;

			xCordinate = xCordinate - alertBoxWidth;
			yCordinate = yCordinate - alertBoxHeigh;

			alertBox.setAttribute("style", "top:" + yCordinate + "px; left:" + xCordinate + "px; visibility: visible; position: absolute; overflow: visible;");
		}
	}
	// Ended by Shivaji on 03-04-2015

	//TODO : By using Plugin instead of GeoLoaction class
	public void updateCurrentGeoPos( boolean isPluginSupported )
	{
		/*if( ! CommonPhoneGapUtil.checkNetworkAndMode() )
		{
			Window.alert( E12Constants.constants.setNoNetWork() ); //Changes by Raju 19-02-14 for I18N
			return;
		}*/

		if(isPluginSupported)
		{
			getCurrentLatLongPosition();
		}
		else
		{
			Geolocation geolocation = new Geolocation();
			geolocation.getCurrentLocation(new Callback<Position, PositionError>() {
				@Override
				public void onSuccess(Position currentGeoPos)
				{
					try
					{
						NumberFormat geoPosFormat = NumberFormat.getFormat("###.######");
						double latitude = currentGeoPos.getCoordinates().getLatitude();
						double longitude = currentGeoPos.getCoordinates().getLongitude();
						E12CommonUtils.printOnConsole("watchPosition latitude:[" + latitude + "]longitude:[" + longitude + "]");

						//String currentGeoPosParams = "&CURRENT_GEO_POS="+ geoPosFormat.format(latitude) + ", " + geoPosFormat.format(longitude);
						String currentGeoPosVal = geoPosFormat.format(latitude) + ", " + geoPosFormat.format(longitude);
						E12CommonUtils.printOnConsole("watchPosition currentGeoPosVal:" + currentGeoPosVal);
						E12Constants.currentGeoPos = currentGeoPosVal;
					}
					catch(Exception e)
					{
						E12CommonUtils.printOnConsole("getCurrentLocation onSuccess Exception:" + e.getMessage() );
					}
				}

				@Override
				public void onFailure(PositionError reason)
				{
					String errorMsg = "";
					switch( reason.getCode() )
					{
					case PositionError.PERMISSION_DENIED:
						errorMsg = "User denied the request for Geolocation.";
						break;
					case PositionError.POSITION_UNAVAILABLE:
						errorMsg = "Location information is unavailable.";
						break;
					case PositionError.TIMEOUT:
						errorMsg = "The request to get user location timed out.";
						break;
					case PositionError.UNKNOWN_ERROR:
						errorMsg = "An unknown error occurred.";
						break;
					}
					E12CommonUtils.printOnConsole("watchPosition onFailure:" + errorMsg);
				}
			});
		}
	}
	// Added by Reema [for GPSTracking]
	/**
	 * This method will give the current lat-long position
	 */
	private void getCurrentLatLongPosition()
	{
		E12CustomPlugin.getCurrentLatLongPosition( new E12CustomPlugin.CallBack() {

			@Override
			public void onSuccess( String result )
			{
				try
				{
					printOnConsole("In E12CommonUtils getCurrentLatLongPosition["+result+"]");
					result = E12CommonUtils.checkNull(result);
					if( !"".equalsIgnoreCase(result) && result.indexOf("<LATITUDE>") != -1 )
					{
						Document document = XMLParser.parse( result );
						String latitudeStr = document.getElementsByTagName("LATITUDE").item(0).getFirstChild().getNodeValue();
						String longitudeStr = document.getElementsByTagName("LONGITUDE").item(0).getFirstChild().getNodeValue();
						//commented by Bhupendra on 4-may-17
						//						String dataMode = "";
						//						if( document.getElementsByTagName("DATA_MODE") != null)
						//						{
						//							dataMode = document.getElementsByTagName("DATA_MODE").item(0).getFirstChild().getNodeValue();
						//						}
						//String altitudeStr = document.getElementsByTagName("ALTITUDE").item(0).getFirstChild().getNodeValue();
						//Added by Sagar B. for storing current address in table[16-Apr-18]START
						String currentGeoPosNameVal = "";
						if( document.getElementsByTagName("CURRENT_ADDRESS") != null)
						{
							currentGeoPosNameVal = E12CommonUtils.checkNull( document.getElementsByTagName("CURRENT_ADDRESS").item(0).getFirstChild().getNodeValue() );
						}
						//Added by Sagar B. for storing current address in table[16-Apr-18]END
						NumberFormat geoPosFormat = NumberFormat.getFormat("###.######");
						double latitude = Double.parseDouble(latitudeStr);
						double longitude = Double.parseDouble(longitudeStr);
						//double altitude = Double.parseDouble(altitudeStr);
						String currentGeoPosVal = geoPosFormat.format(latitude) + ", " + geoPosFormat.format(longitude);// + ", " + geoPosFormat.format(altitude);
						E12Constants.currentGeoPos = currentGeoPosVal;
						//Added by Sagar B. for storing current address in table[16-Apr-18]START
						if( currentGeoPosNameVal.length() > 250 )
						{
							currentGeoPosNameVal = currentGeoPosNameVal.substring(0, 250);
						}
						//Added by Sagar B. for storing current address in table[16-Apr-18]END
						E12Constants.currentGeoPosName = currentGeoPosNameVal;
						//						E12Constants.setDataMode(dataMode);//commented by Bhupendra on 4-may-17
						//E12CommonUtils.printOnConsole( "currentGeoPosVal: "+currentGeoPosVal );
						//Added by Sagar B. to set GEOPOS_ACCURACY and setting values in auto mode[23-Jul-18]START
						String geoPosAccuracy = "";
						if( document.getElementsByTagName("ACCURACY") != null)
						{
							geoPosAccuracy = E12CommonUtils.checkNull( document.getElementsByTagName("ACCURACY").item(0).getFirstChild().getNodeValue() );
						}
						E12Constants.geoPosAccuracy = geoPosAccuracy;

						E12Storage.localStorageVars.add("CURRENT_GEO_POS");
						E12Storage.setItem("CURRENT_GEO_POS", currentGeoPosVal);
						E12Storage.localStorageVars.add("CURRENT_GEO_POS_NAME");
						E12Storage.setItem("CURRENT_GEO_POS_NAME", currentGeoPosNameVal);
						E12Storage.localStorageVars.add("GEOPOS_ACCURACY");
						E12Storage.setItem("GEOPOS_ACCURACY", geoPosAccuracy);
						//Added by Sagar B. to set GEOPOS_ACCURACY and setting values in auto mode[23-Jul-18]END
					}
				}
				catch(Exception e)
				{
					Window.alert("Exception while parsing GeoPos:"+e.getMessage());
				}
			}

			@Override
			public void onError( String error )
			{
				E12CommonUtils.printOnConsole( "Exception while get current lat-long position: ["+error+"]" );
			}
		});
	}
	// Added by Reema [for GPSTracking]-End

	// Added by Reema on 11-Sep-15[for GeoFencing]-Start
	/**
	 * This method enables the GeoService depend on "GEO_FENCE_ENABLED" value
	 *
	 * @param connectionId - current connection id
	 * @param userId - current login user
	 */
	public void enableGeoTag( final String connectionId, final String userId, final String updateSource )
	{
		boolean isOnGPService = E12Constants.GEO_FENCE_ENABLED == "1" ? true : false;
		String isOnGPSStr = String.valueOf(isOnGPService);

		E12CustomPlugin.enableGeoFencing( new E12CustomPlugin.CallBack() {

			@Override
			public void onSuccess( String result )
			{
				//Window.alert( "Enable the GPS tracking \n Result: ["+result+"]" );
				if( "true".equals(result) )
				{
					getGeoFenceRecord( connectionId, userId, updateSource );
				}
				else if( "false".equals(result) )
				{
					E12CommonUtils.printOnConsole("GeoTag not enabled");
				}
			}

			@Override
			public void onError( String error ) {
				E12CommonUtils.printOnConsole( "Exception while enabling gps tracking ["+error+"]" );
			}
		}, isOnGPSStr, connectionId, userId );
	}

	/**
	 * This method returns the list of Geo fence records in xml format
	 *
	 * @param connectionId - current connection id
	 * @param userId - current login user
	 */
	public void getGeoFenceRecord( final String connectionId, final String userId, final String updateSource )
	{
		E12CustomPlugin.getGeoFenceRecords( new E12CustomPlugin.CallBack() {

			@Override
			public void onSuccess( String result )
			{
				if( "false".equalsIgnoreCase( result ) )
				{
					E12CommonUtils.printOnConsole("No GeoFence Record found");
				}
				else
				{
					String gpsTrackResult = result;
					//Window.alert("GPS records: "+result);
					HashMap< String, String > paramMap = new HashMap< String, String >();
					paramMap.put( "ACTION", "STORE_GPSTRACKING_RECORDS" );
					paramMap.put( "RESULT", gpsTrackResult );
					paramMap.put( "DEVICEID", CommonPhoneGapUtil.getInstance().getDeviceUuid());
					paramMap.put( "UPDATE_SOURCE", updateSource);
					paramMap.put( "dummyInt", Math.random() + "");
					String paramString = E12CommonUtils.getInstance().getEncodedParamString( paramMap );

					String url = E12Global.getHostUrl()+ "/ibase/WEBITMRIARequestHandlerServlet?" + paramString ;

					//E12Global.getInstance().setLoadingInfo("Storing GPS Track Records...");
					if( ( ! CommonPhoneGapUtil.checkNetworkAndMode() ) && ( ! E12Global.getInstance().isOffline() ) )
					{
						Window.alert( E12Constants.constants.setNoNetWork() );
					}
					else
					{
						//E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.GET, url );
						RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET, url );
						try
						{
							requestBuilder.sendRequest( "", new RequestCallback() {

								@Override
								public void onResponseReceived(Request request, Response response)
								{
									String responseStr = response.getText();
									if( E12Global.getInstance().checkErrorException(response, 1) )
									{
										//Window.alert("result back on store records: "+responseStr);
										if( responseStr.contains( "Success" ) )
										{
											String removeId = responseStr.replace(",Success", "");
											removeGeoFenceRecord( removeId );
										}
										else{
											E12CommonUtils.printOnConsole("Fail to store records.");
										}
									}
								}

								@Override
								public void onError(Request request, Throwable exception)
								{
									E12CommonUtils.printOnConsole( "Error : " + exception.getMessage());
								}
							});
						}
						catch( RequestException ex )
						{
							Window.alert( "Error :getGeoFenceRecord :: " + ex.getMessage());
						}
					}
				}
			}

			@Override
			public void onError( String error )
			{
				E12CommonUtils.printOnConsole( "Exception while getting GeoFence Records ["+error+"]" );
			}
		}, connectionId, userId );
	}

	/**
	 * This method removes the
	 * @param removeId
	 */
	private void removeGeoFenceRecord( String removeId )
	{
		E12CustomPlugin.removeGeoFenceRecord( new E12CustomPlugin.CallBack() {

			@Override
			public void onSuccess( String result ) {

				//Window.alert( "Removing Id \n Result: ["+result+"]" );
			}

			@Override
			public void onError( String error ) {
				E12CommonUtils.printOnConsole( "Exception while removing GeoFence records:: ["+error+"]" );
			}
		}, removeId );
	}
	// Added by Reema on 11-Sep-15[for GeoFencing]-End

	//Added by Reema on 11-Sep-15 [Inject JS file when required]-Start
	public native void includeJSFile(String jsFilePath)
	/*-{
		$wnd.includeJavascriptFile(jsFilePath);
	}-*/;
	//Added by Reema on 11-Sep-15 [Inject JS file when required]-End

	public static native String callDefaultData( String currFormXml, String objContext, String action,String objName )
	/*-{
		try
		{
			return $wnd.callDefaultData(currFormXml, objContext, action, objName);
		}
		catch(e)
		{
			console.log('Exception while call to callDefaultData ['+e+']');
			return '';
		}

	}-*/;

	//Added by Gaurav Singh on 09-MAY-2016 [ For resolving work with issue of offline CHC | Start]
	public static native String callDefaultData( String currFormXml, String objContext, String action, String objName, String allXMLData )
	/*-{
		return $wnd.callDefaultData(currFormXml, objContext, action, objName, allXMLData);
	}-*/;
	//Added by Gaurav Singh on 09-MAY-2016 [ For resolving work with issue of offline CHC | End]

	public native void removeJSFile(String jsFilePath, String filetype)
	/*-{
		console.log('In E12commonutil rmeoveJSfile...');
		$wnd.removeJSCSSFile(jsFilePath, filetype);
	}-*/;

	/**
	 * This method is for to convert URL parameters to HashMap.
	 *
	 * @param urlParam => URL parameters
	 * @return HashMap<String, String> => <ParameterName, ParameterValue>
	 */
	public static HashMap<String, String> getUrlParamToMap (String urlParam)
	{
		String[] urlParams = urlParam.split("&");
		HashMap<String, String> mapParam = new HashMap<String, String>();
		try
		{
			for (String param : urlParams)
			{
				String paramName = param.split("=")[0];
				String paramValue = param.split("=")[1];
				mapParam.put(paramName, paramValue);
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in getUrlParamToMap: "+e.getMessage());
		}
		return mapParam;
	}

	/**
	 * This method is for to convert HashMap to URL parameters.
	 *
	 * @param paramMap => <ParameterName, ParameterValue>
	 * @return String => URL parameters
	 */
	public static String getMapToParam (HashMap<String, String> paramMap)
	{
		StringBuilder urlParams =  new StringBuilder();
		try
		{
			if (paramMap != null && paramMap.size() > 0 )
			{
				for (Map.Entry<String, String> entry : paramMap.entrySet())
				{
					urlParams.append(entry.getKey() + "=" + entry.getValue());
					urlParams.append("&");
				}

				urlParams.setLength(urlParams.length() - 1);
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in getMapToParam: "+e.getMessage());
		}

		return urlParams.toString();
	}

	//Added by Sandesh Shinde [App resume redirect and notification redirect] 16-Jun-16 Start
	/**
	 * This method is for redirecting to E12OptionsPanel.
	 * @param toRedirectPath
	 * @param data
	 */
	public void redirect(String toRedirectPath, String data)
	{
		//Added by sainath T. on 29-AUG-2019 [To process assistant push notification data and redirect] - Start
		if (toRedirectPath.startsWith("VAS."))
		{
			data= getNotificationData(toRedirectPath);
		}
		//Added by sainath T. on 29-AUG-2019 [To process assistant push notification data and redirect] - End
		String applicationName = checkNull(E12Global.getInstance().getCurrentApplicationName());
		applicationName = applicationName.equals("") ? E12Constants.constants.setE12OptionsLbl() : applicationName;
		E12OptionsPanel e12OptionsPanel = new E12OptionsPanel(applicationName, null);
		e12OptionsPanel.redirect(checkNull(toRedirectPath), data);
	}

	/**
	 * This method is for converting JSON string to HashMap
	 * @param jsonString
	 * @return HashMap &lt;String, String &gt;
	 */
	public static HashMap<String, String> jsonStringToMap(String jsonString)
	{
		HashMap<String, String> map = new HashMap<String, String>();

		try
		{
			JSONValue parsedJson = JSONParser.parseStrict(jsonString);
			JSONObject jsonObject = parsedJson.isObject();
			if (jsonObject != null)
			{
				for (String key : jsonObject.keySet())
				{
					if (jsonObject.get(key).isObject() != null)
					{
						map.putAll(jsonStringToMap(jsonObject.get(key).isObject().toString()));
					}
					else if (jsonObject.get(key).isString() != null)
					{
						map.put(key, jsonObject.get(key).isString().stringValue());
					}
				}
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in jsonStringToMap: "+e.getMessage());
		}
		return map;
	}

	/**
	 * This method is for converting Simple XML to HashMap.
	 *
	 * @param xmlString
	 * @return HashMap &lt;String, String &gt;
	 * <BR>
	 * <B> This method will not support for Array Elements in XML.</B>
	 */
	public static HashMap<String, String> xmlStringToMap(String xmlString)
	{
		HashMap<String, String> map = new HashMap<String, String>();
		try
		{
			Document doc = XMLParser.parse(xmlString);
			XMLParser.removeWhitespace(doc);
			NodeList nodeList = doc.getChildNodes();
			for (int i = 0; i < nodeList.getLength(); i++ )
			{
				Node nodeItem = nodeList.item(i);

				if (nodeItem.hasChildNodes())
				{
					NodeList nodeItemChildList = nodeItem.getChildNodes();

					for (int j = 0; j < nodeItemChildList.getLength(); j++ )
					{
						Node nextNodeItem = nodeItemChildList.item(j);

						if (nextNodeItem.hasChildNodes())
						{
							NodeList nextNodeItemChildList = nextNodeItem.getChildNodes();
							for (int k = 0; k < nextNodeItemChildList.getLength(); k++ )
							{
								Node nextChildItem = nextNodeItemChildList.item(k);
								map.put(nextNodeItem.getNodeName(), nextChildItem.getNodeValue());
							}
						}
					}
				}
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in xmlStringToMap: "+e.getMessage());
		}
		return map;
	}
	//Added by Sandesh Shinde [App resume redirect and notification redirect] 16-Jun-16 End

	//Added by Pankaj T on 24-08-16 [Start] [S16EBAS016]
	/**
	 * Set latlong value of map
	 * @param latLong
	 */
	public static void setLatlong(String latLong)
	{
		E12Global.getInstance().setLatLong(""+latLong);
		E12CommonUtils.printOnConsole("LatLong value after set:::"+E12Global.getInstance().getLatLong());
	}

	/**
	 * Set html data return form js
	 * @param htmlData
	 */
	public static void setHtmlData( String htmlData )
	{
		E12CommonUtils.printOnConsole("Htmldata in E12CommonUtils::"+htmlData);
		E12Global.getInstance().setHtmlData(""+htmlData);
	}

	/**
	 * Set toggle value after change
	 * @param fldValue
	 * @param title
	 */
	public static void setToggleValue(String fldValue, String title)
	{
		E12CommonUtils.printOnConsole("Fldvalue::"+fldValue);
		E12Global.getInstance().setToggleValue(""+fldValue);
		//E12ParentEditor.customMap.put(title, fldValue);
		setToggle(title, fldValue);
	}

	/**
	 *
	 * @param title
	 * @param fldValue
	 */
	public static native void setToggle(String title, String fldValue) /*-{

		$wnd.setFldData(title, fldValue);

	}-*/;
	//Added by Pankaj T on 24-08-16 [End] [S16EBAS016]

	//Added By Ajinkya Gopalkar on 10-Oct-16[For handling exception if no js function found] Start
	public static native String callValData( String objContext, String action, String objName, String currentFormData, String objFormName )
	/*-{
		try
		{
			//Changed BY Suraj on 06-April
			//return $wnd.valData( objContext, action, objName, currentFormData, objFormName);
			return $wnd.localValData( objContext, action, objName, currentFormData, objFormName);
	    }
	    catch(e)
	    {
	    	console.log('valData method is not found.....!!');
	    	return 'true';
	    }
	}-*/;
	//Added By Ajinkya Gopalkar on 10-Oct-16[For handling exception if no js function found] End

	//Added By Suraj on 26-10-2016 [To call Wizard in Calendar]Start
	WallToWallPanel wallToWallObj = null;
	WallToWallPanel wallToWallObjNew = null;

	/**
	 * @return the wallToWallObj
	 */
	public WallToWallPanel getWallToWallObj()
	{
		return wallToWallObj;
	}

	/**
	 * @param wallToWallObj the wallToWallObj to set
	 */
	public void setWallToWallObj(WallToWallPanel wallToWallObj)
	{
		this.wallToWallObj = wallToWallObj;
	}

	/**
	 * @return the wallToWallObj
	 */
	public WallToWallPanel getWallToWallObjNew()
	{
		return wallToWallObjNew;
	}

	/**
	 * @param wallToWallObj the wallToWallObj to set
	 */
	public void setWallToWallObjNew(WallToWallPanel wallToWallObjNew)
	{
		this.wallToWallObjNew = wallToWallObjNew;
	}

	//Added By Suraj on 26-10-2016 [To call Wizard in Calendar]End

	//Added By Ajinkya Gopalkar on 6-Jan-16[For checking gps after defined interval]
	public void checkGPSStatus()
	{
		boolean isPluginSupported =  ( E12Global.getInstance().getDeviceOS() == DeviceOS.Android || E12Global.getInstance().getDeviceOS() == DeviceOS.iOS );
		if( isPluginSupported )
		{
			E12CustomPlugin.getGPSStatus(new CallBack() {

				@Override
				public void onSuccess(String gpsStatus)
				{
					if( "false".equalsIgnoreCase(gpsStatus) )
					{
						E12Global.getInstance().setLoading( false );
						//Changed by Sandeep S. on 15-05-17 [To implement indexed db in browser] Start
						//E12Storage.getItem("GPS_ENFORCED", new Callback<String, String>() {
						E12Storage.getItem("GEO_POS_OPTION", new Callback<String, String>() {
							@Override
							public void onSuccess(String result) {
								if( "2".equalsIgnoreCase( result ) || "3".equalsIgnoreCase( result ) )
								{
									E12Constants.GEOPOS_STATUS = false;
								}
								else if( "1".equalsIgnoreCase( result ) )
								{
									if( E12Constants.GEOPOS_STATUS || Window.confirm("Device GPS is OFF - This app requires GPS location. \nDo you want to continue without GPS ?") )
									{
										E12Constants.GEOPOS_STATUS = true;
									}
								}
								else
								{
									Window.alert("Application Error : GPS Configuration");
								}
							}

							@Override
							public void onFailure(String reason) {
								Window.alert( "Exception getting item value from websql when click on delete button. ["+reason+"]" );

							}

						});
						//Changed by Sandeep S. on 15-05-17 [To implement indexed db in browser] End
					}
					else
					{
						E12Constants.GEOPOS_STATUS = true;
					}
				}

				@Override
				public void onError(String error)
				{
					E12Global.getInstance().setLoading( false );
				}
			});
		}
	}

	/*public void checkGPS()
	{
		Scheduler.get().scheduleFixedPeriod(new Scheduler.RepeatingCommand()
		{
			@Override
			public boolean execute()
			{
				if( "true".equalsIgnoreCase( E12Storage.getItem("GPS_ENABLED") ))
				{
					E12CommonUtils.printOnConsole("In E12CommonUtils checkGPS scheduleFixedPeriod........!!!");
					E12CommonUtils.getInstance().checkGPSStatus();
				}
				return true;
			}

		}, 2000);
	}*/
	//Added By Ajinkya Gopalkar on 6-Jan-16[For checking gps after defined interval]

	// Added by Bhupendra on 13-Jan-17 for [ Summary Page implementation in Mobile Editor ] Starts
	public void setPkFieldNames(StringBuffer pkFieldNames)
	{
		this.pkFieldNames = pkFieldNames;
	}

	public StringBuffer getPkFieldNames()
	{
		return pkFieldNames;
	}
	//Added by Ashutosh-[Start-To get map data from js]
	public static native JSONObject getMapObject()
	/*-{
		var rowdataMap = $wnd.dataMap;
		if(!rowdataMap)
		{
			return null;
		}
		return @com.google.gwt.json.client.JSONObject::new(Lcom/google/gwt/core/client/JavaScriptObject;)(rowdataMap);
	}-*/;
	public static native JSONObject clearMapObject()
	/*-{
		$wnd.dataMap = {};
		var rowdataMap = $wnd.dataMap;
		if(!rowdataMap)
		{
			return null;
		}
		return @com.google.gwt.json.client.JSONObject::new(Lcom/google/gwt/core/client/JavaScriptObject;)(rowdataMap);
	}-*/;
	// Added by Ashutosh on 13-Jan-17 for [ Summary Page implementation in Mobile Editor ] Ends
	public static native String callItemchangeData( String objContext, String action, String objName, String currentFormData, String fieldName, int domId, String objFormName, String fieldValue , String parentFormNo , String parentFormDomId , String buttonId,String prevValue , String itemCode,String allFormDetaildata)
	/*-{
		try
		{
			console.log('calling itemchangeData method !!');
			//Suraj Changed on 06-April
			//return $wnd.itemchangeData( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue );
			return $wnd.localItemChange( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue , parentFormNo , parentFormDomId , buttonId, prevValue, itemCode, allFormDetaildata);//shrutika
		}
		catch(e)
		{
			 console.log('3525 itemchangeData method is not found.....!!');
			 return '';
		}
	 }-*/;
	//Added by Ashutosh-[End-To get map data from js]
	//Added by Sagar B. to pass data model json in local JS[29-Dec-18]START
	public static native String callItemchangeData( String objContext, String action, String objName, String currentFormData, String fieldName, int domId, String objFormName, String fieldValue , String parentFormNo , String parentFormDomId , String buttonId,String prevValue , String itemCode,String allFormDetaildata, String dataModelJson )
	/*-{
		try
		{
			console.log('calling itemchangeData method !!');
			//Suraj Changed on 06-April
			//return $wnd.itemchangeData( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue );
			return $wnd.localItemChange( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue , parentFormNo , parentFormDomId , buttonId, prevValue, itemCode, allFormDetaildata, dataModelJson);//shrutika
		}
		catch(e)
		{
			 console.log('3863 itemchangeData method is not found.....!!');
			 return '';
		}
	 }-*/;
	//Added by Sagar B. to pass data model json in local JS[29-Dec-18]END
	public static native String callItemchangeData( String objContext, String action, String objName, String currentFormData, String fieldName, int domId, String objFormName, String fieldValue , String parentFormNo , String parentFormDomId , String buttonId)
	/*-{
		try
		{
			console.log('calling itemchangeData method !!');
			//Suraj Changed on 06-April
			//return $wnd.itemchangeData( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue );
			return $wnd.localItemChange( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue , parentFormNo , parentFormDomId , buttonId);//shrutika
	    }
	    catch(e)
	    {
	    	console.log('itemchangeData method is not found.....!!');
	    	return '';
	    }
	}-*/;
	//Added by Bhupendra M on 13-03-17 for client side js to be called provision to give to call the item change and validation Ends

	public static native String callPostItemchangeData( String objContext, String action, String objName, String currentFormData, String fieldName, String domId, String objFormName, String fieldValue , String parentFormNo , String parentFormDomId, String nextBtnID, String prevBtnID, String finishBtnID, String addBtnID )
	/*-{
		try
		{
			console.log('calling Testing itemchangeData method !!');
			//Added by Bhupendra M on 13-03-17 for client side js to be called provision to give to call the item change and validation Starts
			//return $wnd.itemchangeData( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue );
			return $wnd.localPostItemChange( objContext, action, objName, currentFormData, fieldName, domId, objFormName, fieldValue , parentFormNo , parentFormDomId ,nextBtnID, prevBtnID, finishBtnID, addBtnID);
	    }
	    catch(e)
	    {
	    	console.log('itemchangeData method is not found.....!!');
	    	return '';
	    }
	}-*/;

	public String getXMLFromMap( HashMap<String, String> formDataMap, String formNo )
	{
		StringBuilder buildReqParamXML = new StringBuilder("");
		StringBuilder xmlStrgToServ = new StringBuilder("");
		String currDomID = checkNull(formDataMap.get("domID"));
		xmlStrgToServ.append("<Detail" + formNo + " domID=\"" + currDomID +"\" >");
		Iterator<String> formDataFieldItr = formDataMap.keySet().iterator();

		while(formDataFieldItr.hasNext())
		{
			String key = formDataFieldItr.next();
			String formFieldValue = formDataMap.get(key);
			String formFieldName = key;
			if( "ATTRIBUTE_NODE".equalsIgnoreCase(formFieldName) )
			{
				//						xmlStrgToServ.append( formFieldValue );
				//						E12CommonUtils.printOnConsole("In getWizardXMLFromMap attribute condition formFieldValue["+formFieldValue+"] formFieldName["+formFieldName+"]");
			}
			else if( "ORIG_ATTRIBUTE_NODE".equalsIgnoreCase(formFieldName) )
			{
				//						xmlStrgToServ.append( formFieldValue );
				//						E12CommonUtils.printOnConsole("In getWizardXMLFromMap attribute condition formFieldValue["+formFieldValue+"] formFieldName["+formFieldName+"]");
			}
			else
			{
				if( formFieldName.indexOf("~") < 0 )
				{
					xmlStrgToServ.append("<"+formFieldName + buildAttribParamsFromMap(formFieldName, formDataMap) +">");
					xmlStrgToServ.append("<![CDATA[");
					xmlStrgToServ.append( formFieldValue );
					xmlStrgToServ.append("]]>");
					xmlStrgToServ.append("</"+formFieldName+">");
				}
			}
		}
		xmlStrgToServ.append("</Detail" + formNo + ">");
		buildReqParamXML.append(xmlStrgToServ.toString());
		return buildReqParamXML.toString();
	}

	private String buildAttribParamsFromMap(String fldName, HashMap<String, String> formDataMap)
	{
		String attributeParam = "";
		String protectAttribParams = E12Global.checkNull( formDataMap.get(fldName + "~protect~") );
		if( !"".equalsIgnoreCase(protectAttribParams) )
		{
			protectAttribParams = " protect = '"+ protectAttribParams +"' ";
		}

		String visibleAttribParams = E12Global.checkNull( formDataMap.get(fldName + "~visible~") );
		if( !"".equalsIgnoreCase(visibleAttribParams) )
		{
			visibleAttribParams = " visible = '"+ visibleAttribParams +"' ";
		}
		attributeParam = E12Global.checkNull(protectAttribParams + " " + visibleAttribParams);
		return attributeParam ;
	}

	public void checkGPSFirst()
	{
		boolean isPluginSupported =  ( E12Global.getInstance().getDeviceOS() == DeviceOS.Android || E12Global.getInstance().getDeviceOS() == DeviceOS.iOS );
		if( isPluginSupported )
		{
			E12CustomPlugin.getGPSStatus(new CallBack() {

				@Override
				public void onSuccess(String gpsStatus)
				{
					if( "false".equalsIgnoreCase(gpsStatus) )
					{
						E12Constants.GEOPOS_STATUS = false;
					}
					else
					{
						E12Constants.GEOPOS_STATUS = true;
					}
				}
				@Override
				public void onError(String error)
				{
					E12Global.getInstance().setLoading( false );
				}
			});
		}
	}
	//Changed By Suraj on 15-03-2017 [To implement slideMenuPanel ]Start
	ArrayList<E12Feed> feedTitlesList = null;


	public ArrayList<E12Feed> getFeedTitlesList() {
		return feedTitlesList;
	}

	public void setFeedTitlesList(ArrayList<E12Feed> feedTitlesList) {
		this.feedTitlesList = feedTitlesList;
	}

	private PopupPanel slidePopupPnl = null;
	//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
	private HashMap<String, PopupPanel> slideMenuPopupPnl = new HashMap<String, PopupPanel>();

	/**
	 * @return the slidePopupPnl
	 */
	public PopupPanel getSlidePopupPnl( String key ) {
		//return slidePopupPnl;
		return this.slideMenuPopupPnl.get(key);
	}

	/**
	 * @param slidePopupPnl the slidePopupPnl to set
	 */
	public void setSlidePopupPnl(String key, PopupPanel slidePopupPnl) {
		//this.slidePopupPnl = slidePopupPnl;
		this.slideMenuPopupPnl.put(key, slidePopupPnl);
	}
	//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end

	JavaScriptObject e12SlideMenuHeadRoomObj = null;

	/**
	 * @return the e12SlideMenuHeadRoomObj
	 */
	public JavaScriptObject getE12SlideMenuHeadRoomObj() {
		return e12SlideMenuHeadRoomObj;
	}

	/**
	 * @param e12SlideMenuHeadRoomObj the e12SlideMenuHeadRoomObj to set
	 */
	public void setE12SlideMenuHeadRoomObj(JavaScriptObject e12SlideMenuHeadRoomObj) {
		this.e12SlideMenuHeadRoomObj = e12SlideMenuHeadRoomObj;
	}

	/**
	 * Apply head room effect.
	 */
	public native JavaScriptObject applyHeadRoomEffect(String scrollerId, String subHeaderId, int tolerance, int offset)/*-{
		try {
			var scrollerElement = $doc.getElementById(scrollerId);
			var options = {
				scroller: scrollerElement,
				tolerance: tolerance,
            	offset : offset,
            	classes: {
            		initial: "animated",
                	pinned: "slideDown",
                	unpinned: "slideUpMenu"
           		}
        	};

			var header = new $wnd.Headroom($doc.getElementById(subHeaderId), options);
        	header.init();
        	return header;
		} catch (ex) {
			 console.log('Exception In applyHeadRoomEffect : ' + ex);
		}
	}-*/;

	/**
	 * Called headroom object destroy() method for removing headroom effect.
	 *
	 * @param headRoomObj Headroom object.
	 */
	public native void removeHeadroomEffect(Object headRoomObj) /*-{
		try {
			if (headRoomObj != null)
				headRoomObj.destroy();
		} catch (ex) {
//			window.alert('Exception when removing headroom effect : ' + ex);
		}
	}-*/;


	/**
	 * Apply head room effect.
	 */
	public native JavaScriptObject applyHeadRoomEffectFooterMenu(String scrollerId, String subHeaderId, int tolerance, int offset)/*-{
		try {
			var scrollerElement = $doc.getElementById(scrollerId);
			var options = {
				scroller: scrollerElement,
				tolerance: tolerance,
            	offset : offset,
            	classes: {
            		initial: "animated",
                	pinned: "slideDown",
                	unpinned: "slideUp"
           		}
        	};

			var header = new $wnd.Headroom($doc.getElementById(subHeaderId), options);
        	header.init();
        	return header;
		} catch (ex) {
			 console.log('Exception In applyHeadRoomEffect : ' + ex);
		}
	}-*/;
	//Changed By Suraj on 15-03-2017 [To implement slideMenuPanel ]End
	//Added by Bhupendra M on 13-03-17 for client side js to be called provision to give to call the item change and validation Starts
	public static native String callAutoNumberChangeData( String editorObjName,	int currentFormNo, String offlineRefVal, HashMap<String, String> freeFormDataMap , String fldName , String fldValue , String maxDomValue , Boolean isDoneSucess)
	/*-{
		try
		{
			console.log('calling callAutoNumberChangeData method !!');
			return $wnd.localAutoNumberChange( editorObjName, currentFormNo, offlineRefVal, freeFormDataMap , fldName , fldValue , maxDomValue , isDoneSucess);
	    }
	    catch(e)
	    {
	    	console.log('itemchangeData method is not found.....!!');
	    	return '';
	    }
	 }-*/;
	//Added by Bhupendra M on 13-03-17 for client side js to be called provision to give to call the item change and validation Ends

	public void transSavedToSuccess(String tranId, String summaryObjName, E12TransEditor e12TransEditor, Object object, String string, Object object1)
	{
		// TODO Auto-generated method stub
	}

	public void getAllFormSummaryXsl(String tTranId, String tObjName, Object object, Object object2, String allDataXmlStrg, String xslStr)
	{
		// TODO Auto-generated method stub
	}

	//Changed by Sandeep S. on 17-05-17 Start
	private PopupPanel loadingPnl = null;
	public PopupPanel getLoadingPnl() {
		return loadingPnl;
	}
	public void setLoading( boolean flag )
	{

	}
	public void setLoadingInfo( String loadingInfoStr )
	{

	}
	//Changed by Sandeep S. on 17-05-17 End

	//Added By Ajinkya Gopalkar on 22-Jun-17[For disable feed implementation through js] - Start
	public String getDetailXML( HashMap<String, String> formDataMap, String formNo )
	{
		StringBuilder buildReqParamXML = new StringBuilder("");
		StringBuilder xmlStrgToServ = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>");
		String currDomID = checkNull(formDataMap.get("domID"));
		xmlStrgToServ.append("<Root><Detail" + formNo + " domID=\"" + currDomID +"\" >");
		Iterator<String> formDataFieldItr = formDataMap.keySet().iterator();

		while(formDataFieldItr.hasNext())
		{
			String key = formDataFieldItr.next();
			String formFieldValue = formDataMap.get(key);
			String formFieldName = key;
			if( "ATTRIBUTE_NODE".equalsIgnoreCase(formFieldName) )
			{
				xmlStrgToServ.append( formFieldValue );
			}
			else if( "ORIG_ATTRIBUTE_NODE".equalsIgnoreCase(formFieldName) )
			{
				xmlStrgToServ.append( formFieldValue );
			}
			else
			{
				if( formFieldName.indexOf("~") < 0 )
				{
					xmlStrgToServ.append("<"+formFieldName + buildAttribParamsFromMap(formFieldName, formDataMap) +">");
					xmlStrgToServ.append("<![CDATA[");
					xmlStrgToServ.append( formFieldValue );
					xmlStrgToServ.append("]]>");
					xmlStrgToServ.append("</"+formFieldName+">");
				}
			}
		}
		xmlStrgToServ.append("</Detail" + formNo + "></Root>");
		buildReqParamXML.append(xmlStrgToServ.toString());
		E12CommonUtils.printOnConsole("getWizardXMLFromMap output reqParamStr["+buildReqParamXML+"]");
		return buildReqParamXML.toString();
	}

	public static native String disableFeeds( String mainFeedXml, String domID, int formNo, String editorObjName)
	/*-{
		try
		{
			return $wnd.disableFeeds(mainFeedXml, domID, formNo, editorObjName);
		}
	    catch(e)
	    {
	    	console.log('disableFeeds function is not defined in '+ editorObjName +'.js');
	    	return '';
	    }
	}-*/;
	//	Added By Ajinkya Gopalkar on 22-Jun-17[For disable feed implementation through js] - Start
	//Added by Bhupendra M for Creating Dynamic width according to input Data Starts
	public Integer getDynamicWidth( String inputValue )
	{
		int dynamicWidth = 0;
		if( checkNull( inputValue ).trim().length() > 0 )
		{
			dynamicWidth = (int) (checkNull( inputValue ).trim().length() * 7.5);
			return  dynamicWidth;
		}
		return dynamicWidth;
	}
	//Added by Bhupendra M for Creating Dynamic width according to input Data Ends

	AbsolutePanel parentAbsPnl = null;

	public AbsolutePanel getParentAbsPnl() {
		return parentAbsPnl;
	}

	public void setParentAbsPnl(AbsolutePanel parentAbsPnl) {
		this.parentAbsPnl = parentAbsPnl;
	}

	public VerticalPanel getSidePnlPopupContainer() {
		return sidePnlPopupContainer;
	}

	public void setSidePnlPopupContainer(VerticalPanel sidePnlPopupContainer) {
		this.sidePnlPopupContainer = sidePnlPopupContainer;
	}

	public E12SidePanelContainers getE12SidePanelContainers() {
		return e12SidePanelContainers;
	}

	public void setE12SidePanelContainers( E12SidePanelContainers e12SidePanelContainers ) {
		this.e12SidePanelContainers = e12SidePanelContainers;
	}

	//Added by shrutika on 28-11-17 for implement copy functionality [start].
	public static String ENCODING = "UTF-8";
	public String generateTabSeparatedData( String xmlData, String objContext, String domID )
	{
		return "";
	}

	private Node searchNode(Document dom, String objContext, String nodeID)
	{
		return null;
	}

	public String getXmlTag( String xmlData, String objContext, String domID )
	{
		return "";
	}


	public String generateTabSeparatedDataforAdd( String xmlData, String objContext, String domID )
	{
		return "";
	}

	public String getXmlTagforAdd( String xmlData, String objContext, String domID )
	{
		return "";
	}

	private Node searchNodforAdd(Document dom, String objContext, String nodeID)
	{
		return null;
	}

	//Add primaryKeylist parameter shrutika on 02-11-12 for set blank line number if line number is present in pkfield.
	public String TabSeparatedDataForAllFormData( String xmlData, String objContext, String[] arrayTabOrder, ArrayList PrimaryKeyFieldLst, ArrayList headerKeylist, String keyFlag )
	{
		return "";
	}
	//Added by shrutika on 28-11-17 for implement copy functionality.[End]

	// Added by Pankaj R on 10-Jan-18 to get Battery status of device[START]
	public native String getBatteryStatus()
	/*-{
		try
		{
			var self = this;
			var global = @ibase.e12ria.client.E12Global::getInstance()();
			function onBatteryStatus(info)
			{
				global.@ibase.e12ria.client.E12Global::setBatteryStatus(Ljava/lang/String;)(""+info.level);
				global.@ibase.e12ria.client.E12Global::setPlugged(Ljava/lang/String;)(""+info.isPlugged);
			}
			$wnd.addEventListener("batterystatus", onBatteryStatus, false);
		}
		catch(e)
		{
			console.log(e);
		}

	}-*/;
	// Added by Pankaj R on 10-Jan-18 to get Battery status of device[START]
	public native void closePopUps(String id)
	/*-{
			try
			{
				var openedWidget = $doc.getElementById(id);
				var ce = $doc.createEvent('Event');
				ce.initEvent('click');
				console.log("closePopUps :::: ");
				console.log(openedWidget);
				if(openedWidget)
				{
					openedWidget.dispatchEvent(ce);
				}
			}
			catch(e)
			{
				console.log("Exception in closePopUps : "+e);
			}
	}-*/;
	//Added by vishal pathare on 8/02/2018 for[links implementation in dashBoard mobile]Start.
	public void setE12TranActionLinks(E12TranActionLinks e12TranActionLinks) {
		// TODO Auto-generated method stub

	}

	public String getEncodedURLString( String strKey , String strValue , String encodedUrlString )
	{

		if(strValue == null)
		{
			strValue = "";
		}
		encodedUrlString += URL.encodeComponent(strKey) + "=" + URL.encodeComponent(strValue) + "&";
		return encodedUrlString ;
	}

	public String getURL(String url)
	{
		String currentGeoPosParams = "&CURRENT_GEO_POS="+ E12CommonUtils.checkNull( E12Constants.currentGeoPos );
		url = url + currentGeoPosParams;
		return url;
	}

	E12PopupContainer popUpContainer = null;
	public E12PopupContainer getPopUpContainer()
	{
		E12CommonUtils.printOnConsole("****** getting popUpContainer object ");
		return popUpContainer;
	}

	public void setPopUpContainer(E12PopupContainer popUpContainer)
	{
		E12CommonUtils.printOnConsole("****** Setting popUpContainer object ");
		this.popUpContainer = popUpContainer;
	}
	//Added by vishal pathare on 8/02/2018 for[links implementation in dashBoard mobile]End.

	public static native String getDetailData( String objContext, String objName, String formDetailData, String objFormName, String parentFormNo, String parentFormDomId )
	/*-{
		try
		{
			console.log('calling getDetailData method!!');
			return $wnd.getDetailData( objContext, objName, formDetailData, objFormName, parentFormNo, parentFormDomId );
		}
		catch(e)
		{
			 console.log('3923 getDetailData method is not found.....!!');
			 return formDetailData;
		}
	 }-*/;

	public static native String setContentUsageData( String objContext, String objName, String contentUsageData, String objFormName )
	/*-{
		try
		{
			console.log('calling setUsageData method!!');
			return $wnd.setUsageData( objContext, objName, contentUsageData, objFormName );
		}
		catch(e)
		{
			 console.log('3923 setUsageData method is not found.....!!');
			 return formDetailData;
		}
	 }-*/;

	//Added by Prasad on 20/02/18 [to set userInfo data in js variable] START
	public native static void setUserInfo( JSONObject userInfoJson )
	/*-{
		$wnd.setUserInfo( userInfoJson );
	}-*/;
	//Added by Prasad on 20/02/18 [to set userInfo data in js variable] END

	// Added by Abhishek T on 20-March-18 [For sending otp request] START
	public void sendOTP(String mobileNumber, int otpLength, Callback<String, String> callback) {
		String hostUrl = E12Global.getHostUrl();
		String url = hostUrl + "/ibase/AuthenticateServlet";

		HashMap<String, String> parameters = new HashMap<String, String>();
		parameters.put("action", "SEND_OTP");
		parameters.put("MN", mobileNumber);
		parameters.put("OTPLN", "" + otpLength);
		// Added by Pravin K on 19-Feb-19 [Passing application hash code in request] START
		if (E12Constants.APPLICATION_HASH_CODE != null) {
			parameters.put("APP_HASH", E12Constants.APPLICATION_HASH_CODE);
		}
		// Added by Pravin K on 19-Feb-19 [Passing application hash code in request] END

		E12PluginUtils.getInstance().sendRequestToServer(url, parameters, callback);
	}
	// Added by Abhishek T on 20-March-18 [For sending otp request] END
	//Added by Bhupendra M on 20-03-18 to check whether to validate from pophelp according to VALIDATE_DATA Start
	public String createErrorFieldMessageString( E12PophelpInfo pophelpInfo , Boolean isMessageforToolTip )
	{
		String finalMsgString = "";
		E12CommonUtils.printOnConsole("Inside createErrorFieldMessageString ["+E12UserInfo.getCallerInterface()+"]");
		try
		{
			if( pophelpInfo != null )
			{
				String msgNo = pophelpInfo.getMsgNo();
				String msgType = pophelpInfo.getMsgType();
				String msgStrg = pophelpInfo.getMsgString();
				String msgDescr = pophelpInfo.getMsgDesc();
				finalMsgString += "<html>";
				E12CommonUtils.printOnConsole("Inside createErrorMessageString msgNo ["+msgNo+"] msgType ["+msgType+"] msgStrg ["+msgStrg+"] msgDescr ["+msgDescr+"]");
				finalMsgString += "<span id='errorMsgid'>"+msgStrg+"</span>";
				if( isMessageforToolTip )
				{
					finalMsgString += "<br><span id='errorDescid'>"+msgDescr+"</span>";
					finalMsgString += "<br><span id='errorTraceid'>"+msgStrg+"</span>";
				}
				else
				{
					finalMsgString += "<br><span id='errorDescid'>"+msgDescr+"</span>";
					finalMsgString += "<br><span id='errorTraceid'>"+msgStrg+"</span>";
				}
				finalMsgString += "</html>";
				E12CommonUtils.printOnConsole("Inside Final createErrorFieldMessageString msgStr ["+finalMsgString+"]");
				return finalMsgString;

			}
		}
		catch( Exception e )
		{
			E12CommonUtils.printOnConsole("Exception getFilterExpresionResult ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return "";
	}
	public String createErrorMessageString( ArrayList<String> isFieldHasErrorArryLst )
	{
		String errorMessageString = "<div style='margin-left: 80px; text-align: left;'>";
		errorMessageString += "Below fields contains Errors";
		if( isFieldHasErrorArryLst != null && isFieldHasErrorArryLst.size() > 0 )
		{
			int isFieldHasErrorLength = isFieldHasErrorArryLst.size();
			for( int i = 0 ; i < isFieldHasErrorLength ; i++ )
			{
				String columnName = isFieldHasErrorArryLst.get(i);
				if( columnName.contains(":"))
				{
					columnName = columnName.replace(":", "");
				}
				errorMessageString += "<br><span>"+columnName+"</span>";
			}
			errorMessageString += "</div>";
			return errorMessageString;
		}
		return errorMessageString;
	}
	//Added by Bhupendra M on 20-03-18 to check whether to validate from pophelp according to VALIDATE_DATA End

	//Added by Pankaj T. on 13-04-18 for display summary in side panel of define field in property_info column of obj_forms table - Start
	public ArrayList<HashMap<String, String>> getPropertyInfoArrList( String propertyInfo, int formNo )
	{
		StringBuffer propertyInfoXML = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>");
		propertyInfoXML.append("<Root>").append(propertyInfo).append("</Root>");
		Document document = XMLParser.parse(propertyInfo);
		ArrayList<HashMap<String, String>> attributeMapList = new ArrayList<>();
		NodeList detailNodeList = document.getElementsByTagName("Total");
		E12CommonUtils.printOnConsole("detailNodeList length::["+detailNodeList.getLength()+"]");
		for( int pos = 0; pos < detailNodeList.getLength(); pos++ )
		{
			Node detailNode = detailNodeList.item(pos);
			if ( detailNode.hasAttributes() )
			{
				NamedNodeMap nodeMap = detailNode.getAttributes();
				HashMap<String, String> attributeMap = new HashMap<>();
				for ( int i = 0; i < nodeMap.getLength(); i++ )
				{
					Node tempNode = nodeMap.item(i);
					attributeMap.put(tempNode.getNodeName(), tempNode.getNodeValue());
				}
				attributeMapList.add(attributeMap);
			}
		}
		E12CommonUtils.printOnConsole("attributeMapList::["+attributeMapList+"]");
		return attributeMapList;
	}
	//Added by Pankaj T. on 13-04-18 for display summary in side panel of define field in property_info column of obj_forms table - End
	//Added by shrutika on 27-04-18 [Start] for append detail into another XML.
	public static String appendDetail(String allFormDataStr, String currentResopnseStr, String detail)
	{
		Document dom = XMLParser.parse(allFormDataStr);
		Document doc  = XMLParser.parse(currentResopnseStr);
		Node appendDetail = doc.getElementsByTagName(detail).item(0);
		String domIdforappend = "";
		if(appendDetail != null)
		{
			domIdforappend = appendDetail.getAttributes().getNamedItem("domID").getNodeValue();
		}
		Node rootNode = dom.getElementsByTagName("Root").item(0);
		Node documentRootNode = dom.getElementsByTagName("DocumentRoot").item(0);
		String finalString = "";
		boolean isPresentDomId = false;
		if(rootNode !=null)
		{
			NodeList detailNodeList = rootNode.getChildNodes();
			for ( int i = 0; i < detailNodeList.getLength(); i++)
			{
				Node curDetail = detailNodeList.item(i);
				if(detail.equalsIgnoreCase(curDetail.getNodeName()))
				{
					String DomIdforallData = curDetail.getAttributes().getNamedItem("domID").getNodeValue();
					if(DomIdforallData.equalsIgnoreCase(domIdforappend))
					{
						isPresentDomId = true;
						break;
					}
				}
			}
			if(!isPresentDomId)
			{
				rootNode.appendChild(dom.importNode(appendDetail, true));
			}
			finalString = rootNode.toString();
		}
		else if(documentRootNode != null)
		{
			Node headerNode = dom.getElementsByTagName("Header0").item(0);
			if( headerNode != null )
			{
				NodeList detailNodeList = headerNode.getChildNodes();
				for ( int i = 0; i < detailNodeList.getLength(); i++)
				{
					Node curDetail = detailNodeList.item(i);
					if(detail.equalsIgnoreCase(curDetail.getNodeName()))
					{
						String DomIdforallData = curDetail.getAttributes().getNamedItem("domID").getNodeValue();
						if(DomIdforallData.equalsIgnoreCase(domIdforappend))
						{
							isPresentDomId = true;
							break;
						}
					}
				}
				printOnConsole("In appendDetail isPresentDomId:["+isPresentDomId+"]");
				if(!isPresentDomId)
				{
					headerNode.appendChild(dom.importNode(appendDetail, true));
				}
			}
			finalString = documentRootNode.toString();
		}
		return finalString;
	}
	//Added by shrutika on 27-04-18 [End] for append detail into another XML.

	//Added by Shrutika on 28-11-17 [start] for implement copy functionality on control +v event.
	public native void setClipBoardContentsCopy( String copyData )
	/*-{
		try
		{
			console.log("inside set clipboard content copy");
			$wnd.OnKeyEventCopyData( copyData );
		}
		catch(e)
		{
			console.log("Error msg:...20517"+e);
		}
	}-*/;
	//Added by Shrutika on 28-11-17 [End] for implement copy functionality on control +v event.

	public native void addAnchorTag( String responseToCache )
	/*-{
		try
		{
			console.log('calling js for creating anchor method !!');
			$wnd.addAnchorTag( responseToCache );
		}
	    catch(e)
		{
		   	console.log('Exception in add anchor tag.....!!'+e);
		}
	}-*/;

	public native String displayValue( String responseToCache )
	/*-{
		try
		{
			console.log('calling js for creating dispalayValue method !!');
			return $wnd.displayValue( responseToCache );
	   }
	   catch(e)
	   {
	   		console.log('Exception in add anchor tag.....!!'+e);
	   }
	}-*/;

	//Added by Pankaj T on 23-11-17 [ for Display Status information in single field & on click expand it ] - Start
	/**
	 * Call javascript function & its return html data for display status details.
	 * @param jsonData of form
	 * @param formNo
	 * @param fieldId
	 * @param objName
	 * @return
	 */
	public native String displayStatusDetails(JavaScriptObject jsonData, int formNo, String fieldId, String objName)
	/*-{
	 	try
		{
			console.log('In displayStatusDetails JSNI method.');
			return $wnd.displayStatusDetails(jsonData, formNo, fieldId, objName);
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;
	//Added by Pankaj T on 23-11-17 [ for Display Status information in single field & on click expand it ] - End

	//Added by sunny soni for showing datetime calender[Start]
	public native String showCalender(String id, String calFormat)
	/*-{
		try
		{
			return $wnd.getDateTimeField(id, calFormat);
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;
	//Added by sunny soni for showing datetime calender[End]
	// Added by Bhupendra on 2-11-17 for displaying proper view port area on focused filed Start
	public native static void showScrollToViewInput( String inputId )
	/*-{
		try
		{
			var input = $doc.getElementById(inputId);
			$wnd.scrollToViewInput( input );
		}
		catch(e)
		{
			console.log(e);
		}
	}-*/;
	// Added by Bhupendra on 2-11-17 for displaying proper view port area on focused filed End

	public native void setSuggestBoxElement(int top, int totalTop)
	/*-{
		try
		{
			var x = $doc.getElementsByClassName('e12-SuggestBoxPopup');
			var xTop = top;
			var totTop = totalTop;
			//console.log($doc.body);
			if(x.length > 0)
			{
				x = x[0];
				x.style.top = xTop + 'px';
				if( xTop <= totTop )
				{
					console.log('inside setSuggestBoxElement true ==> '+x.style.zIndex);
					x.style.display = 'none';
				}
				else
				{
					console.log('inside setSuggestBoxElement false ==> '+x.style.zIndex);
					x.style.display = 'block';
				}
			}
		}
		catch( e )
		{
			console.log( "getSuggestBoxElement - ["+ e +"]" );
		}
	 }-*/;

	public native String getTitle(Element previousElement,String className)
	/*-{
		try
		{
			var title = "";
			var firstElem;
			firstElem = previousElement.querySelector(className);
			if(firstElem)
			title = firstElem.getAttribute("title");
			return title;
		}
		catch(e)
		{
			console.log(e);
		}
	}-*/;

	//Added by shrutika on 20-03-17 [Start] for on/off toggle
	//change by shrutika on 27-08-19 for chnage toggle color according to application color
	//public native void initializeToggleOnOff(String fldName, String fldValue, String transmode)
	public native void initializeToggleOnOff(String fldName, String fldValue, String transmode, String cssName)
	/*-{
		console.log("initializeToggleOnOff......["+cssName+"]");
	 	try
		{
			//change by shrutika on 27-08-19 for chnage toggle color according to application color
			//$wnd.initializeToggleOnOff(fldName, fldValue, transmode);
			$wnd.initializeToggleOnOff(fldName, fldValue, transmode, cssName);
		}
		catch(e)
		{
			console.log(e);
		}
	}-*/;
	//Added by shrutika on 20-03-17 [End] for on/off toggle

	// added by vishal pathare on 11.1.16 [for screen should be properly arranged so that we can type easily]Start.
	public native int getElementProperty(Element e, String property)
	/*-{
		if (e)
		{
			var rect = e.getBoundingClientRect();
			return rect[property];
		}
			return 0;
		}-*/;
	// added by vishal pathare on 11.1.16 [for screen should be properly arranged so that we can type easily]End.

	public native void initRating(boolean readonly, String count, String rating, Element element, com.google.gwt.core.client.Callback<String , String> callback)
	/*-{
		console.log('initRating:::'+rating+"\nreadOnly::"+readonly);
		var nodeList = element.childNodes;
		console.log(nodeList);
		var len = nodeList.length;
		console.log(len + " :: " + count);
		var precision = "1";
		if (len != count)
		$wnd.$(function ($) {
		var that = this;
		var toolitup = $("#jRate").jRate({
		rating: rating,
		strokeColor: 'black',
		backgroundColor: 'grey',
		precision: 1,
		minSelected: 0,
		width: "25",
    	height: "35",
		startColor: "yellow",
    	endColor: "yellow",
		count: count,
		max: count,
		shapeGap: '3px',
		precision: precision,
		readOnly: readonly,
		touch: true,
		onChange: function(rating) {
		console.log("OnChange: Rating: "+rating);
		callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(""+rating);
		},
		onSet: function(rating) {
			console.log("OnSet: Rating: "+rating);
			callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(""+rating);
		}
		});
		});
		$wnd.$("#jRate").prop("disabled", true);
	}-*/;

	/*Added by Pankaj T on 16-11-16 new method insignia called from insignia.js for format textwithclass [Start]*/
	public native String insignia(String fldValue, String transMode, String title, String jsonData)
	/*-{
		try
		{
			//alert("in native js");
			console.log("in native js");
			var html = $wnd.insignia(fldValue, transMode, title, jsonData);
			return 	html;
		}
		catch(e)
		{
			console.log(e);
		}
	}-*/;
	/*Added by Pankaj T on 16-11-16 new method insignia called from insignia.js for format textwithclass [End]*/

	//Added new method's by Pankaj T on 29-11-16 for new format bipolar [Start]
	/**
	 * Initialize map component
	 * @param id
	 * @param latlang
	 */
	public native void initMap(String id, String latlang)
	/*-{
		try
		{
			console.log("initmap");
			$wnd.initMap(id, latlang);
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;

	/**
	 *
	 * Added for removing marker on map.
	 * @param position
	 * @param id
	 */
	public native void removePoint(int position, String id)
	/*-{
		try
		{
			console.log("In removePoint position::"+position);
			$wnd.removePoint(position, id);
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;

	/**
	 * Added for getting place address of search location on map.
	 * @return
	 */
	public native String getPlaceValue()
	/*-{
		console.log("In getPlaceValue......");
		try
		{
		  var placeAddress = $wnd.getPlaceValue();
		  console.log("Place address::"+placeAddress);
		  return placeAddress;
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;

	/**
	 * Added for setting the value of selected loactions to field.
	 */
	public native void setLocations()
	/*-{
		try
		{
		  console.log("In setLocations......");
		  $wnd.setLatLong(false, true);
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;
	//Added new method's by Pankaj T on 29-11-16 for new format bipolar [End]

	//added by Sunny Soni on 10-10-16 for setValue of JSON[Start]
	public native String setValue(String jsonData, String transMode, String format, String deviceOS)
	/*-{
		try
		{
			console.log('SetValue Called....');
			//return $wnd.setValue(jsonData, transMode, format);--previous
			return $wnd.setValue(jsonData, transMode, format, deviceOS);//Added by sunny soni new parameter "deviceOS".
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;

	//Added new method's by Pankaj T on 14-09-16 [Start] [Req:S16FBAS007]
	//public native void scanBarcode( com.google.gwt.core.client.Callback<String , String> callback)
	public native void scanBarcode( String deviceOS, com.google.gwt.core.client.Callback<String , String> callback)
	/*-{
		var params = {
		    flash: "off" // defaults to "auto"
		};
		//Added conditiuon for IOS Qr code scanner[05-Jan-18]START
		if( deviceOS == 'IOS' )
		{
			$wnd.cordova.plugins.barcodeScanner.scan(
			function (result) {
			    callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(""+result.text);
			},
			function (error) {
				alert("Scanning failed: " + error);
			  	callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)(""+error);
			},
			{
		          //preferFrontCamera : true, // iOS and Android
		          showFlipCameraButton : true, // iOS and Android
		          showTorchButton : true, // iOS and Android
		          //torchOn: true, // Android, launch with the torch switched on (if available)
		          //saveHistory: true, // Android, save scan history (default false)
		          //prompt : "Place a barcode inside the scan area", // Android
		          //resultDisplayDuration: 500, // Android, display scanned text for X ms. 0 suppresses it entirely, default 1500
		          formats : "QR_CODE,PDF_417", // default: all but PDF_417 and RSS_EXPANDED
		          orientation : "landscape", // Android only (portrait|landscape), default unset so it rotates with the device
		          disableAnimations : true, // iOS
		          disableSuccessBeep: false // iOS and Android
      		}
			);
		}
		//Added conditiuon for IOS Qr code scanner[05-Jan-18]END
		else
		{
			$wnd.cloudSky.zBar.scan(params,
			function (result) {
			    callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(""+result);
			},
			function (error) {
				alert("Scanning failed: " + error);
			  	callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)(""+error);
			}
			);
		}

	}-*/;
	//Added new method's by Pankaj T on 14-09-16 [End] [Req:S16FBAS007]

	//Added new method's by Pankaj T on 24-08-16 [Start] [S16EBAS016]
	/**
	 * Initialize map component
	 * @param id
	 * @param latlang
	 */
	public native void initialize(String id, String latlang)
	/*-{
		try
		{
		  console.log("initializemap");
		  $wnd.initialize(id, latlang);
		}
		catch(e)
		{
		  console.log(e);
		}
	 }-*/;

	/**
	 * Initialize ToggleSwitch of Yes/No format
	 * @param fldName
	 * @param fldValue
	 * @param transmode
	 */
	//change by shrutika on 27-08-19 for chnage toggle color according to application color
	//public native void initializeToggle(String fldName, String fldValue, String transmode)
	public native void initializeToggle(String fldName, String fldValue, String transmode, String cssName)
	/*-{
		console.log("initializeToggle....5089["+cssName+"]");
		//change by shrutika on 27-08-19 for chnage toggle color according to application color
		//$wnd.initializeToggle(fldName, fldValue, transmode);
		$wnd.initializeToggle(fldName, fldValue, transmode, cssName);

		}-*/;

	/**
	 * Initialize knob component
	 * @param id
	 * @param callback
	 */
	public native void knob(String id, com.google.gwt.core.client.Callback<String , String> callback)
	/*-{
		console.log("in knob id::"+id);
		try
		{
			$wnd.$(function($) {
		        $("."+id).knob({
		            change : function (value) {
		                //console.log("change : " + value);
		            },
		            release : function (value) {
		                //console.log(this.$.attr('value'));
		                console.log("release : " + value);
		                callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(""+value);
		            },
		            cancel : function () {
		                console.log("cancel : ", this);
		            }
		        });
			    	});
		}
		catch(e)
		{
			alert("exception:::"+e);
		}
	 }-*/;

	/**
	 * Change knob value after scroll the knob
	 * @param value
	 * @param id
	 */
	public native void changeKnobVal(String value, String id)
	/*-{
		console.log("changeKnobVal:"+value+"----id::"+id);
		$wnd.$("."+id)
		        .val(value)
		        .trigger('change');
	}-*/;

	/**
	 * check input key
	 * @param key
	 * @return
	 */
	public boolean checkKey(int key)
	{
		return (key == 8 || key == 9 || key == 13 || key == 46 ||
				key == 110 || key == 190 ||
				(key >= 35 && key <= 40) || (key >= 48 && key <= 57) ||
				(key >= 96 && key <= 105)
				);
	}

	/**
	 * check input validation for number
	 * @param key
	 * @return
	 */
	public native boolean checkInput(String key)
	/*-{
		try
		{
			var reg = new RegExp('^[0-9]+$');
			if (reg.test(key))
			{
			    //alert('valid');
			    return true;
			}
			else
			{
			    //alert('invalid');
			    return false;
			}
		}
		catch(e)
		{
		  console.log(e);
		}
	}-*/;

	/**
	 * Initialize rating component
	 * @param readonly
	 * @param count
	 * @param rating
	 * @param element
	 * @param callback
	 */
// Added by Jay.kesur {To call Touch event for 5 Star rating system} [29-Mar-2023]-Start	
	public native void initRating(String id, boolean readonly, String count, String rating, boolean setRatingVal,
			Element element, com.google.gwt.core.client.Callback<String, String> callback)
	/*-{
		console.log('initRating:' + rating + "\nreadOnly:" + readonly
				+ "\nsetRatingVal:" + setRatingVal);
		console.log('id is:' + id);
		var nodeList = element.childNodes;
		console.log(nodeList);
		var len = nodeList.length;
		console.log(len + " :: " + count);
		var precision = "1";
		if (len != count) {
			$wnd
					.$(function($) {
						var that = this;
						var toolitup = $("#" + id)
								.jRate(
										{
											rating : rating,
											strokeColor : 'black',
											backgroundColor : 'grey',
											precision : 1,
											minSelected : 0,
											width : "25",
											height : "35",
											startColor : "yellow",
											endColor : "yellow",
											count : count,
											max : count,
											shapeGap : '3px',
											precision : precision,
											readOnly : readonly,
											touch : true,
											onChange : function(rating) {
												console
														.log("OnChange called: Rating: "
																+ rating);
												callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)("" + rating);
											},
											onTouch : function(rating) {
												console.log("onTouch: Rating: "
														+ rating);
												callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(""+rating);
											},
											onSet : function(rating) {
												console.log("OnSet: Rating: "
														+ rating);
												callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)("" + rating);
											}
										});

						$("#" + id).prop("disabled", true);

						var touchHandler = function(event) {
							var touches = event.changedTouches, firstTouch = touches[0], type = "";
							switch (event.type) {
							case "touchend":
								type = "click";
								break;
							default:
								return;
							}

							var simulatedEvent = document
									.createEvent("MouseEvent");
							simulatedEvent.initMouseEvent(type, true, true,
									window, 1, firstTouch.screenX,
									firstTouch.screenY, firstTouch.clientX,
									firstTouch.clientY, false, false, false,
									false, 0, null);
							firstTouch.target.dispatchEvent(simulatedEvent);
							event.preventDefault();
						};

						$("#" + id)[0].addEventListener("touchend",
								touchHandler, true);
					});
		}
	}-*/;
	// Added by Jay.kesur {To call Touch event for 5 Star rating system} [29-Mar-2023]-End	

	//Added by Bhupendra M on 20-03-18 to check whether to validate from pophelp according to VALIDATE_DATA Start
	public native void exportFieldErrorTooltipMessage()
	/*-{
	     try
		 {
		    console.log("111 exportFieldErrorTooltipMessage ");
		 	$wnd.displayMessageInCompact = function( ImgElement , SpanElement)
			{
				console.log('calling js exportFieldErrorTooltipMessage displayMessageInCompact');
				SpanElement.style.display = "block";
				var imgLeft = ImgElement.offsetLeft;
				SpanElement.style.left = imgLeft - 16+"px";
			};

			$wnd.displayNoneInCompact = function(ImgElement , SpanElement)
		 	{
		 	    console.log('calling js exportFieldErrorTooltipMessage displayNoneInCompact');
				SpanElement.style.display = "none";
			};
		 }
		 catch(e)
		 {
		 	console.log("Exception in exportFieldErrorTooltipMessage ",e);
		 }

	}-*/;
	//Added by Bhupendra M on 20-03-18 to check whether to validate from pophelp according to VALIDATE_DATA End

	//Added by shrutika on 25-05-18 [Start] for working scroll functionality in case of suggestbox.
	public native void ScrollSuggestBox()
	/*-{
		try
		{
			var selectedItem = $doc.getElementsByClassName( "item-selected" )[0];
			if( selectedItem )
			{
				selectedItem.scrollIntoViewIfNeeded(false);
			}
		}
		catch( ex )
		{
			console.log( "Exception in ScrollSuggestBox - ["+ ex +"]" );
		}
	}-*/;
	//Added by shrutika on 25-05-18 [End] for working scroll functionality in case of suggestbox.

	//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked] - Start
	//For ios provide uuid after reinstall app uuid will be change
	public native String getIMEINumber()
	/*-{
		try
		{
			console.log("In getIMEINumber native method.");
			var self = this;
			var global = @ibase.e12ria.client.E12Global::getInstance()();

			var onSuccess = function(deviceInfo)
			{
				console.log("In getIMEINumber native method IMEI number in success:["+deviceInfo.imei+"]");
				global.@ibase.e12ria.client.E12Global::setDeviceIMEINo(Ljava/lang/String;)(""+deviceInfo.imei);
			};
			var onError = function(error)
			{
				console.log("In getIMEINumber native method IMEI number in error:["+error+"]");
			};
			//$wnd.plugins.device.getInfo( onSuccess, onError );
			$wnd.plugins.deviceImei.getDeviceIMEI( onSuccess, onError );
		}
		catch(e)
		{
			alert("getIMEINumber::Exception in native method ["+e.message+"]");
			console.log("getIMEINumber::Exception in native method ["+e+"]");
		}
	}-*/;
	//Added By Pankaj T. on 18-06-18 for device security based on enterprise level [0-disabled, 1-strictly enforced, 2-OTP, 3-workflow invoked] - End

	//Added by Pankaj T. on 29-06-18 added dummy methods to calculate total for propertyinfo columns and display as a summary in side panel popup option - start
	private ArrayList<String> propertyInfoColumnList = new ArrayList<>();

	public ArrayList<String> getPropertyInfoColumnList() {
		return propertyInfoColumnList;
	}

	public void setPropertyInfoColumnList(ArrayList<String> propertyInfoColumnList) {
		this.propertyInfoColumnList = propertyInfoColumnList;
	}

	private ArrayList<HashMap<String, String>> propertyInfoFieldList = new ArrayList<>();

	public ArrayList<HashMap<String, String>> getPropertyInfoFieldList() {
		return propertyInfoFieldList;
	}

	public void setPropertyInfoFieldList(ArrayList<HashMap<String, String>> propertyInfoFieldList) {
		this.propertyInfoFieldList = propertyInfoFieldList;
	}

	private HashMap<String, String> totalSummaryMap = new HashMap<>();

	public HashMap<String, String> getTotalSummaryMap() {
		return totalSummaryMap;
	}

	public void setTotalSummaryMap(HashMap<String, String> totalSummaryMap) {
		this.totalSummaryMap = totalSummaryMap;
	}

	private HashMap<String, HashMap<String, String>> fieldWiseAmountMap = new HashMap<>();

	public HashMap<String, HashMap<String, String>> getFieldWiseAmountMap() {
		return fieldWiseAmountMap;
	}

	public void setFieldWiseAmountMap(HashMap<String, HashMap<String, String>> fieldWiseAmountMap) {
		this.fieldWiseAmountMap = fieldWiseAmountMap;
	}
	//Added by Pankaj T. on 29-06-18 added dummy methods to calculate total for propertyinfo columns and display as a summary in side panel popup option - end

	//Change by Sandeep S. on 20-JUL-18 [Deactivating DataModel on client if data goes dirty on server] Start
	protected void updateDirtyDataModel(String objName)
	{
		try
		{
			HashMap<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("ACTION", "UPDATE_DIRTY_DATAMODEL" );
			paramMap.put("OBJ_NAME", objName );
			paramMap.put("NO_OF_FORMS", ""+ObjDetails.get( objName ).getNoOfForms() );

			String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
			String url = "/ibase/RIADataSyncServlet?" + paramString;

			RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.POST, url );
			try
			{
				requestBuilder.sendRequest( null, new RequestCallback()
				{
					public void onError( Request request, Throwable exception )
					{

					}
					public void onResponseReceived( Request request, Response response )
					{

					}
				});
			}
			catch( RequestException ex )
			{
				E12CommonUtils.printOnConsole(" RequestException in updateDirtyDataModel ==>  "+ex.toString());
			}
		} catch (Exception e)
		{
			E12CommonUtils.printOnConsole(" Exception in updateDirtyDataModel ==>  "+e.toString());
		}
	}
	//Change by Sandeep S. on 20-JUL-18 [Deactivating DataModel on client if data goes dirty on server] End

	//Added by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [START]
	private native void changeIconOnAction(Element feedElement, String colName, String colValue)
	/*-{
		var selectedFeed = feedElement.querySelector('.unConfirmedFlag');
		console.log(selectedFeed);
		console.log("colName : "+colName);
		console.log("colValue : "+colValue);

		if(selectedFeed)
		{
			var colValue = colValue;
			if(colName.toUpperCase() === 'CONFIRM_COL' && colValue )
			{
				console.log("changeIconOnAction 1.....");
				selectedFeed.className = 'confirmFlag';
			}
			else if (colName.toLowerCase() === 'CANCEL_COL' && colValue)
			{
				selectedFeed.className = 'cancelFlag';
			}
			else if (colName.toLowerCase() === 'IN_WF_COL' && colValue)
			{
				selectedFeed.className = 'inWfFlag';
			}
			else
			{
				selectedFeed.className = 'unConfirmedFlag';
			}
		}
	}-*/;
	//Added by Pankaj R on 23-JUL-18 to auto refresh & change the color of dot on home page [START]

	//Added by shrutika on 03-08-18 for getting tab orderwise xml.(Dummy method)
	public void getTabOrderWiseCopyData(String objName, int formNo, final String xmlstr, final String DomId, final ArrayList PrimaryKeyFieldLst, final ArrayList headerKeylist, final String keyFlag)
	{

	}

	//Added by shrutika on 31-07-18 [Start] for open phone dialer and email.
	public void callPhoneDialer( final String mobileNo )
	{
		E12CustomPlugin.openPhoneDialer( new E12CustomPlugin.CallBack() {

			@Override
			public void onSuccess( String result )
			{
				E12CommonUtils.printOnConsole("inside callPhoneDialer....result["+result+"]");
			}

			@Override
			public void onError( String error )
			{
				E12CommonUtils.printOnConsole("Exception while call phone dialer ["+error+"]");
				E12CommonUtils.printOnConsole( "Exception while getting GeoFence Records ["+error+"]" );
			}
		}, mobileNo );
	}

	public void callMailId( final String mailId )
	{
		E12CustomPlugin.openMail( new E12CustomPlugin.CallBack() {

			@Override
			public void onSuccess( String result )
			{
				E12CommonUtils.printOnConsole("inside callMailId....result["+result+"]");
			}

			@Override
			public void onError( String error )
			{
				E12CommonUtils.printOnConsole("Exception while call mail componant ["+error+"]");
				E12CommonUtils.printOnConsole( "Exception while getting GeoFence Records ["+error+"]" );
			}
		},mailId );
	}

	public native void callWebUrl( String webUrl )
	/*-{
			try
			{
				console.log("inside callWebUrl...27219..["+webUrl+"]");
				$wnd.OpenWebUrl( webUrl );
			}
			catch(e)
			{
				console.log("Error in callWebUrl:...42503"+e);
			}
	}-*/;

	public native void callComposeMail( String mailId )
	/*-{
			try
			{
				console.log("inside callComposeMail...27219..["+mailId+"]");
				$wnd.Openmailformat( mailId );
			}
			catch(e)
			{
				console.log("Error in callComposeMail:...42503"+e);
			}
	}-*/;
	public  boolean isValidEmail(String email)
	{
		String emailRegex = "^[a-zA-Z0-9_+&*-]+(?:\\."+
				"[a-zA-Z0-9_+&*-]+)*@" +
				"(?:[a-zA-Z0-9-]+\\.)+[a-z" +
				"A-Z]{2,7}$";
		//Pattern pat = Pattern.compile(emailRegex);
		RegExp regExp = RegExp.compile(emailRegex);
		MatchResult matcher = regExp.exec(email);
		boolean matchFound = matcher != null;
		if (email == null)
			return false;
		return matchFound;
		//return pat.matcher(email).matches();
	}
	//Added by shrutika on 31-07-18 [End] for open phone dialer and email.


	//Added by Prajyot on 06-AUG-18 [ For implementation of Link Type - A] Start
	protected String getJsonParam(ArrayList< String> sourceField , ArrayList< String > targetField, ArrayList<String> dataGridHeaderLogicalColName, boolean isAnyRowSelected, DataGridTableRowModel selectedDGTRModel, HashMap< String,String > feedDataMap, String fieldName  )
	{
		String qryString ="";
		JSONObject qryJson = new JSONObject();
		try
		{
			E12CommonUtils.printOnConsole( "getJsonParam fieldName : ["+ fieldName +"]" );
			//HashMap<String, String> queryParamsMap = new HashMap<String, String>();
			if( fieldName != null && fieldName.trim().length() == 0 )
			{
				fieldName = "STRG_CODE";
			}
			qryJson.put("fieldName", new JSONString(fieldName));
			for(int srcFldcnt=0 ; srcFldcnt<  sourceField.size(); srcFldcnt++)
			{
				String columnName = sourceField.get( srcFldcnt );
				String paramName = targetField.get( srcFldcnt );
				if ( dataGridHeaderLogicalColName != null && dataGridHeaderLogicalColName.contains( columnName ) && isAnyRowSelected )
				{
					if ( selectedDGTRModel == null && feedDataMap != null )
					{
						String paramValue = feedDataMap.get(columnName);
						//queryParamsMap.put(paramName, paramValue);
						qryJson.put(paramName, new JSONString(paramValue));
					}
					else if ( selectedDGTRModel != null )
					{
						String paramValue = selectedDGTRModel.getCellText( columnName );
						//queryParamsMap.put(paramName, paramValue);
						qryJson.put(paramName, new JSONString(paramValue));
					}
				}
				else if ( feedDataMap != null && feedDataMap.containsKey( columnName ) )
				{
					String paramValue = feedDataMap.get( columnName );
					//queryParamsMap.put(paramName, paramValue);
					qryJson.put(paramName, new JSONString(paramValue));
				}
				else
				{
					//queryParamsMap.put(paramName, columnName);
					qryJson.put(paramName, new JSONString(columnName));
				}
			}
			//qryString = getEncodedParamString(queryParamsMap);
			qryString = qryJson.toString();
			E12CommonUtils.printOnConsole( "getJsonParam qryString : ["+ qryString +"]" );
		}
		catch(Exception e)
		{
			Window.alert( "Exception in getJsonParam[" + e.getMessage() + "]");
		}
		return qryString;
	}
	//Added by Prajyot on 06-AUG-18 [ For implementation of Link Type - A] End

	//Added by shrutika on on 27-08-18 [start] for getting tab header data of xml for copy functionality.
	public String getXmlTag( String xmlData, String objContext, String domID, String[] arrayTabOrder )
	{
		return "";
	}

	public String TabSeparatedDataForAllFormData( String xmlData, String objContext, String[] arrayTabOrder)
	{
		return "";
	}
	//Added by shrutika on 27-08-18 [End] for getting tab header data of xml for copy functionality.

	//Added by Sandeep S on 11-SEP-18 [Notify user and refresh data model when gets dirty] Start
	public static void updateDatamodelFromNotification( String dataModel, String scopeParameters, final Callback<String, String> callback )
	{
		E12CommonUtils.printOnConsole( "updateDatamodelFromNotifiication dataModel : ["+ dataModel +"]" );
		if( !"".equalsIgnoreCase(E12CommonUtils.checkNull(dataModel) ) )
		{
			//String dataModel = redirectPath.substring(redirectPath.indexOf("dataModelName")+"dataModelName".length()+1);
			E12CommonUtils.printOnConsole( "updateDatamodelFromNotifiication dataModel : ["+ dataModel +"]" );
			//storeDataModelListForRefresh(dataModel, scopeParameters);
			new E12DataModelHandler().getDataModel(dataModel, scopeParameters, new Callback<String, String>() {

				@Override
				public void onFailure(String reason) {
					E12CommonUtils.printOnConsole( "updateDatamodelFromNotifiication onFailure : ["+ reason +"]" );
					if( callback != null )
					{
						callback.onFailure(reason);
					}
				}

				@Override
				public void onSuccess(String result) {
					E12CommonUtils.printOnConsole( "updateDatamodelFromNotifiication onSuccess : ["+ result +"]" );
					if( callback != null )
					{
						callback.onSuccess(result);
					}
				}
			});
		}
	}

	public static void storeDataModelListForRefresh( final String dataModel, final String scopeParameters )
	{
		try
		{
			E12Storage.getItem("refresh_datamodel_list-"+E12Constants.userID, new Callback<String, String>() {

				@Override
				public void onFailure(String reason) {
					E12CommonUtils.printOnConsole("onFailure inside storeDataModelListForRefresh ===> "+reason);
				}

				@Override
				public void onSuccess(String result) {
					E12CommonUtils.printOnConsole("result ===> "+result);
					if( checkNull(result).length() > 0 )
					{
						String[] dmArray = result.split("~~~");
						boolean flag = true;
						E12CommonUtils.printOnConsole("dmArray ===> "+dmArray);
						E12CommonUtils.printOnConsole("dmArray length ===> "+dmArray.length);
						for( int i = 0; i < dmArray.length; i++ )
						{
							String dmArrayItem = dmArray[i];
							dmArrayItem = dmArrayItem.replace("[", "");
							dmArrayItem = dmArrayItem.replace("]", "");
							E12CommonUtils.printOnConsole("dmArrayItem "+dmArrayItem);
							String[] dataArray = dmArrayItem.split("\\$\\$");
							E12CommonUtils.printOnConsole("dataArray ===> "+dataArray);
							if( dataArray.length == 3 )
							{
								String storageDMName = checkNull(dataArray[0]);
								E12CommonUtils.printOnConsole("datamodel "+storageDMName);
								storageDMName = storageDMName.substring(storageDMName.indexOf("datamodel")+"datamodel".length()+1);
								E12CommonUtils.printOnConsole("actual datamodel "+storageDMName);
								if( storageDMName.equalsIgnoreCase(dataModel) )
								{
									int count = 1;
									String oldKey = "";
									String oldScopeParameter = dataArray[1];
									if( !"".equalsIgnoreCase(checkNull(dataArray[2])) )
									{
										String cnt = dataArray[2];
										cnt = cnt.substring(cnt.indexOf("count")+"count".length()+1);
										if( !"".equalsIgnoreCase( cnt ) )
										{
											count = Integer.parseInt(cnt) + 1;
										}
										oldKey = "[datamodel="+dataModel+"$$"+oldScopeParameter+"$$count="+cnt+"]~~~";
									}
									E12CommonUtils.printOnConsole("oldKey "+oldKey);
									String appendData = "[datamodel="+dataModel+"$$scopeparameter="+scopeParameters+"$$count="+count+"]";
									E12CommonUtils.printOnConsole("Before replace  "+result);
									result = result.replace(oldKey, "");
									E12CommonUtils.printOnConsole("After replace  "+result);
									String updateData = "";
									if( result.length() > 0 )
									{
										updateData = result + "~~~" + appendData;
									}
									else
									{
										updateData = appendData + "~~~";
									}
									E12CommonUtils.printOnConsole("Replacing new data");
									E12Storage.setItem("refresh_datamodel_list", updateData);
									flag = false;
									break;
								}
							}
						}
						if( flag )
						{
							E12CommonUtils.printOnConsole("Appending new data");
							String appendData = "[datamodel="+dataModel+"$$scopeparameter="+scopeParameters+"$$count=1]";
							String updateData = result + "~~~" + appendData;
							E12Storage.setItem("refresh_datamodel_list-"+E12Constants.userID, updateData);
						}
					}
					else
					{
						E12CommonUtils.printOnConsole("Adding new data");
						String appendData = "[datamodel="+dataModel+"$$scopeparameter="+scopeParameters+"$$count=1]~~~";
						E12Storage.setItem("refresh_datamodel_list-"+E12Constants.userID, appendData);
					}
				}
			});
		} catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception inside storeDataModelListForRefresh ===> "+e);
		}
	}
	//Added by Sandeep S on 11-SEP-18 [Notify user and refresh data model when gets dirty] End
	//Added by shrutika on 20-09-18 [Start] for suggest box UI related changes.
	public native void suggestBoxStyle(int suggestBoxWidth)
	/*-{
		try
		{
			var SuggestBoxPopupEle = $doc.getElementsByClassName('e12-SuggestBoxPopup');
			var suggestPopupContentEle = $doc.getElementsByClassName('suggestPopupContent');
			var itemEle= $doc.getElementsByClassName('item');
			var imgEle = $doc.getElementsByClassName('e12-suggestBoxPopupImage');
			var suggestWidth = suggestBoxWidth;
			var lines = 2;
			console.log('inside suggestBox width 4446..['+suggestWidth+']');
			if(suggestWidth > 0)
			{
				 for (var i = 0; i < SuggestBoxPopupEle.length; i++) {
        			SuggestBoxPopupEle[i].style.width=(suggestWidth+'px');
    			}

    			 for (var j= 0; j < suggestPopupContentEle.length; j++) {
        			suggestPopupContentEle[j].style.maxWidth=(suggestWidth - 10+'px');
        			suggestPopupContentEle[j].style.width=(suggestWidth - 10+'px');
    			}

    			 for (var k = 0; k < itemEle.length; k++) {
    			 	//change by shrutika on 21-09-18 for display selected suggest box with proper width.
        			//itemEle[k].style.width=(suggestWidth -15+'px');
        			itemEle[k].style.width=(suggestWidth -26+'px');
					itemEle[k].style.display = 'inline-flex';
        			itemEle[k].style.overflow = 'hidden';
        			itemEle[k].style['align-items'] = 'center';
        			itemEle[k].style.height = 'auto';
    			}

    			for (var l = 0; l < imgEle.length; l++) {
        			imgEle[l].style['vertical-align'] = 'middle';
					imgEle[l].style.height = 'auto';
    			}
			}
		}
		catch( e )
		{
			console.log( "Exception in getSuggestBoxStyleElement 4457!!!["+ e +"]" );
		}
	}-*/;
	//Added by shrutika on 20-09-18 [End] for suggest box UI related changes.

	//Added by Prasad on 26/08/18 [implementation of action handler b - presentation detail in e-detailing] START
	private void CallBServiceHandler( String dataModelFileName, final E12ParentEditor e12ParentEditor )
	{
		new E12DataModelHandler().getDefaultDataModel( dataModelFileName, "", "", false, new Callback<String, String>() {
			@Override
			public void onSuccess(String result) {
				//printOnConsole( "result : ["+ result +"]" );
				if ( result != null && result.length() > 0 )
				{
					JSONValue valueJson = getJSON( result );
					//printOnConsole( "valueJson : ["+ valueJson +"]" );
					if ( valueJson != null )
					{
						JSONArray valueJsonArr = valueJson.isArray();
						//printOnConsole( "valueJsonArr : ["+ valueJsonArr +"]" );
						if ( valueJsonArr.size() > 0 )
						{
							E12Global.getInstance().setLoading(true);
							filterJSONData( valueJson, "", new Callback<String, String>() {

								@Override
								public void onFailure(String reason) {
									E12CommonUtils.printOnConsole("response from filterJSONData onFailure === "+reason);
									E12Global.getInstance().setLoading(false);
								}

								@Override
								public void onSuccess(String result) {
									E12CommonUtils.printOnConsole("response from filterJSONData onSuccess === "+result);
									E12Global.getInstance().setLoading(false);
									JSONValue valueJson = getJSON( result );
									if ( valueJson != null )
									{
										JSONArray valueJsonArr = valueJson.isArray();
										JSONObject valueJsonObj = valueJsonArr.get( 0 ).isObject();
										if ( valueJsonObj != null && valueJsonObj.get( "PRES_DETAIL" ) != null )
										{
											String detailData = valueJsonObj.get( "PRES_DETAIL" ).toString();
											//Added by sunny soni for get PresentationPlayerJsonData with some adding login details json[Start]
											String finalDetailData = getEditedPresentationData(detailData);
											//Added by sunny soni get PresentationPlayerJsonData with some adding login details json[End]
											String funcName = "setContentUsage";
											long instanceId = new Date().getTime();
											String openInstanceId = ""+ instanceId;

											setCallbackFunctionForPresentationPlayer( funcName, openInstanceId, e12ParentEditor );
											//openPresentationPlayer( detailData, funcName, openInstanceId, new Callback<String, String>() {
											openPresentationPlayer( finalDetailData, funcName, openInstanceId, new Callback<String, String>() {
												@Override
												public void onSuccess(String result) {
													E12CommonUtils.printOnConsole( "Inside openInNativeApp :: onSuccess() : result [" + result + "]" );
												}

												@Override
												public void onFailure(String reason) {
													Window.alert(reason);
													//e12ParentEditor.getPageUtil().getCardViewForm().performLocalItemChange( "usageDetailData", "", "", "", "" );
												}
											});
										}
									}
								}
							});
						}
					}
				}
			}

			@Override
			public void onFailure(String reason) {
				// TODO Auto-generated method stub
			}
		});
	}
	//Added by sunny soni for get PresentationPlayerJsonData with some adding login details json[Start]
	private String getEditedPresentationData(String detailData)
	{
		JSONObject editedDetailData = null;
		try
		{
			JSONValue jsonVal = JSONParser.parseStrict(detailData);
			editedDetailData = jsonVal.isObject();
			JSONObject loginDetails = E12Constants.getLoginDetails();
			editedDetailData.put("LOGIN_DETAILS", loginDetails);
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception::[ "+e.getMessage()+" ]");
			e.printStackTrace();
		}
		//E12CommonUtils.printOnConsole("Final editedData::[ "+editedDetailData+" ]");
		return editedDetailData.toString();
	}
	//Added by sunny soni for get PresentationPlayerJsonData with some adding login details json[End]
	//Added by sunny soni for setting login map[Start]
	public static HashMap<String, String> getLoginDetailsMap()
	{
		HashMap<String, String> loginDetailsMap = new HashMap<String, String>();
		try
		{
			loginDetailsMap.put("USER", E12Constants.userID);
			loginDetailsMap.put("PASSWORD", E12Constants.passwordSha256);
		}
		catch(Exception ae)
		{
			E12CommonUtils.printOnConsole("***Exception::[ "+ae.getMessage()+" ]");
		}
		E12CommonUtils.printOnConsole("loginDetailsMap:::[ "+loginDetailsMap+" ]");
		return loginDetailsMap;
	}
	//Added by sunny soni for setting login map[End]
	private native void setCallbackFunctionForPresentationPlayer( String functionName, String openInstanceId, E12ParentEditor e12ParentEditor )
	/*-{
		var self = this;
		//$wnd[functionName] = function(selectedOption) {
			$wnd[functionName] = function(selectedOption, annotData) { //Added by sunny soni for getting annotation data
			selectedOption = selectedOption || '';
			//delete $wnd[functionName];
			//Added by sunny soni for prevent function deletion while save option select on 11-April-19[Start]
			if (selectedOption.toLowerCase().indexOf('save') === -1) {
				delete $wnd[functionName];
			}
			//Added by sunny soni for prevent function deletion while save option select on 11-April-19[End]

			var handleResponse = function( usageData ) {
				console.log( "usageData : ["+ usageData +"]" );

				var pageUtil = e12ParentEditor.@ibase.e12ria.e12widgets.client.E12ParentEditor::getPageUtil()();
				var cardView = pageUtil.@ibase.e12ria.e12widgets.client.ParentUtil::getCardViewForm()();
				cardView.@ibase.e12ria.e12widgets.client.ME12CardViewForm::performLocalItemChange(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)( "usageDetailData", "", "", "", usageData );
			}

			if (selectedOption.toLowerCase().indexOf('done') > -1)
			{
				console.log( "on done data" );
				self.@ibase.e12ria.client.E12CommonUtils::getUsageDataForDevice(Ljava/lang/String;Lcom/google/gwt/core/client/JavaScriptObject;)( openInstanceId, handleResponse );
			}
			//Added by sunny soni for storing annotation data on 11-April-19[Start]
			if(annotData)
			{
				var annotationData = JSON.stringify(annotData);
				self.@ibase.e12ria.client.E12CommonUtils::saveAnnotationDataJsonObjectString(Ljava/lang/String;)(annotationData);
			}
			//Added by sunny soni for storing annotation data on 11-April-19[End]
		};
	}-*/;
	//Added by sunny soni for storing annotation data[start]
	private void saveAnnotationDataJsonObjectString(String annotDataArr)
	{
		try
		{
			JSONValue jsonValue = JSONParser.parseStrict(annotDataArr);
			JSONObject annotationJsonObject = jsonValue.isObject();
			if( annotationJsonObject != null )
			{
				JSONValue  docIdJsonVal = annotationJsonObject.get( "DOC_ID" );
				String AnnotationData = annotationJsonObject.get("ANNOTATION_DATA").toString();
				String  docId = docIdJsonVal.isString() !=null	 ? docIdJsonVal.isString().stringValue() : "";

				HashMap<String, String> paramMap = new HashMap<String, String>();
				paramMap.put( "ACTION", "STORE_ANNOT_DATA" );
				paramMap.put( "ANNOT_DATA", AnnotationData );
				paramMap.put( "DOC_ID", docId );

				String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
				String url = E12Global.getHostUrl()+"/ibase/WebITMDocumentHandlerServlet?"+paramString;

				RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url);
				try
				{
					requestBuilder.sendRequest("", new RequestCallback() {
						@Override
						public void onResponseReceived(Request request, Response response)
						{
							String responseStr = response.getText();
							if("success".equalsIgnoreCase(responseStr))
							{
								E12CommonUtils.printOnConsole("[saveAnnotationDataJsonObjectString] stored annotation records.[ "+responseStr+" ]");
							}
							else
							{
								E12CommonUtils.printOnConsole("[saveAnnotationDataJsonObjectString] Failed to store annotation records.[ "+responseStr+" ]");
							}
						}
						@Override
						public void onError(Request request, Throwable exception)
						{
							E12CommonUtils.printOnConsole("[saveAnnotationDataJsonObjectString] onError::: "+exception.getMessage());
						}
					});
				}
				catch (RequestException e)
				{
					E12CommonUtils.printOnConsole("[saveAnnotationDataJsonObjectString] RequestException::: "+e.getMessage());
					e.printStackTrace();
				}
			}
			else
			{
				E12CommonUtils.printOnConsole("[saveAnnotationDataJsonObjectString] No Annotation json object Found. ");
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	//Added by sunny soni for storing annotation data[end]
	private native void getUsageDataForDevice(String key, JavaScriptObject jsObj)
	/*-{
		if ($wnd.plugins && $wnd.plugins.logReader) {

			$wnd.plugins.logReader.getAllLogs(key, function(data) {

				if (jsObj) {
					try {
						console.log( "data : ["+ data +"]" );
						jsObj( data );
					} catch (ex) {
						$wnd.console.log("Exception  : " + ex);
					}
				}

			});
		} else {
			$wnd.console.log("window.plugins.logReader not found !");
		}
	}-*/;

	private native void openPresentationPlayer( String detailData, String functionName, String openInstanceId, Callback<String, String> callback )
	/*-{
		try
		{
	 		$wnd.plugins.PresentationPlayer.play
			(
				[detailData, openInstanceId, functionName],
				callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;),
				callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)
			);
		}
		catch (ex)
		{
			callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)("Exception : " + ex);
		}
	}-*/;

	private native JSONValue getJSON(String json) /*-{
		var _jsonVal;
		try {
			var _json = window.eval(json);
			console.log(_json);
			_jsonVal = @com.google.gwt.json.client.JSONArray::new(Lcom/google/gwt/core/client/JavaScriptObject;)(_json);
		} catch (ex) {
			_jsonVal = null;
		}
		return _jsonVal;
	}-*/;

	private native static void filterJSONData( JSONValue jsonStr, String exprToFilter, com.google.gwt.core.client.Callback<String, String> callback)
	/*-{
		try
		{
			var jsonString = jsonStr;
			var expressionToFilter = exprToFilter;
			var filterJSON = $wnd.filterBrandJSON(jsonString,expressionToFilter,function(resp)
			{
				callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(resp);
			});
		}
		catch( ex )
		{
			console.log( "Exception in E12CommonUtils Native filterBrandJSON - ["+ ex +"]" );
		}
	}-*/;
	//Added by Prasad on 26/08/18 [implementation of action handler b - presentation detail in e-detailing] END
	//Added by shrutika on 09-10-18 [Start] for display previous value in case of exception occur in itemchange.
	public native void setValuetofield( String id, String preValue)
	/*-{
			try
			{
				console.log("inside setValuetofield...5230["+id+"]preValue["+preValue+"]");
				var textfield = $doc.getElementById(id);
				if( textfield != null )
				{
					textfield.value = preValue;
				}
			}
			catch(e)
			{
				console.log("Error in setValuetofield:...5237"+e);
			}
	}-*/;
	//Added by shrutika on 09-10-18 [End] for display previous value in case of exception occur in itemchange.

	//Changes made by Pratheek on 10-01-19[to get the landscape or potrait mode ]-Start
	public native String orientationType()
	/*-{
	     try
		 {
		 	var currentMode = screen.orientation.type;
		     console.log("currentMode| 5774!!!["+currentMode);
		 }
		 catch(e)
		 {
		 	console.log("Error msg in device mode:"+e);
		 }
		 return currentMode;

	}-*/;
	//Changes made by Pratheek on 10-01-19[to get the landscape or potrait mode ]-End
	//Added by shrutika on 18-02-19 [Start] for add shortcuts of detail feed navigation and add another button.
	public void feedNavigation( String action , List<Feed> feedList)
	{

	}
	//Added by shrutika on 05-02-19 [End] feed navigation not working in case of search functionality.
	public native static boolean isFocus(String id)
	/*-{
			try
			{
		  		var elmnt = $doc.getElementById(id);
				if( elmnt != null && elmnt != undefined )
				{
					var isFocused = ($doc.activeElement === elmnt);
					return isFocused;
				}
			}
			catch (e)
			{
				console.log( "Exception inside isFocus method..5778");
			}
			return false;
	}-*/;
	//Added by shrutika on 05-02-19 [End] feed navigation not working in case of search functionality.

	//Added by Pravin K on 5-MARCH-19 [to read OTP SMS] STSRT
	public native void readOtpSMS(Callback<String, String> callback)/*-{
		var smsRetriever = $wnd.cordova && $wnd.cordova.plugin && $wnd.cordova.plugin.smsretiever;
	 	console.log("SMSRetriever : "+smsRetriever);
		if(typeof smsRetriever !== 'undefined') {
		    smsRetriever.startSmsRetriever(function(message){

		          console.log("readOtpSMS otp message : "+message);
		          var patt = new RegExp("\\w*\\d+\\w*");
				  console.log("patt :"+patt);
				  var result = patt.exec(message);
				  console.log(".readOtpSMS result ::"+result+"");
		          if(result){
					  var otp = result+"";
					  otp = otp.trim()
					  console.log(".readOtpSMS OTP .:"+otp);
	        	 	  callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(otp);
		          }
		    },function(errMsg){
		        if(errMsg === 'Timed out'){
	              //Play services unable to retrieve the SMS to your app for one of these reasons
	              //1. SMS received but not constructed properly (Something wrong in your App's hashstring
	              //2. SMS not received from last 5 minutes.
	        	 	console.log("otp message Error :",errMsg);
	        	 	callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)(errMsg+"");

		        }else{
	        	 	callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)("Failed to start retriever listner");
			       	console.log("Failed to start retriever listner");
		        }
		    });
		}
		else		{
    	 	callback.@com.google.gwt.core.client.Callback::onFailure(Ljava/lang/Object;)("SMSRetriever is undefined");
			console.log(" else type of SMSRetriever.."+smsRetriever);
		}
	}-*/;
	//Added by Pravin K on 5-MARCH-19 [to read OTP SMS] END

	//Added by shrutika on 13-03-19 [Start] for issue when open process from tab and error occur on any action then focus not set.
	public native static void setFocusOnErrorField(String id)
	/*-{
			try
			{
		  		var elements = $doc.querySelectorAll("[id='"+id+"']");
				if( elements != null && elements != undefined )
				{
					var eleLen = elements.length;
				    for( var i=0; i<eleLen; i++ )
				    {
						if( elements[i] != null && elements[i].offsetParent != null )
						{
							elements[i].focus();
							break;
						}
				    }
				}
			}
			catch (e)
			{
				console.log( "Exception inside setFocusOnErrorField");
			}
	}-*/;
	//Added by shrutika on 13-03-19 [End] for issue when open process from tab and error occur on any action then focus not set.
	//Added by Sagar B. to get Itemchange filter expression data for IC from Datamodel[08-May-19]START
	public static native String callForICFilterExprData( String editorObjName, int currentFormNo, String fldName )
	/*-{
		try
		{
			console.log('calling callForICFilterExprData method !!');
			return $wnd.localICFilterExprData( editorObjName, currentFormNo, fldName );
	    }
	    catch(e)
	    {
	    	console.log('localICFilterExprData method is not found.....!!');
	    	return '';
	    }
	 }-*/;
	//Added by Sagar B. to get Itemchange filter expression data for IC from Datamodel[08-May-19]END

	//Added by shrutika on 21-05-19 [Start] for draw tax related fields in tax screen.
	public final HashMap<String, ClickHandler> taxCommand = new HashMap<>();
	//Change by shrutika on 20-06-19 [Start] for add tax image when there is no label for text field.
	//public void addTaxImage( E12CustomInput customInput, final E12ParentEditor e12ParentEditor )
	//public void addTaxImage( E12CustomInput customInput, final E12ParentEditor e12ParentEditor, String labelText)
	public void addTaxImage( E12CustomInput customInput, final E12ParentEditor e12ParentEditor, String labelText, final int formNo, final String domId, String fieldValue )
	{

		try
		{
			final Label taxImage = new Label();
			taxImage.getElement().setAttribute("style", "padding-right: 9px;");
			taxImage.getElement().setId("TaxImageId");
			taxImage.addStyleName( "subHeaderTaxFormDetail" );
			//Change by shrutika on 20-06-19 [Start] for add tax image when there is no label for text field.
			//customInput.addLabel(taxImage);
			if("".equalsIgnoreCase(labelText))
			{
				taxImage.getElement().setAttribute("style", "margin-top: 0px !important;padding-right: 9px;");
				customInput.addLabel(taxImage, false);
			}
			else
			{
				customInput.addLabel(taxImage, true);
			}
			//Change by shrutika on 20-06-19 [Start] for add tax image when there is no label for text field.
			taxImage.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {

					if( e12ParentEditor != null )
					{
						e12ParentEditor.setTaxActionClick(true);
					}
					if( e12ParentEditor.getPageUtil() != null )
					{
						if( e12ParentEditor.getPageUtil().getFeedDataMap() != null )
						{
							String taxFormFeedKey = E12CommonUtils.checkNull( e12ParentEditor.getPageUtil().getFeedDataMap().get("titleKey")+"_subFeed" );
							PanelLabel panelLabel = e12ParentEditor.getPageUtil().taxFormFeedPLMap.get( taxFormFeedKey );
							if( panelLabel != null )
							{
								panelLabel.getCommand().execute();
							}
						}
					}
				}
			});
		}
		catch (Exception e) {
			// TODO Auto-generated catch block
			E12CommonUtils.printOnConsole("Exception inside addTaxImage["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	public StringBuilder getCurrentDomIdString( int formNo, String allFormData, String currentDetaildomId, boolean isFromDoneClick )
	{
		StringBuilder currentFormXml = new StringBuilder("");
		try
		{
			Document allFormDataDoc = XMLParser.parse(allFormData);
			String detail = "Detail"+formNo;
			NodeList rootNode = allFormDataDoc.getElementsByTagName(detail);
			if(rootNode !=null )
			{
				for ( int i = 0; i < rootNode.getLength(); i++)
				{
					Node curDetail = rootNode.item(i);
					String currDomId = getAttribValue(curDetail, "domID");
					if( currDomId.equalsIgnoreCase(currentDetaildomId))
					{
						NodeList chidNodeList = curDetail.getChildNodes();
						if( isFromDoneClick )
						{
							for( int j = 0; j < chidNodeList.getLength(); j++ )
							{
								Node currChildNode = chidNodeList.item(j);
								if( currChildNode.getNodeName().equalsIgnoreCase("Taxes"))
								{
									curDetail.removeChild(currChildNode);
								}
							}
						}
						currentFormXml.append(curDetail.toString());
						return currentFormXml;
					}
				}
			}
			return currentFormXml;
		}
		catch (Exception e) {
			// TODO Auto-generated catch block
			E12CommonUtils.printOnConsole("Exception inside getCurrentDomIdString["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return currentFormXml;
	}
	//Added by shrutika on 21-05-19 [End] for draw tax related fields in tax screen.

	public native void selectAll( String id )
	/*-{
		try
		{
			var elementId = id;
			var element = $doc.getElementById(elementId);
			if( element != null )
			{
				console.log('inside all selectAll...10680');
				element.select();
			}
		}
		catch( e )
		{
			console.log( "select all exception - ["+ e +"]" );
		}

	}-*/;
	//Added by shrutika on 28-06-19 [End] for tax amount field related changes.
	public void applyExpandCollapseFunction( final String objName)
	{

	}
	//Added by shrutika on 28-06-19 [End] for tax amount field related changes.

	//Added by shrutika on 16-07-18 [Start] for calculate tax according to the user Preference.
	public void setUserPreference( String objName, String prefName, String prefVal, String prefValType )
	{
		try
		{
			HashMap<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("ACTION", "SET_USER_PREF");
			paramMap.put("OBJ_NAME", objName);
			paramMap.put("PREF_NAME", prefName);
			paramMap.put("PREF_VAL", prefVal);
			paramMap.put("PREF_VAL_TYPE", prefValType);
			String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);

			String url = "/ibase/WebITMRequestHandlerServlet?" + paramString;
			E12RequestBuilder requestBulider = new E12RequestBuilder(E12RequestBuilder.POST, url) ;
			requestBulider.setLoadingRequired( false );
			requestBulider.sendRequest(paramMap, new RequestCallback() {
				@Override
				public void onResponseReceived(Request request, Response response) {
					String responseStr = response.getText();
					printOnConsole( "setUserPreference[" +responseStr+ "]");
				}

				@Override
				public void onError(Request request, Throwable exception) {

				}
			});
		}
		catch (Exception e)
		{
			printOnConsole("Exception in setUserPreference ["+ e.getMessage() +"]");
		}
	}
	public void updateObjDetailXML( String objName, final String prefName, final String prefVal )
	{
		try
		{
			final String storageKey = "ACTION_LINK_XML_"+ E12Constants.userID + "_" + objName;
			//String objDtlResponse = E12Storage.getItem( storageKey );
			E12Storage.getItem( storageKey , new Callback<String, String>()
			{
				@Override
				public void onSuccess(String result )
				{
					try
					{
						String objDtlResponse = E12CommonUtils.checkNull( result );
						if( objDtlResponse != null && objDtlResponse.length() > 0 )
						{
							E12CommonUtils.printOnConsole("inside updateObjDetailXML.....6968 prefName["+prefName+"]prefVal["+prefVal+"]");
							Document document = XMLParser.parse( objDtlResponse );
							document.getElementsByTagName( prefName ).item(0).getFirstChild().setNodeValue( prefVal );
							E12Storage.setItem(storageKey, document.toString());
						}
					}
					catch (Exception e)
					{
						E12CommonUtils.printOnConsole("Exception in onSuccess updateObjDetailXML::["+e.getMessage()+"]");
					}
				}
				@Override
				public void onFailure(String reason)
				{
				}

			});
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in updateObjDetailXML::["+e.getMessage()+"]");
		}
	}
	//Added by shrutika on 16-07-18 [End] for calculate tax according to the user Preference.

	//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - start
	//Added by shrutika on 27-02-19 [Start] for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
	String currentLinkId = "";
	public String getCurrentLinkId() {
		return currentLinkId;
	}
	public void setCurrentLinkId(String currentLinkId) {
		this.currentLinkId = currentLinkId;
	}
	//Added by shrutika on 27-02-19 [End] for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.

	PopupPanel popupPanel = null;
	public PopupPanel getPopupPanel() {
		return popupPanel;
	}
	public void setPopupPanel(PopupPanel popupPanel) {
		this.popupPanel = popupPanel;
	}
	//Changed By Pankaj T. on 08-07-2019 for open process trail in mobile same like browser - end
	//Added by Sainath T. on 29-08-19-[To get Notification data] Start
	private String getNotificationData(String toRedirectPath)
	{
		E12CommonUtils.log("getNotificationData[" + toRedirectPath+ "]");
		String notificationData = "";
		try
		{
			notificationData = toRedirectPath.substring(toRedirectPath.lastIndexOf("~response~"));
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in getNotificationData" + e.getMessage());
			notificationData = toRedirectPath;
		}
		E12CommonUtils.printOnConsole("notificationData1314[" + notificationData + "]");
		return notificationData ;
	}
	//Added by Sainath T. on 29-08-19-[To redirect when received Notification] End

	//Added by Prasad on 14/09/19 [add new in menu panel] START
	public void getObjDetails( final String objName, final String objType, final Callback<Boolean, Boolean> callBack )
	{
		String storageKey = "ACTION_LINK_XML_" + E12Constants.userID + "_" + objName;
		E12Storage.getItem( storageKey , new Callback<String, String>()
		{
			@Override
			public void onSuccess(String serverResponse )
			{
				String objDtlResonse = serverResponse;
				if( objDtlResonse != null && objDtlResonse.length() > 0 )
				{
					E12CommonUtils.printOnConsole( "In setObjActionsResponse - 1" );
					setObjActionsData( objName, objDtlResonse );
					callBack.onSuccess( true );
				}
				else
				{
					E12CommonUtils.printOnConsole( "In setObjActionsResponse - 2" );
					HashMap<String, String> paramMap = new HashMap<String, String>();

					paramMap.put("ACTION", "OBJ_DETAILS");
					paramMap.put("OBJ_NAME", objName);
					paramMap.put("PAGE_CTX", "1");
					paramMap.put("dummyInt", ""+Math.random());
					paramMap.put("OBJ_TYPE", ""+E12CommonUtils.checkNull(objType));
					String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);

					String url = E12Global.getHostUrl()+ "/ibase/WEBITMRIARequestHandlerServlet?" + paramString;

					RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET, url );
					try
					{
						requestBuilder.sendRequest( null, new RequestCallback() {

							@Override
							public void onResponseReceived(Request request,	Response response)
							{
								try
								{
									if( E12Global.getInstance().checkErrorException(response, 1) )
									{
										String storageKey = "ACTION_LINK_XML_"+ E12Constants.userID + "_" + objName;
										E12Storage.setItem( storageKey, response.getText() );
										setObjActionsData( objName, response.getText() );
										callBack.onSuccess( true );
									}
								}
								catch(Exception ex)
								{
									E12CommonUtils.printOnConsole("Error in response received "+ex.getMessage());
									callBack.onSuccess( false );
								}
							}
							
							@Override
							public void onError(Request request, Throwable exception) 
							{
								Window.alert( "Error : " + exception.getMessage() );
								callBack.onSuccess( false );
							}
						});
					}
					catch(Exception e)
					{
						Window.alert( "Error while setting object response in local sotrage: " + e.getMessage());
					}
				}
			}
			@Override
			public void onFailure(String reason)
			{

			}
		});
	}
	
	private void setObjActionsData( String objName, String respXMLStr )
	{
		try
		{
			E12CommonUtils.printOnConsole( "In setObjActionsData" );
			Document document = XMLParser.parse( respXMLStr );

			NodeList formNumLst = document.getElementsByTagName( "Form" );
			if( formNumLst != null && formNumLst.item(0) != null )
			{
				int noOfForms = formNumLst.getLength();
				ObjDetails.get( objName ).setNoOfForms( noOfForms );
				ObjDetails.get( objName ).createFormPKFields( formNumLst );
			}

			NodeList tempNodeLst = document.getElementsByTagName("rights_str") ;
			String userRightsStr = "";
			if( tempNodeLst != null && tempNodeLst.item(0) != null && tempNodeLst.item(0).hasChildNodes() )
			{
				try
				{
					userRightsStr = tempNodeLst.item(0).getFirstChild().getNodeValue();
				}
				catch (Throwable t)
				{
					userRightsStr = "";
					E12CommonUtils.printOnConsole("Error while reading userRightsStr...");
				}
			}
			E12CommonUtils.printOnConsole("in setObjActionsData - userRightsStr - ["+ userRightsStr +"]");
			ObjDetails.get( objName ).setUserRigths(userRightsStr);
			tempNodeLst = null;

			tempNodeLst = document.getElementsByTagName("REF_SER");
			String objRefSer = "";
			if( tempNodeLst != null && tempNodeLst.item(0) != null && tempNodeLst.item(0).hasChildNodes() )
			{
				try
				{
					objRefSer = tempNodeLst.item(0).getFirstChild().getNodeValue();
				}
				catch (Throwable t)
				{
					objRefSer = "";
					E12CommonUtils.printOnConsole("Error while reading objRefSer...");
				}
			}
			E12CommonUtils.printOnConsole("in setObjActionsData - objRefSer - ["+ objRefSer +"]");
			ObjDetails.get( objName ).setRefSer( objRefSer );

			try
			{
				String tranId ="";
				if( document.getElementsByTagName("TRAN_ID_COL").item(0) !=null && document.getElementsByTagName("TRAN_ID_COL").item(0).getFirstChild() != null)
				{
					tranId = document.getElementsByTagName("TRAN_ID_COL").item(0).getFirstChild().getNodeValue();
				}
				ObjDetails.get( objName ).setTranIdCol( tranId );
			}
			catch(Exception e)
			{
				
			}

			String siteCodeVal = "";
			if( document.getElementsByTagName("SITE_ACC_COL").item(0) != null  && document.getElementsByTagName("SITE_ACC_COL").item(0).getFirstChild() != null  )
			{
				siteCodeVal = document.getElementsByTagName("SITE_ACC_COL").item(0).getFirstChild().getNodeValue();
			}
			E12CommonUtils.printOnConsole("in setObjActionsData - without tag siteCodeVal - 2997!!!["+ siteCodeVal +"]");
			ObjDetails.get( objName ).setSiteAccColVal(siteCodeVal);
			
			//Added by Prasad on 03/11/19 [to set min and max attachment required] START
			try
			{
				String attachCountMin ="";
				if( document.getElementsByTagName("ATTACH_COUNT_MIN").item(0) !=null && document.getElementsByTagName("ATTACH_COUNT_MIN").item(0).getFirstChild() != null)
				{
					attachCountMin = document.getElementsByTagName("ATTACH_COUNT_MIN").item(0).getFirstChild().getNodeValue();
				}
				ObjDetails.get( objName ).setAttachCountMin( attachCountMin );
			}
			catch(Exception e)
			{
				
			}
			
			try
			{
				String maxAttachAllow ="";
				if( document.getElementsByTagName("MAX_ATTACH_ALLOW").item(0) !=null && document.getElementsByTagName("MAX_ATTACH_ALLOW").item(0).getFirstChild() != null)
				{
					maxAttachAllow = document.getElementsByTagName("MAX_ATTACH_ALLOW").item(0).getFirstChild().getNodeValue();
				}
				ObjDetails.get( objName ).setMaxAttachAllow( maxAttachAllow );
			}
			catch(Exception e)
			{
				
			}
			
			try
			{
				String minAttachReq ="";
				if( document.getElementsByTagName("MIN_ATTACH_REQ").item(0) !=null && document.getElementsByTagName("MIN_ATTACH_REQ").item(0).getFirstChild() != null)
				{
					minAttachReq = document.getElementsByTagName("MIN_ATTACH_REQ").item(0).getFirstChild().getNodeValue();
				}
				ObjDetails.get( objName ).setMinAttachReq( minAttachReq );
			}
			catch(Exception e)
			{
				
			}
			//Added by Prasad on 03/11/19 [to set min and max attachment required] END
		}
		catch(Exception e)
		{
			E12CommonUtils.printOnConsole( "Exception in setObjActionsData : "+e.getMessage() );
		}
	}
	//Added by Prasad on 14/09/19 [add new in menu panel] END
	//Added by Sagar B. to set form data from attachment vision sense callback[18-Sep-19]START
	//Changed by Amey W. [To get Number of attachments] on 21-02-2020
	public static native String callLocalICforAttachment( String objContext, String fieldName, String domId, String objFormName, JSONArray fieldValue, String noOfAttchments )
	/*-{
		try
		{
			console.log('calling callLocalICforAttachment method !!');
			return $wnd.localICforAttachment( objContext, fieldName, domId, objFormName, fieldValue, noOfAttchments );
		}
		catch(e)
		{
			 console.log('6444 callLocalICforAttachment method is not found.....!!');
			 return '';
		}
	 }-*/;
	//Added by Sagar B. to set form data from attachment vision sense callback[18-Sep-19]END
	//Added by Sagar B. for Select/Deselect All action impl in mobile[22-Nov-19]START
	public String editTransXMLData( String resultxml , String currDomID, String selected, int formNo )
	{
		try 
		{
			E12CommonUtils.printOnConsole("\n E12CommonUtils ****************$$ 111 \n");
			Document document = XMLParser.parse( resultxml );
		    document.getDocumentElement().normalize();
		    NodeList detailNodeList = document.getElementsByTagName("Detail"+formNo);
		    E12CommonUtils.printOnConsole("E12CommonUtils total no of details -to edit-["+detailNodeList.getLength()+"]");
		   	for( int i=0; i<detailNodeList.getLength(); i++ )
		   	{
//		   		E12CommonUtils.printOnConsole("\n ****************$$ 222 \n "+i);
		   		Node detailNode = detailNodeList.item(i); 
		   		if (detailNode.hasAttributes() )
			     {
			         // get attributes names and values
			         NamedNodeMap nodeMap = detailNode.getAttributes();
			         for (int j = 0; j < nodeMap.getLength(); j++)
			         {
			              Node tempNode = nodeMap.item(j);
			              if( "domID".equalsIgnoreCase( tempNode.getNodeName( ) ) )
			              {
			            	  //DomId matched here
			            	  if( currDomID == null || currDomID.equalsIgnoreCase( tempNode.getNodeValue() ) )
			            	  {
//			            		  E12CommonUtils.printOnConsole("\n ****************$$ DomId matched \n");
		     			         Node attrSelectedNode =  nodeMap.getNamedItem("selected");
		     			         if( attrSelectedNode != null )
		     			         {
		     			        	 attrSelectedNode.setNodeValue( selected );
		     			         }
			            		  
			            		  NodeList detailChildList = detailNode.getChildNodes();
			            			for (int k = 0; k <detailChildList.getLength(); k++)
			            	   		{
			            	   			Node childNode = detailChildList.item(k);//selects items one by one

			            	   			if(childNode.getNodeType() == Node.ELEMENT_NODE && !"attribute".equalsIgnoreCase(childNode.getNodeName()))
			            	   			{
			            	   				if( childNode.getFirstChild() != null )
			            	   				{
			            	   					String nodeName = childNode.getNodeName();
			            	   					String nodevalue = childNode.getFirstChild().getNodeValue();
		            	   						E12CommonUtils.printOnConsole("--E12CommonUtils ***---changing value of nodeName ["+nodeName+"] --SETTING value--updatedNodeValue ["+nodevalue+"]");
		            	   						childNode.getFirstChild().setNodeValue( nodevalue );
			            	   				}
			            	   			}
			            	   			else
			            	   			{
			            	   				if( "attribute".equalsIgnoreCase(childNode.getNodeName()) )
			            	   				{
			            	   					if( childNode.hasAttributes() )
			            	   					{
			            	   						 NamedNodeMap attrNodeMap = childNode.getAttributes();
			            	   						
				            	   					 Node selectedNode =  attrNodeMap.getNamedItem("selected");
				    		     			         if( selectedNode != null )
				    		     			         {
				    		     			        	selectedNode.setNodeValue( selected );
				    		     			         }
				    		     			         
				    		     			        Node updateFlagNode =  attrNodeMap.getNamedItem("updateFlag");
				    		     			         if( updateFlagNode != null )
				    		     			         {
				    		     			        	if( "Y".equals( selected ) )
				    		     			        	{
				    		     			        		updateFlagNode.setNodeValue( "E" );
				    		     			        	}
				    		     			        	else
				    		     			        	{
				    		     			        		updateFlagNode.setNodeValue( "A" );
				    		     			        	}
				    		     			         }
				    		     			         
				    		     			        Node statusNode =  attrNodeMap.getNamedItem("status");
				    		     			         if( statusNode != null )
				    		     			         {
				    		     			        	if( "Y".equals( selected ) )
				    		     			        	{
				    		     			        		statusNode.setNodeValue( "O" );
				    		     			        	}
				    		     			        	else
				    		     			        	{
				    		     			        		statusNode.setNodeValue( "N" );
				    		     			        	}
				    		     			         }
				    		     			         if( childNode.getAttributes().getNamedItem("ischange") == null )
				    		     			         {
				    		     			        	 ( ( com.google.gwt.xml.client.Element )childNode ).setAttribute("ischange", "Y");
				    		     			         }
				    		     			         else
				    		     			         {
				    		     			        	 ( ( com.google.gwt.xml.client.Element )childNode ).removeAttribute("ischange");
				    		     			         }
			            	   					}
			            	   				}
			            	   			}
			            	   		}
			            	  }
			              }
			          }
			      }
		   	}
//		   	E12CommonUtils.printOnConsole("\n ****************$$ 3333 \n");
		   	document.normalize();
		   	String newSource = document.toString();
		   	resultxml = newSource;
//		   	E12CommonUtils.printOnConsole("\n ****************$$ 444 final --- "+resultxml);
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception In E12CommonUtils while editing xml string ["+e.getMessage()+"]");
		}
		return resultxml;
	}
	//Added by Sagar B. for Select/Deselect All action impl in mobile[22-Nov-19]END
	
	// Added by Pankaj R on 26-DEC-19  Link type to download Datamodel [START]
	private void callToDownloadDMXsl( final String dataModelFileName, final E12ParentEditor e12ParentEditor, final String currObjName,
			final String argsXml, final String feedDataMapXml, final String fieldName, final Callback<String, String> callback)
	{
		new E12DataModelHandler().getDefaultDataModel( dataModelFileName, "", "", false, new Callback<String, String>() {
			@Override
			public void onSuccess(String result) {
				if ( result != null && result.length() > 0 )
				{
					getTransformedWidget(dataModelFileName, currObjName, result, argsXml, feedDataMapXml, fieldName, callback);
				}
			}

			@Override
			public void onFailure(String reason) {
				// TODO Auto-generated method stub
			}
		});
	}
	
	private Widget getTransformedWidget(final String dataModelFileName,final String currentObjName, final String xmlStr, 
			final String argsXml, final String feedDataMapXml, final String fieldName, final Callback<String, String> callback)
	{
		try
		{
			getDataModelXsl(dataModelFileName, currentObjName, new Callback<String, String>() {
				
				@Override
				public void onSuccess(String result) {
					final String xslData = result;
		 			try
		 			{
		 				if( checkNull(xslData).length() > 0 )
 						{
		 					filterXmlData(argsXml, xmlStr, fieldName, feedDataMapXml, new Callback<String, String>() {
		 						
		 						@Override
		 						public void onSuccess(String result) 
		 						{
		 							printOnConsole("filterXmlData result :: "+result);
		 							if( checkNull(result).length() > 0 && ! result.equalsIgnoreCase( "<Root/>"))
		 							{
		 								try
		 								{
		 									XsltProcessor processor = new XsltProcessor();
		 									processor.importSource("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><root>"+ result +"</root>");
		 									processor.importStyleSheet(xslData);
		 									String resultStr = processor.transform();
		 									printOnConsole("xsl and xml transformation : "+resultStr);
		 									callback.onSuccess(resultStr);
		 								}
		 								catch (Exception e) 
		 								{
		 									
		 								}
		 							}
		 							else
		 							{
		 								callback.onSuccess("");
		 							}
		 						}
		 						
		 						@Override
		 						public void onFailure(String reason) {
		 							// TODO Auto-generated method stub
		 						}
		 					});
 						}
		 			} 
		 			catch (Exception e)
		 			{
		 				E12CommonUtils.printOnConsole("Exception while transformation for xsl : "+e.getMessage());
		 			}
					
				}
				
				@Override
				public void onFailure(String reason) {
					// TODO Auto-generated method stub
					
				}
			});
		}
		catch(Exception e)
		{
			printOnConsole("E12CommonUtils.getTransformedWidget() Exception : "+e);
		}
		return null;
	}
	
	public void getDataModelXsl(final String dataModelFileName, final String currentObjName, final Callback<String, String> callback)
	{
		final String e12StorageKey = E12Constants.userID + "_" + dataModelFileName + "_" + "dataModel_xsl";
		HashMap<String, String> paramMap = new HashMap<String, String>();

		paramMap.put("OBJ_NAME", currentObjName);
		paramMap.put("ACTION", "DATA_MODEL_XSL" );
		paramMap.put( "CALLER_INTERFACE", E12UserInfo.getCallerInterface());
		paramMap.put( "DATA_MODEL_NAME", dataModelFileName);
		paramMap.putAll(E12CommonUtils.getLoginDetailsMap());
		
		String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
		final String path = E12Global.getHostUrl() + "/ibase/RIAWizardHandlerServlet?" + paramString ;
	
		E12Storage.getItem(e12StorageKey, new Callback<String, String>() {

			@Override
			public void onFailure(String reason) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void onSuccess(String result) {
				String dataModelXsl = result;
				E12CommonUtils.printOnConsole("In getDataModelXsl 15262 cache ["+dataModelXsl+"]" );
				if( dataModelXsl != null && dataModelXsl.length() > 0 )
				{
					callback.onSuccess(dataModelXsl);
				}
				else
				{
					final E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.GET, path );
					try 
					{
						requestBuilder.sendRequest( "", new RequestCallback() 
						{
							public void onError( Request request, Throwable exception ) 
							{
								Window.alert( E12Constants.constants.setErrMsgAlt() );
							}
							public void onResponseReceived( Request request, Response response ) 
							{
								try
								{
									String dataModelXsl = response.getText();
									E12CommonUtils.printOnConsole( "In getDataModelXsl dataModelXsl["+dataModelXsl+"]" );
									if( dataModelXsl != null && dataModelXsl.length() > 0 && ! dataModelXsl.equalsIgnoreCase( "<Root></Root>" ) )
									{
										E12Storage.setItem(e12StorageKey, dataModelXsl);
										callback.onSuccess(dataModelXsl);
									}
									else
									{
										callback.onSuccess("");
									}
								}
								catch(Exception e)
								{
									E12CommonUtils.printOnConsole("Exception in getDataModelXsl:["+e.getMessage()+"]");
								}
								
							}
						});
					} 
					catch ( RequestException ex ) 
					{
						Window.alert( E12Constants.constants.setExceptionAlt() + " " + ex.getStackTrace() );
					}
				}
			}
		});
	}
	
	public static native void filterXmlData(String argsXml, String dataModelXml, String fieldName, String feedDataXml, Callback<String, String> callback) 
	/*-{
		try
		{
			console.log('filterXmlData method ....!!');
			var filteredXmlData = $wnd.getFilterXmlData(argsXml, dataModelXml, fieldName, feedDataXml);
			callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)(filteredXmlData);
		}
		catch(e)
		{
			console.log('filterXmlData method is not found.....!!');
			callback.@com.google.gwt.core.client.Callback::onSuccess(Ljava/lang/Object;)("filterXmlData method is not found.....!!");
	
		}
	}-*/;
	
	String createXMLTag (String tagName, String value) {
		return ("<" + tagName + "><![CDATA[" + value + "]]></" + tagName + ">");
	}
	
	private String getMapAsXml(HashMap<String, String> map)
	{
		StringBuilder xmlData = new StringBuilder("<Root>");
		if(map != null && map.size() > 0)
		{
			for (Entry<String, String> entry : map.entrySet())
			{
				String key=E12CommonUtils.checkNull(entry.getKey());
				String value=E12CommonUtils.checkNull(entry.getValue());
				xmlData.append(createXMLTag(key, value));
			}
		}
		xmlData.append("</Root>");
		
		return xmlData.toString();
	}
	// Added by Pankaj R on 26-DEC-19  Link type to download Datamodel [END]
	//Added by Sagar B. to update order_of_visit value on form done and delete[15-Jan-2020]START
	/**
	 * To convert map into Json string
	 * @param map
	 * @return json string
	 */
	public static String mapToJson(Map<String, String> map) {
	    String json = "";
	    try
		{
	    	if (map != null && !map.isEmpty()) {
	    		JSONObject jsonObj = new JSONObject();
	    		for (Map.Entry<String, String> entry: map.entrySet()) {
	    			jsonObj.put(entry.getKey(), new JSONString(entry.getValue()));
	    		}
	    		json = jsonObj.toString();
	    	}
		}
	    catch (Exception e) 
		{
			E12CommonUtils.printOnConsole("Exception in mapToJson:::"+e.getMessage());
		}
	    return json;
	}
	/**
	 * Calling local js to change all feeds display metadata on done and delete for form
	 * 
	 * @param objName
	 * @param currentFormNo
	 * @param formName
	 * @param dataMap
	 * @param isDoneSucess
	 */
	public static native String callForAllFeedDisplayData( String objName,	int currentFormNo, String formName, String dataMap, String isDoneSucess )
	/*-{
		try
		{
			console.log('calling callForAllFeedDisplayData method !!');
			return $wnd.callForAllFeedDisplayData( objName, currentFormNo, formName, dataMap, isDoneSucess );
	    }
	    catch(e)
	    {
	    	console.log('callForAllFeedDisplayData method is not found.....!!');
	    	return '';
	    }
	 }-*/;
	//Added by Sagar B. to update order_of_visit value on form done and delete[15-Jan-2020]END
	
	//Changes made by Pratheek on 10-02-2020[ created a dummy method so to show summary page on process screen]-Start
	public void transSavedToSuccess(String tranId, String summaryObjName, E12TransEditor e12TransEditor, Object object,
			Object object2, String string, Object object3) {
		// TODO Auto-generated method stub
	}
	public void getAllFormSummaryXsl(String prevTranId, String wObjName, Object object, Object object2,
			E12ProcessEditor e12ProcessEditor, String allDataXmlStrg, String xslRespStr) {
		// TODO Auto-generated method stub
	}
	//Changes made by Pratheek on 10-02-2020[ created a dummy method so to show summary page on process screen]-End	
	
	//Added by Sagar B for validating date time format[28/02/17]START
	public boolean isValidDateTime( String date )
	{
		DateTimeFormat dtf = DateTimeFormat.getFormat( E12Constants.applDateTime );
		Date applDateTime = null;
		try
		{
			applDateTime = dtf.parse(  date  );
		}
		catch ( IllegalArgumentException e )
		{
			return false;
		}
		return true;
	}
	//Added by Sagar B for validating date time format[28/02/17]END
	
	//Added by shrutika on 13-04-2020 [Start] for display device information on image click on change detail field.
	public void addChgTermImage( E12CustomInput customInput, final E12ParentEditor e12ParentEditor, String labelText, String fieldValue, final FeedData formDataMap )
	{
		
	}
    //Added by shrutika on 13-04-2020 [End] for display device information on image click on change detail field.
	//Added by Mayur on 30-09-20 to set Dimension format values [start]
	public void ExpandCollapseDiamention( final String labelText, final String lenghtId, final String widthId, final String heightId, E12CustomInput customInput, final String objName )
	{
		SimplePanel expandCollapsLbl = new SimplePanel();
        expandCollapsLbl.addStyleName("ExpandCollpaseTaxDetails");
		final Image img = new Image();
		expandCollapsLbl.add(img);
		expandCollapsLbl.getElement().setAttribute("style", "padding-right: 2px;");
		setLenghtId(lenghtId);
		setWidthId(widthId);
		setHeightId(heightId);
		expandCollapsLbl.addDomHandler(new ClickHandler() {
            @Override
			public void onClick(ClickEvent event) {
                String title = img.getElement().getAttribute("status");
				if("Expand".equalsIgnoreCase(title))
				{
					img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsCollapse.svg");
					img.getElement().setAttribute("status", "Collapse");
					showTaxDetails(lenghtId, widthId, heightId);
                    E12CommonUtils.getInstance().setUserPreference( objName, "DIM_DETAILS", "Expand", "String" );
					String key = objName.concat("DIM_DETAILS");
					E12Storage.setItem(key, "Expand");
				}
				else
				{
					img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsExpand.svg");
					img.getElement().setAttribute("status", "Expand");
					hideTaxDetails(lenghtId, widthId, heightId);
                    E12CommonUtils.getInstance().setUserPreference( objName, "DIM_DETAILS", "Collapse", "String" );
					String key = objName.concat("DIM_DETAILS");
					E12Storage.setItem(key, "Collapse");
				}
			}
		}, ClickEvent.getType());
		setExpandCollapseImg(img);
		if("".equalsIgnoreCase(labelText))
		{
			expandCollapsLbl.getElement().setAttribute("style", "padding-right: 10px;");
			customInput.addExpandCollapseforDimention(expandCollapsLbl, false);
		}
		else
		{
			customInput.addExpandCollapseforDimention(expandCollapsLbl, true);
		}
	}
	public void applyDimentionExpandCollapse( final String objName)
	{
		final Image img = getExpandCollapseImg();
		final String storageKey =  objName.concat("DIM_DETAILS");
		E12Storage.getItem( storageKey , new Callback<String, String>()
		{
			@Override
			public void onSuccess(String result )
			{
				try
				{
					if( result.equalsIgnoreCase("Collapse") )
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsExpand.svg");
						img.getElement().setAttribute("status", "Expand");
						hideTaxDetails(lenghtId, widthId, heightId);
					}
					else if( result.equalsIgnoreCase("Expand") )
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsCollapse.svg");
						img.getElement().setAttribute("status", "Collapse");
						showTaxDetails(lenghtId, widthId, heightId);
					}
					else
					{
						getUserPreference(objName, "DIM_DETAILS", img, lenghtId, widthId, heightId);
					}
				}
				catch (Exception e)
				{
					E12CommonUtils.printOnConsole("Exception in applyExpandCollapseFunction::["+e.getMessage()+"]");
				}
			}
			@Override
			public void onFailure(String reason)
			{
			}
        });
	}
	public native static void hideTaxDetails( String taxClassId, String taxChapId, String taxEnvId )
	/*-{
			try
			{
				$wnd.customLog('In hideTaxDetails...6702['+taxClassId+']taxChapId['+taxChapId+']taxEnvId['+taxEnvId+']');
		  		var tax_class = $doc.getElementById(taxClassId);
				if( tax_class != null && tax_class != undefined )
				{
					tax_class.style.display = "none";
				}
				var tax_chap = $doc.getElementById(taxChapId);
				if( tax_chap != null && tax_chap != undefined )
				{
					tax_chap.style.display = "none";
				}
				var tax_env = $doc.getElementById(taxEnvId);
				if( tax_env != null && tax_env != undefined )
				{
					tax_env.style.display = "none";
				}
			}
			catch (e)
			{
				$wnd.customLog( "Exception inside hideTaxDetails");
			}
	}-*/;
	public native static void showTaxDetails( String taxClassId, String taxChapId, String taxEnvId )
	/*-{
			try
			{
				$wnd.customLog('In showTaxDetails...6843['+taxClassId+']taxChapId['+taxChapId+']taxEnvId['+taxEnvId+']');
		  		var tax_class = $doc.getElementById(taxClassId);
				if( tax_class != null && tax_class != undefined )
				{
					tax_class.style.display = "block";
				}
				var tax_chap = $doc.getElementById(taxChapId);
				if( tax_chap != null && tax_chap != undefined )
				{
					tax_chap.style.display = "block";
				}
				var tax_env = $doc.getElementById(taxEnvId);
				if( tax_env != null && tax_env != undefined )
				{
					tax_env.style.display = "block";
				}
			}
			catch (e)
			{
				$wnd.customLog( "Exception inside showTaxDetails");
			}
	}-*/;
	public void getUserPreference( final String objName, String prefName, final Image img, final String taxClassId, final String taxChapId, final String taxEnvId )
	{
		try
		{
			HashMap<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("ACTION", "GET_USER_PREF");
			paramMap.put("OBJ_NAME", objName);
			paramMap.put("PREF_NAME", prefName);
			String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);

			String url = "/ibase/WebITMRequestHandlerServlet?" + paramString;
			E12RequestBuilder requestBulider = new E12RequestBuilder(E12RequestBuilder.POST, url) ;
			requestBulider.setLoadingRequired( false );
			requestBulider.sendRequest(paramMap, new RequestCallback() {
				@Override
				public void onResponseReceived(Request request, Response response) {
					String responseStr = checkNull(response.getText());
					String key = objName.concat("TAX_DETAILS");
					E12Storage.setItem(key, responseStr);
					if( responseStr.equalsIgnoreCase("Collapse") )
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsCollapse.svg");
						img.getElement().setAttribute("status", "Collapse");
					}
					else if( responseStr.equalsIgnoreCase("Expand") )
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsExpand.svg");
						img.getElement().setAttribute("status", "Expand");
					}
					else
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsCollapse.svg");
						img.getElement().setAttribute("status", "Collapse");
					}
					String title = img.getElement().getAttribute("status");
					if("Expand".equalsIgnoreCase(title))
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsCollapse.svg");
						img.getElement().setAttribute("status", "Collapse");
						showTaxDetails(taxClassId, taxChapId, taxEnvId);
					}
					else
					{
						img.setUrl(E12Global.getHostUrl()+"/ibase/images/taxDetailsExpand.svg");
						img.getElement().setAttribute("status", "Expand");
						hideTaxDetails(taxClassId, taxChapId, taxEnvId);
					}
				}

				@Override
				public void onError(Request request, Throwable exception) {

				}
			});
		}
		catch (Exception e)
		{
			printOnConsole("Exception in getUserPreference ["+ e.getMessage() +"]");
		}
	}
	//Added by Mayur on 30-09-20 to set Dimension format values [start]
	
    //Added by shrutika on 04-12-202 [Start] added new format ITEM_CODE to draw attributes dynamically according to item_code/item_type - start
	public native String itemCodeField(String groupBoxId, String fieldName, String id, String label, int formNo, String domId, String applColour)
	/*-{
		try
		{
			$wnd.customLog("in itemCodeField ");
			var html = $wnd.creteItemCode(groupBoxId,fieldName,id,label,formNo,domId, applColour);
			return 	html;
		}
		catch(e)
		{
			$wnd.customLog("Exception inside itemCodeField [["+e);
		}
	}-*/;
	
	public native String setValueToItemCodeFields( String id, String value)
	/*-{
		try
		{
			console.log("setValueToItemCodeFields...............8269...");
			var textfield = $doc.getElementById(id);
			if( textfield != null )
			{
				var previousValue = $wnd.getFldData(textfield.getAttribute("fieldid"));
				console.log("setValueToItemCodeFields...............previousValue",previousValue);
				console.log("setValueToItemCodeFields...............8273");
				textfield.value = value;
				console.log("setValueToItemCodeFields...............fieldid["+textfield.fieldid+"]]]");
				console.log("setValueToItemCodeFields...............fieldid["+textfield.getAttribute("fieldid")+"]]]");
				$wnd.setFldData(textfield.getAttribute("fieldid"), value);
				textfield.focus();
			}
		}
		catch(e)
		{
			$wnd.customLog("Exception inside setValueToItemCodeFields [["+e);
		}
	}-*/;
	
	public native void removeAllItemCodeFormatMap( )
	/*-{
		try
		{
			console.log("inside removeAllItemCodeFormatMap....");
			$wnd.removeItemCodeFormatMap();
		}
		catch(e)
		{
			$wnd.customLog("Exception inside removeAllItemCodeFormatMap [["+e);
		}
	}-*/;
    //Added by shrutika on 04-12-202 [Start] added new format ITEM_CODE to draw attributes dynamically according to item_code/item_type - end
    
    ////added by pramod on 04/07/21 to show call list popup [START]
    public void CallListPopup(String result)
    {
        E12CommonUtils.printOnConsole( " inside CallListPopup method........ ");
        final HashMap<String,JSONObject> hm=new HashMap<String,JSONObject>();

        final PopupPanel pop= new PopupPanel();
        pop.setSize("290px","420px");
        pop.getElement().setAttribute("style","padding : 0px;");
        pop.setGlassEnabled(true);
        pop.setStyleName("contentPluginPopup");
        pop.setGlassStyleName("contentPluginPopupGlass");

        Label lblDone = new Label("Done");
        lblDone.setStyleName("doneButton");
        lblDone.addStyleName("icon-tick");
        lblDone.getElement().getStyle().setColor("#fff");
        lblDone.getElement().setId("CallLog_Done");

        lblDone.addClickHandler(new ClickHandler() 
        {
            @Override
            public void onClick(ClickEvent event) {
                JSONArray doneArray =new JSONArray();
                E12CommonUtils.printOnConsole("onclick done ====>"+hm);
                Iterator<Map.Entry<String, JSONObject>> itr = hm.entrySet().iterator(); 
                while(itr.hasNext())
                {
                    Map.Entry<String, JSONObject> entry = itr.next();
                    E12CommonUtils.printOnConsole(" key ::"+entry.getKey());
                    doneArray.set(doneArray.size(),entry.getValue());
                    E12CommonUtils.printOnConsole("value"+entry.getValue());   
                }
                E12CommonUtils.printOnConsole("Array ::====>>>"+doneArray);

                String done=doneArray.toString();
                E12CommonUtils.printOnConsole("StringArray::====>>>"+done);

                String callLogResult = done;
                HashMap< String, String > paramMap = new HashMap< String, String >();
                paramMap.put( "ACTION", "CALL_LOG_DATA" );
                paramMap.put( "RESULT", callLogResult );
                String paramString = E12CommonUtils.getInstance().getEncodedParamString( paramMap );
                String url = E12Global.getHostUrl()+ "/ibase/RIAWizardHandlerServlet";
                HashMap<String, String> requestDataMap = new HashMap<String, String>();
                requestDataMap.put(RequestDataKeys.REQUEST_DATA, paramString);
                
                E12CommonUtils.printOnConsole( "Inside else of hasread getCallLog :: onTrue() : :result [" + requestDataMap + "]" );

                final E12RequestBuilder requestBuilder2 = new E12RequestBuilder( E12RequestBuilder.POST, url );
                requestBuilder2.setHeader("Content-Type", "application/x-www-form-urlencoded");
                try 
                {
                    requestBuilder2.sendRequest(requestDataMap , new RequestCallback() 
                    {
                        public void onError( Request request, Throwable exception ) 
                        {
                            E12CommonUtils.printOnConsole( " in requestBuilder == onError");
                        }
                        public void onResponseReceived( Request request, Response response ) 
                        {
                            E12CommonUtils.printOnConsole( " in requestBuilder == onResponseRecieved");
                        }
                    });
                } 
                catch ( RequestException ex ) 
                {
                    Window.alert( E12Constants.constants.setExceptionAlt() + " " + ex.getStackTrace() );
                }
                pop.hide();
            }
        });

        Label lblHeading = new Label("CallLog");
        lblHeading.setStyleName("contentPopupTitle");
        lblHeading.getElement().setId("CallLog_Title");
        lblHeading.getElement().getStyle().setColor("#fff");

        Label lblCancel = new Label("Cancel");
        lblCancel.setStyleName("cBackButton");
        lblCancel.addStyleName("icon-back");
        lblCancel.getElement().setId("CallLog_Done");
        lblCancel.getElement().getStyle().setColor("#fff");
        
        lblCancel.addClickHandler(new ClickHandler() 
        {

            @Override
            public void onClick(ClickEvent event) {
                // TODO Auto-generated method stub
                E12CommonUtils.printOnConsole("onclick back <====");
                pop.hide();
            }
        });
                                    
        SimplePanel headerDiv =new SimplePanel();

        HorizontalPanel hpnlHeader =new HorizontalPanel();
        hpnlHeader.addStyleName("contentPluginHeader");
        hpnlHeader.getElement().setAttribute("style","width: 100%;");

        hpnlHeader.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        hpnlHeader.add(lblCancel);
        hpnlHeader.add(lblHeading);
        hpnlHeader.add(lblDone);

        hpnlHeader.setCellHorizontalAlignment(lblCancel, HasHorizontalAlignment.ALIGN_LEFT);
        hpnlHeader.setCellHorizontalAlignment(lblHeading, HasHorizontalAlignment.ALIGN_CENTER);

        hpnlHeader.setCellWidth(lblCancel,"25%");
        hpnlHeader.setCellWidth(lblHeading,"50%");
        hpnlHeader.setCellWidth(lblDone, "25%");
        hpnlHeader.getElement().getStyle().setBackgroundColor("var(--primary, #f8f8f8)");
        hpnlHeader.setCellHorizontalAlignment(lblDone, HasHorizontalAlignment.ALIGN_RIGHT);

        FlowPanel vP=new FlowPanel();
        vP.getElement().setAttribute("style","max-width:290px;max-height:420px;background-color: white;");

        FlowPanel mainPanel=new FlowPanel();
        mainPanel.getElement().setAttribute("style","overflow-y:scroll;height: 380px;");
                                    
        JSONArray Resultarray = (JSONArray) JSONParser.parseStrict(result).isArray();
        
        for(int i=0 ;i< Resultarray.size();i++)
        {
            FlowPanel sp=new FlowPanel();
            sp.getElement().setAttribute("style","display: flex;height: 35px;border-bottom: 1px solid #e5e4e9;padding: 3px;");
            
            final JSONObject obj=(JSONObject)Resultarray.get(i);
            E12CommonUtils.printOnConsole( "obj ===>"+obj );
            final int cn=i;
            final CheckBox cBox=new CheckBox();
            
            cBox.addClickHandler(new ClickHandler() 
            {
                @Override
                public void onClick(ClickEvent event) {
                    E12CommonUtils.printOnConsole("onclick ====>"+cBox.getValue());
                    String getvalue=obj.get("number").isString().stringValue();
                    //getvalue=getvalue+"__"+i;
                    
                    if(cBox.getValue())
                    {
                        hm.put(getvalue+"__"+cn,obj);
                    }
                    else
                    {
                        hm.remove(getvalue+"__"+cn);
                    }
                    E12CommonUtils.printOnConsole( "hm ===>"+hm ); 
                }
            });
            
            String nameVal=obj.get("name").isString().stringValue();
            E12CommonUtils.printOnConsole( "name ===>"+nameVal );
            Label nameLabel=new Label(nameVal);
            nameLabel.getElement().setAttribute("style","padding: 0px 10px;");

            String numVal=obj.get("number").isString().stringValue();
            E12CommonUtils.printOnConsole( "number ===>"+numVal );
            Label numLabel=new Label(numVal);
            numLabel.getElement().setAttribute("style","padding: 0px 10px;");

            sp.add(cBox);
            sp.add(numLabel);
            sp.add(nameLabel);

            mainPanel.add(sp);
        }
        vP.add(hpnlHeader);
        vP.add(mainPanel);
        pop.add(vP);
        pop.center();
    }
    //added by pramod on 04/07/21 to show call list popup [END]
  //Added by sunny soni for loading css with enterprise type on 25-Nov-21[Start]
  	public static void injectCssFile(final String cssFileName) 
  	{
  		try 
  		{	
  			E12CommonUtils.printOnConsole("inside injectCssFile cssFileName::"+cssFileName);
  			E12CommonUtils.printOnConsole("inside injectCssFile E12Global.getInstance().isHostedMode::"+E12Global.getInstance().isHostedMode());
  			if( !E12Global.getInstance().isHostedMode()) 
  			{
  				addEnterpriseLinkCssToHead(cssFileName);
  				return;
  			}
  			LinkElement link = com.google.gwt.dom.client.Document.get().createLinkElement();
  			link.setRel("stylesheet");
  			link.setHref(cssFileName + ".css");
  			nativeAttachToHead(link);
  		}
  		catch (Exception e) {
  			E12CommonUtils.printOnConsole("Exception in injectCssFile::"+e);
  		}		
  	}
  	
  	private static native void nativeAttachToHead(JavaScriptObject scriptElement) /*-{
  		try 
  		{
  			console.log('');
  			$doc.getElementsByTagName("head")[0].appendChild(scriptElement);
  		}
  		catch (ex) {
  			console.log('Exception in nativeAttachToHead:::'+ex);
  		}    	
  	}-*/;
  	private static native void addEnterpriseLinkCssToHead(String enterpriseName) /*-{
		try 
		{
			console.log('addEnterpriseLinkCssToHead enterpriseName::['+enterpriseName+']');
			var linkElem = $doc.createElement('link'); 
			linkElem.setAttribute('rel','stylesheet');
			linkElem.setAttribute('type','text/css');
			//var hrefLink = '../css/' + enterpriseName + '.css';
			//var hrefLink = '../css/testfile.css';
			//var hrefLink = 'testfile.css';
			var hrefLink = enterpriseName + '.css';
			console.log('addEnterpriseLinkCssToHead hrefLink::['+hrefLink+']');
			linkElem.setAttribute('href', hrefLink);
			console.log('addEnterpriseLinkCssToHead linkElem::['+linkElem+']');
			var headTag = $doc.getElementsByTagName('head')[0];
			console.log('addEnterpriseLinkCssToHead headTag::['+headTag+']');
			headTag.appendChild(linkElem);
		}
		catch (ex) {
			console.log('Exception in addEnterpriseLinkCssToHead:::'+ex);
		}    	
	}-*/;
  	//Added by sunny soni for loading css with enterprise type on 25-Nov-21[End]
	//Addd by Pankaj P on 23-May for Dashboard open through objLinks [Start]
	public native static void openAngDashboard(String compName, String compType)
    /*-{
            $wnd.customLog('Calling openComponentANG');
            var dashboardView = $wnd.openComponentANGDashboard(compName, compType);
            $wnd.customLog('1502',dashboardView);
            
    }-*/; 
	//Addd by Pankaj P on 23-May for Dashboard open through objLinks [End]
}